/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.utils.Highlight;

public class PieChartTouchListener
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private static final float MAX_SCALE = Float.MAX_VALUE;
    private static final float MIN_SCALE = 0.5f;
    Matrix matrix = new Matrix();
    Matrix savedMatrix = new Matrix();
    PointF mid = new PointF();
    private static final int NONE = 0;
    private static final int ROTATE = 1;
    private static final int ZOOM = 2;
    private static final int POSTZOOM = 3;
    private static final int LONGPRESS = 4;
    private int mode = 0;
    private float oldDist = 1.0f;
    private PieChart mChart;
    private float mPreviousY = 0.0f;
    private float mPreviousX = 0.0f;
    private Matrix mInverted = new Matrix();
    private GestureDetector mGestureDetector;

    public PieChartTouchListener(PieChart ctx) {
        this.mChart = ctx;
        this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)this);
    }

    public boolean onTouch(View v, MotionEvent e) {
        if (this.mode == 0 && this.mGestureDetector.onTouchEvent(e)) {
            return true;
        }
        float x = e.getX();
        float y = e.getY();
        switch (e.getAction()) {
            case 0: {
                this.mChart.setStartAngle(x, y);
                break;
            }
            case 2: {
                this.mChart.updateRotation(x, y);
                this.mChart.invalidate();
                break;
            }
        }
        this.mPreviousX = x;
        this.mPreviousY = y;
        return true;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void onLongPress(MotionEvent arg0) {
        if (this.mode == 0) {
            this.mode = 4;
        }
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        float distance = this.mChart.distanceToCenter(e.getX(), e.getY());
        if (distance < this.mChart.getRadius() / 2.0f || distance > this.mChart.getRadius()) {
            this.mChart.highlightValues(null);
        } else {
            int index = this.mChart.getIndexForAngle(this.mChart.getAngleForPoint(e.getX(), e.getY()));
            int dataSetIndex = this.mChart.getDataSetIndexForIndex(index);
            if (dataSetIndex == -1) {
                this.mChart.highlightValues(null);
            }
            this.mChart.highlightValues(new Highlight[]{new Highlight(index, dataSetIndex)});
        }
        return true;
    }
}

