/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.PieRadarChartTouchListener;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;

public abstract class PieRadarChartBase<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends Chart<T> {
    private float mRotationAngle = 270.0f;
    private float mRawRotationAngle = 270.0f;
    protected boolean mRotateEnabled = true;
    protected float mMinOffset = 0.0f;

    public PieRadarChartBase(Context context) {
        super(context);
    }

    public PieRadarChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieRadarChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mChartTouchListener = new PieRadarChartTouchListener(this);
    }

    @Override
    protected void calcMinMax() {
    }

    @Override
    public int getMaxVisibleCount() {
        return this.mData.getEntryCount();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mTouchEnabled && this.mChartTouchListener != null) {
            return this.mChartTouchListener.onTouch((View)this, event);
        }
        return super.onTouchEvent(event);
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof PieRadarChartTouchListener) {
            ((PieRadarChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            return;
        }
        this.calcMinMax();
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    public void calculateOffsets() {
        XAxis x;
        float legendLeft = 0.0f;
        float legendRight = 0.0f;
        float legendBottom = 0.0f;
        float legendTop = 0.0f;
        if (this.mLegend != null && this.mLegend.isEnabled() && !this.mLegend.isDrawInsideEnabled()) {
            float fullLegendWidth = Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getFormSize() + this.mLegend.getFormToTextSpace();
            block0 : switch (this.mLegend.getOrientation()) {
                case VERTICAL: {
                    float xLegendOffset = 0.0f;
                    if (this.mLegend.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.LEFT || this.mLegend.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT) {
                        float spacing;
                        if (this.mLegend.getVerticalAlignment() == Legend.LegendVerticalAlignment.CENTER) {
                            spacing = Utils.convertDpToPixel(13.0f);
                            xLegendOffset = fullLegendWidth + spacing;
                        } else {
                            spacing = Utils.convertDpToPixel(8.0f);
                            float legendWidth = fullLegendWidth + spacing;
                            float legendHeight = this.mLegend.mNeededHeight + this.mLegend.mTextHeightMax;
                            MPPointF center = this.getCenter();
                            float bottomX = this.mLegend.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT ? (float)this.getWidth() - legendWidth + 15.0f : legendWidth - 15.0f;
                            float bottomY = legendHeight + 15.0f;
                            float distLegend = this.distanceToCenter(bottomX, bottomY);
                            MPPointF reference = this.getPosition(center, this.getRadius(), this.getAngleForPoint(bottomX, bottomY));
                            float distReference = this.distanceToCenter(reference.x, reference.y);
                            float minOffset = Utils.convertDpToPixel(5.0f);
                            if (bottomY >= center.y && (float)this.getHeight() - legendWidth > (float)this.getWidth()) {
                                xLegendOffset = legendWidth;
                            } else if (distLegend < distReference) {
                                float diff = distReference - distLegend;
                                xLegendOffset = minOffset + diff;
                            }
                            MPPointF.recycleInstance(center);
                            MPPointF.recycleInstance(reference);
                        }
                    }
                    block4 : switch (this.mLegend.getHorizontalAlignment()) {
                        case LEFT: {
                            legendLeft = xLegendOffset;
                            break;
                        }
                        case RIGHT: {
                            legendRight = xLegendOffset;
                            break;
                        }
                        case CENTER: {
                            switch (this.mLegend.getVerticalAlignment()) {
                                case TOP: {
                                    legendTop = Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                                    break block4;
                                }
                                case BOTTOM: {
                                    legendBottom = Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                                }
                            }
                        }
                    }
                    break;
                }
                case HORIZONTAL: {
                    float yLegendOffset = 0.0f;
                    if (this.mLegend.getVerticalAlignment() != Legend.LegendVerticalAlignment.TOP && this.mLegend.getVerticalAlignment() != Legend.LegendVerticalAlignment.BOTTOM) break;
                    float yOffset = this.getRequiredLegendOffset();
                    yLegendOffset = Math.min(this.mLegend.mNeededHeight + yOffset, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent());
                    switch (this.mLegend.getVerticalAlignment()) {
                        case TOP: {
                            legendTop = yLegendOffset;
                            break block0;
                        }
                        case BOTTOM: {
                            legendBottom = yLegendOffset;
                        }
                    }
                }
            }
            legendLeft += this.getRequiredBaseOffset();
            legendRight += this.getRequiredBaseOffset();
            legendTop += this.getRequiredBaseOffset();
            legendBottom += this.getRequiredBaseOffset();
        }
        float minOffset = Utils.convertDpToPixel(this.mMinOffset);
        if (this instanceof RadarChart && (x = this.getXAxis()).isEnabled() && x.isDrawLabelsEnabled()) {
            minOffset = Math.max(minOffset, (float)x.mLabelRotatedWidth);
        }
        float offsetLeft = Math.max(minOffset, legendLeft += this.getExtraLeftOffset());
        float offsetTop = Math.max(minOffset, legendTop += this.getExtraTopOffset());
        float offsetRight = Math.max(minOffset, legendRight += this.getExtraRightOffset());
        float offsetBottom = Math.max(minOffset, Math.max(this.getRequiredBaseOffset(), legendBottom += this.getExtraBottomOffset()));
        this.mViewPortHandler.restrainViewPort(offsetLeft, offsetTop, offsetRight, offsetBottom);
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom));
        }
    }

    public float getAngleForPoint(float x, float y) {
        MPPointF c = this.getCenterOffsets();
        double tx = x - c.x;
        double ty = y - c.y;
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > c.x) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        MPPointF.recycleInstance(c);
        return angle;
    }

    public MPPointF getPosition(MPPointF center, float dist, float angle) {
        MPPointF p = MPPointF.getInstance(0.0f, 0.0f);
        this.getPosition(center, dist, angle, p);
        return p;
    }

    public void getPosition(MPPointF center, float dist, float angle, MPPointF outputPoint) {
        outputPoint.x = (float)((double)center.x + (double)dist * Math.cos(Math.toRadians(angle)));
        outputPoint.y = (float)((double)center.y + (double)dist * Math.sin(Math.toRadians(angle)));
    }

    public float distanceToCenter(float x, float y) {
        MPPointF c = this.getCenterOffsets();
        float dist = 0.0f;
        float xDist = 0.0f;
        float yDist = 0.0f;
        xDist = x > c.x ? x - c.x : c.x - x;
        yDist = y > c.y ? y - c.y : c.y - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        MPPointF.recycleInstance(c);
        return dist;
    }

    public abstract int getIndexForAngle(float var1);

    public void setRotationAngle(float angle) {
        this.mRawRotationAngle = angle;
        this.mRotationAngle = Utils.getNormalizedAngle(this.mRawRotationAngle);
    }

    public float getRawRotationAngle() {
        return this.mRawRotationAngle;
    }

    public float getRotationAngle() {
        return this.mRotationAngle;
    }

    public void setRotationEnabled(boolean enabled) {
        this.mRotateEnabled = enabled;
    }

    public boolean isRotationEnabled() {
        return this.mRotateEnabled;
    }

    public float getMinOffset() {
        return this.mMinOffset;
    }

    public void setMinOffset(float minOffset) {
        this.mMinOffset = minOffset;
    }

    public float getDiameter() {
        RectF content = this.mViewPortHandler.getContentRect();
        content.left += this.getExtraLeftOffset();
        content.top += this.getExtraTopOffset();
        content.right -= this.getExtraRightOffset();
        content.bottom -= this.getExtraBottomOffset();
        return Math.min(content.width(), content.height());
    }

    public abstract float getRadius();

    protected abstract float getRequiredLegendOffset();

    protected abstract float getRequiredBaseOffset();

    @Override
    public float getYChartMax() {
        return 0.0f;
    }

    @Override
    public float getYChartMin() {
        return 0.0f;
    }

    @SuppressLint(value={"NewApi"})
    public void spin(int durationmillis, float fromangle, float toangle, Easing.EasingOption easing) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.setRotationAngle(fromangle);
        ObjectAnimator spinAnimator = ObjectAnimator.ofFloat((Object)this, (String)"rotationAngle", (float[])new float[]{fromangle, toangle});
        spinAnimator.setDuration((long)durationmillis);
        spinAnimator.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easing));
        spinAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PieRadarChartBase.this.postInvalidate();
            }
        });
        spinAnimator.start();
    }
}

