/*
 * Decompiled with CFR 0.152.
 */
package com.philjay.jwt;

import com.philjay.jwt.Algorithm;
import com.philjay.jwt.AppleJWTAuthHeader;
import com.philjay.jwt.Base64Decoder;
import com.philjay.jwt.Base64Encoder;
import com.philjay.jwt.JWKObject;
import com.philjay.jwt.JWTAuthHeader;
import com.philjay.jwt.JWTAuthPayload;
import com.philjay.jwt.JWTToken;
import com.philjay.jwt.JsonDecoder;
import com.philjay.jwt.JsonEncoder;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0018\u00010\b\"\b\b\u0000\u0010\t*\u00020\u000b\"\b\b\u0001\u0010\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J8\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002Jm\u0010\u001b\u001a\u00020\u0006\"\b\b\u0000\u0010\t*\u00020\u000b\"\b\b\u0001\u0010\n*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u0002H\t2\u0006\u0010\u001d\u001a\u0002H\n2\u0006\u0010\u0017\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010 JL\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/philjay/jwt/JWT;", "", "()V", "tokenDelimiter", "", "verifyAlgorithm", "", "decode", "Lcom/philjay/jwt/JWTToken;", "H", "P", "Lcom/philjay/jwt/JWTAuthHeader;", "Lcom/philjay/jwt/JWTAuthPayload;", "jwtTokenString", "jsonDecoder", "Lcom/philjay/jwt/JsonDecoder;", "decoder", "Lcom/philjay/jwt/Base64Decoder;", "charset", "Ljava/nio/charset/Charset;", "sign", "algorithm", "Lcom/philjay/jwt/Algorithm;", "secret", "data", "encoder", "Lcom/philjay/jwt/Base64Encoder;", "token", "header", "payload", "jsonEncoder", "Lcom/philjay/jwt/JsonEncoder;", "(Lcom/philjay/jwt/Algorithm;Lcom/philjay/jwt/JWTAuthHeader;Lcom/philjay/jwt/JWTAuthPayload;Ljava/lang/String;Lcom/philjay/jwt/JsonEncoder;Lcom/philjay/jwt/Base64Encoder;Lcom/philjay/jwt/Base64Decoder;Ljava/nio/charset/Charset;)Ljava/lang/String;", "tokenApple", "teamId", "keyId", "Lcom/philjay/jwt/AppleJWTAuthHeader;", "verify", "", "jwt", "jwk", "Lcom/philjay/jwt/JWKObject;"})
public final class JWT {
    @NotNull
    public static final JWT INSTANCE = new JWT();
    @NotNull
    private static final String verifyAlgorithm = "SHA256withRSA";
    private static final char tokenDelimiter = '.';

    private JWT() {
    }

    @NotNull
    public final String tokenApple(@NotNull String teamId, @NotNull String keyId, @NotNull String secret, @NotNull JsonEncoder<AppleJWTAuthHeader, JWTAuthPayload> jsonEncoder, @NotNull Base64Encoder encoder, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)teamId, (String)"teamId");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter(jsonEncoder, (String)"jsonEncoder");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        long now = Instant.now().getEpochSecond();
        AppleJWTAuthHeader header = new AppleJWTAuthHeader(null, keyId, 1, null);
        JWTAuthPayload payload = new JWTAuthPayload(teamId, now);
        return this.token(Algorithm.ES256, (JWTAuthHeader)header, payload, secret, jsonEncoder, encoder, decoder, charset);
    }

    public static /* synthetic */ String tokenApple$default(JWT jWT, String string, String string2, String string3, JsonEncoder jsonEncoder, Base64Encoder base64Encoder, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 0x40) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.tokenApple(string, string2, string3, jsonEncoder, base64Encoder, base64Decoder, charset);
    }

    @NotNull
    public final <H extends JWTAuthHeader, P extends JWTAuthPayload> String token(@NotNull Algorithm algorithm, @NotNull H header, @NotNull P payload, @NotNull String secret, @NotNull JsonEncoder<H, P> jsonEncoder, @NotNull Base64Encoder encoder, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter(jsonEncoder, (String)"jsonEncoder");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String headerString = jsonEncoder.toJson(header);
        String payloadString = jsonEncoder.toJson((H)((Object)payload));
        byte[] byArray = headerString.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String base64Header = encoder.encodeURLSafe(byArray);
        byte[] byArray2 = payloadString.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        String base64Payload = encoder.encodeURLSafe(byArray2);
        String value = base64Header + "." + base64Payload;
        return value + "." + this.sign(algorithm, secret, value, encoder, decoder, charset);
    }

    public static /* synthetic */ String token$default(JWT jWT, Algorithm algorithm, JWTAuthHeader jWTAuthHeader, JWTAuthPayload jWTAuthPayload, String string, JsonEncoder jsonEncoder, Base64Encoder base64Encoder, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 0x80) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.token(algorithm, jWTAuthHeader, jWTAuthPayload, string, jsonEncoder, base64Encoder, base64Decoder, charset);
    }

    @Nullable
    public final <H extends JWTAuthHeader, P extends JWTAuthPayload> JWTToken<H, P> decode(@NotNull String jwtTokenString, @NotNull JsonDecoder<H, P> jsonDecoder, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        JWTToken jWTToken;
        Intrinsics.checkNotNullParameter((Object)jwtTokenString, (String)"jwtTokenString");
        Intrinsics.checkNotNullParameter(jsonDecoder, (String)"jsonDecoder");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        char[] cArray = new char[]{'.'};
        List parts = StringsKt.split$default((CharSequence)jwtTokenString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() >= 2) {
            byte[] byArray = ((String)parts.get(0)).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = decoder.decode(byArray);
            String headerJson = new String(byArray2, charset);
            byte[] byArray3 = ((String)parts.get(1)).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
            byArray = decoder.decode(byArray3);
            String payloadJson = new String(byArray, charset);
            H header = jsonDecoder.headerFrom(headerJson);
            P payload = jsonDecoder.payloadFrom(payloadJson);
            if (parts.size() == 3) {
                byte[] byArray4 = ((String)parts.get(2)).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"this as java.lang.String).getBytes(charset)");
                byte[] signature = decoder.decode(byArray4);
                jWTToken = new JWTToken<H, P>(header, payload, signature);
            } else {
                jWTToken = new JWTToken((JWTAuthHeader)header, (JWTAuthPayload)payload, null, 4, null);
            }
        } else {
            jWTToken = null;
        }
        return jWTToken;
    }

    public static /* synthetic */ JWTToken decode$default(JWT jWT, String string, JsonDecoder jsonDecoder, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.decode(string, jsonDecoder, base64Decoder, charset);
    }

    public final boolean verify(@NotNull String jwt, @NotNull JWKObject jwk, @NotNull Base64Decoder decoder, @NotNull Charset charset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        PublicKey rsa = jwk.toRSA(decoder);
        if (rsa == null) {
            bl = false;
        } else {
            char[] cArray = new char[]{'.'};
            List parts = StringsKt.split$default((CharSequence)jwt, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 3) {
                byte[] byArray = ((String)parts.get(0)).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] header = byArray;
                byte[] byArray2 = ((String)parts.get(1)).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                byte[] payload = byArray2;
                byte[] tokenSignature = decoder.decode((String)parts.get(2));
                Signature rsaSignature = Signature.getInstance(verifyAlgorithm);
                rsaSignature.initVerify(rsa);
                rsaSignature.update(header);
                rsaSignature.update((byte)46);
                rsaSignature.update(payload);
                bl = rsaSignature.verify(tokenSignature);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean verify$default(JWT jWT, String string, JWKObject jWKObject, Base64Decoder base64Decoder, Charset charset, int n, Object object) {
        if ((n & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return jWT.verify(string, jWKObject, base64Decoder, charset);
    }

    private final String sign(Algorithm algorithm, String secret, String data, Base64Encoder encoder, Base64Decoder decoder, Charset charset) {
        KeyFactory factory = KeyFactory.getInstance(algorithm.getKeyAlg());
        byte[] byArray = secret.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decoder.decode(byArray));
        PrivateKey key = factory.generatePrivate(keySpec);
        Signature sig = Signature.getInstance(algorithm.getAlg());
        sig.initSign(key);
        byte[] byArray2 = data.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        sig.update(byArray2);
        byte[] byArray3 = sig.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"sig.sign()");
        return encoder.encodeURLSafe(byArray3);
    }
}

