/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ApkSigningBlock;
import com.meituan.android.walle.ApkSigningPayload;
import com.meituan.android.walle.ApkUtil;
import com.meituan.android.walle.Pair;
import com.meituan.android.walle.SignatureNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class PayloadWriter {
    private PayloadWriter() {
    }

    public static void put(File apkFile, int id, String string) throws IOException, SignatureNotFoundException {
        PayloadWriter.put(apkFile, id, string, false);
    }

    public static void put(File apkFile, int id, String string, boolean lowMemory) throws IOException, SignatureNotFoundException {
        byte[] bytes = string.getBytes("UTF-8");
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(bytes, 0, bytes.length);
        byteBuffer.flip();
        PayloadWriter.put(apkFile, id, byteBuffer, lowMemory);
    }

    public static void put(File apkFile, int id, ByteBuffer buffer) throws IOException, SignatureNotFoundException {
        PayloadWriter.put(apkFile, id, buffer, false);
    }

    public static void put(File apkFile, int id, ByteBuffer buffer, boolean lowMemory) throws IOException, SignatureNotFoundException {
        HashMap<Integer, ByteBuffer> idValues = new HashMap<Integer, ByteBuffer>();
        idValues.put(id, buffer);
        PayloadWriter.putAll(apkFile, idValues, lowMemory);
    }

    public static void putAll(File apkFile, Map<Integer, ByteBuffer> idValues) throws IOException, SignatureNotFoundException {
        PayloadWriter.putAll(apkFile, idValues, false);
    }

    public static void putAll(File apkFile, final Map<Integer, ByteBuffer> idValues, boolean lowMemory) throws IOException, SignatureNotFoundException {
        PayloadWriter.handleApkSigningBlock(apkFile, new ApkSigningBlockHandler(){

            @Override
            public ApkSigningBlock handle(Map<Integer, ByteBuffer> originIdValues) {
                if (idValues != null && !idValues.isEmpty()) {
                    originIdValues.putAll(idValues);
                }
                ApkSigningBlock apkSigningBlock = new ApkSigningBlock();
                Set<Map.Entry<Integer, ByteBuffer>> entrySet = originIdValues.entrySet();
                for (Map.Entry<Integer, ByteBuffer> entry : entrySet) {
                    ApkSigningPayload payload = new ApkSigningPayload(entry.getKey(), entry.getValue());
                    apkSigningBlock.addPayload(payload);
                }
                return apkSigningBlock;
            }
        }, lowMemory);
    }

    public static void remove(File apkFile, int id) throws IOException, SignatureNotFoundException {
        PayloadWriter.remove(apkFile, id, false);
    }

    public static void remove(File apkFile, final int id, boolean lowMemory) throws IOException, SignatureNotFoundException {
        PayloadWriter.handleApkSigningBlock(apkFile, new ApkSigningBlockHandler(){

            @Override
            public ApkSigningBlock handle(Map<Integer, ByteBuffer> originIdValues) {
                ApkSigningBlock apkSigningBlock = new ApkSigningBlock();
                Set<Map.Entry<Integer, ByteBuffer>> entrySet = originIdValues.entrySet();
                for (Map.Entry<Integer, ByteBuffer> entry : entrySet) {
                    if (entry.getKey() == id) continue;
                    ApkSigningPayload payload = new ApkSigningPayload(entry.getKey(), entry.getValue());
                    apkSigningBlock.addPayload(payload);
                }
                return apkSigningBlock;
            }
        }, lowMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleApkSigningBlock(File apkFile, ApkSigningBlockHandler handler, boolean lowMemory) throws IOException, SignatureNotFoundException {
        RandomAccessFile fIn = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            fIn = new RandomAccessFile(apkFile, "rw");
            fileChannel = fIn.getChannel();
            long commentLength = ApkUtil.getCommentLength((FileChannel)fileChannel);
            long centralDirStartOffset = ApkUtil.findCentralDirStartOffset((FileChannel)fileChannel, (long)commentLength);
            Pair apkSigningBlockAndOffset = ApkUtil.findApkSigningBlock((FileChannel)fileChannel, (long)centralDirStartOffset);
            ByteBuffer apkSigningBlock2 = (ByteBuffer)apkSigningBlockAndOffset.getFirst();
            long apkSigningBlockOffset = (Long)apkSigningBlockAndOffset.getSecond();
            Map originIdValues = ApkUtil.findIdValues((ByteBuffer)apkSigningBlock2);
            ByteBuffer apkSignatureSchemeV2Block = (ByteBuffer)originIdValues.get(1896449818);
            if (apkSignatureSchemeV2Block == null) {
                throw new IOException("No APK Signature Scheme v2 block in APK Signing Block");
            }
            boolean needPadding = originIdValues.remove(1114793335) != null;
            ApkSigningBlock apkSigningBlock = handler.handle(originIdValues);
            if (needPadding) {
                int blocksSize = 0;
                for (ApkSigningPayload payload : apkSigningBlock.getPayloads()) {
                    blocksSize += payload.getTotalSize();
                }
                int resultSize = 8 + blocksSize + 8 + 16;
                if (resultSize % 4096 != 0) {
                    int padding = 4084 - resultSize % 4096;
                    if (padding < 0) {
                        padding += 4096;
                    }
                    ByteBuffer dummy = ByteBuffer.allocate(padding).order(ByteOrder.LITTLE_ENDIAN);
                    apkSigningBlock.addPayload(new ApkSigningPayload(1114793335, dummy));
                }
            }
            if (apkSigningBlockOffset != 0L && centralDirStartOffset != 0L) {
                fIn.seek(centralDirStartOffset);
                byte[] centralDirBytes = null;
                File tempCentralBytesFile = null;
                if (lowMemory) {
                    tempCentralBytesFile = new File(apkFile.getParent(), UUID.randomUUID().toString());
                    try (FileOutputStream outStream = null;){
                        int len;
                        outStream = new FileOutputStream(tempCentralBytesFile);
                        byte[] buffer = new byte[1024];
                        while ((len = fIn.read(buffer)) > 0) {
                            outStream.write(buffer, 0, len);
                        }
                    }
                } else {
                    centralDirBytes = new byte[(int)(((FileChannel)fileChannel).size() - centralDirStartOffset)];
                    fIn.read(centralDirBytes);
                }
                ((FileChannel)fileChannel).position(apkSigningBlockOffset);
                long length = apkSigningBlock.writeApkSigningBlock(fIn);
                if (lowMemory) {
                    FileInputStream inputStream = null;
                    try {
                        int len;
                        inputStream = new FileInputStream(tempCentralBytesFile);
                        byte[] buffer = new byte[1024];
                        while ((len = inputStream.read(buffer)) > 0) {
                            fIn.write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        tempCentralBytesFile.delete();
                    }
                } else {
                    fIn.write(centralDirBytes);
                }
                fIn.setLength(fIn.getFilePointer());
                fIn.seek(((FileChannel)fileChannel).size() - commentLength - 6L);
                ByteBuffer temp = ByteBuffer.allocate(4);
                temp.order(ByteOrder.LITTLE_ENDIAN);
                temp.putInt((int)(centralDirStartOffset + length + 8L - (centralDirStartOffset - apkSigningBlockOffset)));
                temp.flip();
                fIn.write(temp.array());
            }
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fIn != null) {
                fIn.close();
            }
        }
    }

    static interface ApkSigningBlockHandler {
        public ApkSigningBlock handle(Map<Integer, ByteBuffer> var1);
    }
}

