/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.meituan.android.walle.ChannelInfo;
import com.meituan.android.walle.ChannelReader;
import java.io.File;
import java.util.Map;

public final class WalleChannelReader {
    private WalleChannelReader() {
    }

    @Nullable
    public static String getChannel(@NonNull Context context) {
        return WalleChannelReader.getChannel(context, null);
    }

    @Nullable
    public static String getChannel(@NonNull Context context, @NonNull String defaultChannel) {
        ChannelInfo channelInfo = WalleChannelReader.getChannelInfo(context);
        if (channelInfo == null) {
            return defaultChannel;
        }
        return channelInfo.getChannel();
    }

    @Nullable
    public static ChannelInfo getChannelInfo(@NonNull Context context) {
        String apkPath = WalleChannelReader.getApkPath(context);
        if (TextUtils.isEmpty((CharSequence)apkPath)) {
            return null;
        }
        return ChannelReader.get((File)new File(apkPath));
    }

    @Nullable
    public static String get(@NonNull Context context, @NonNull String key) {
        Map<String, String> channelMap = WalleChannelReader.getChannelInfoMap(context);
        if (channelMap == null) {
            return null;
        }
        return channelMap.get(key);
    }

    @Nullable
    public static Map<String, String> getChannelInfoMap(@NonNull Context context) {
        String apkPath = WalleChannelReader.getApkPath(context);
        if (TextUtils.isEmpty((CharSequence)apkPath)) {
            return null;
        }
        return ChannelReader.getMap((File)new File(apkPath));
    }

    @Nullable
    private static String getApkPath(@NonNull Context context) {
        String apkPath = null;
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            if (applicationInfo == null) {
                return null;
            }
            apkPath = applicationInfo.sourceDir;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return apkPath;
    }
}

