/*
 * Decompiled with CFR 0.152.
 */
package com.othings.technologies.bluetooth.bluetoothScanning;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.preference.PreferenceManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.MutableLiveData;
import com.othings.technologies.bluetooth.bluetoothScanning.BluetoothAction;
import com.othings.technologies.bluetooth.bluetoothScanning.BluetoothFilter;
import com.othings.technologies.bluetooth.bluetoothScanning.BluetoothMethod;
import java.util.ArrayList;
import java.util.List;

public class BluetoothScanning
implements PreferenceManager.OnActivityResultListener,
PreferenceManager.OnActivityDestroyListener {
    private Context context;
    private BluetoothAdapter bluetoothAdapter;
    private MutableLiveData<BluetoothDevice> devices;
    private MutableLiveData<BluetoothDevice> devicesWithFilter;
    private MutableLiveData<BluetoothDevice> device;
    private BluetoothFilter bluetoothFilter;
    private BluetoothAction bluetoothAction;
    private BluetoothMethod bluetoothMethod;
    private BluetoothDevice bluetoothDevice;
    private String macAddress;
    private int timeOut;
    private List<BluetoothDevice> bluetoothDevices;
    private MutableLiveData<String> status;
    private static final int TURN_ON_BLUETOOTH_REQUEST_CODE = 3000;
    public static final String BLUETOOTH_STATE_ON = "BLUETOOTH_STATE_ON";
    public static final String BLUETOOTH_STATE_OFF = "BLUETOOTH_STATE_OFF";
    private IntentFilter filter;
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "android.bluetooth.device.action.FOUND": {
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    if (BluetoothScanning.this.bluetoothAction == BluetoothAction.SCAN_DEVICES) {
                        if (BluetoothScanning.this.bluetoothFilter != null) {
                            if (bluetoothDevice.getBluetoothClass().getDeviceClass() != BluetoothScanning.this.bluetoothFilter.getValue() || BluetoothScanning.this.hasDevice(bluetoothDevice)) break;
                            BluetoothScanning.this.bluetoothDevices.add(bluetoothDevice);
                            BluetoothScanning.this.devicesWithFilter.setValue((Object)bluetoothDevice);
                            BluetoothScanning.this.status.setValue((Object)"android.bluetooth.device.action.FOUND");
                            break;
                        }
                        if (BluetoothScanning.this.hasDevice(bluetoothDevice)) break;
                        BluetoothScanning.this.bluetoothDevices.add(bluetoothDevice);
                        BluetoothScanning.this.devices.setValue((Object)bluetoothDevice);
                        BluetoothScanning.this.status.setValue((Object)"android.bluetooth.device.action.FOUND");
                        break;
                    }
                    if (BluetoothScanning.this.bluetoothAction != BluetoothAction.FIND_DEVICE || !BluetoothScanning.this.macAddress.equals(bluetoothDevice.getAddress())) break;
                    BluetoothScanning.this.bluetoothDevice = bluetoothDevice;
                    BluetoothScanning.this.device.setValue((Object)bluetoothDevice);
                    break;
                }
                case "android.bluetooth.adapter.action.DISCOVERY_STARTED": {
                    BluetoothScanning.this.status.setValue((Object)"android.bluetooth.adapter.action.DISCOVERY_STARTED");
                    break;
                }
                case "android.bluetooth.adapter.action.DISCOVERY_FINISHED": {
                    BluetoothScanning.this.status.setValue((Object)"android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                    if (BluetoothScanning.this.bluetoothAction == BluetoothAction.FIND_DEVICE && BluetoothScanning.this.bluetoothDevice == null) {
                        BluetoothScanning.this.device.setValue(null);
                    }
                    BluetoothScanning.this.bluetoothFilter = null;
                    BluetoothScanning.this.bluetoothAction = null;
                    BluetoothScanning.this.bluetoothDevice = null;
                    BluetoothScanning.this.bluetoothDevices.clear();
                    break;
                }
                case "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED": {
                    if (BluetoothScanning.this.bluetoothAdapter.getState() == 12) {
                        BluetoothScanning.this.status.setValue((Object)BluetoothScanning.BLUETOOTH_STATE_ON);
                        break;
                    }
                    if (BluetoothScanning.this.bluetoothAdapter.getState() != 10) break;
                    BluetoothScanning.this.status.setValue((Object)BluetoothScanning.BLUETOOTH_STATE_OFF);
                }
            }
        }
    };

    public BluetoothScanning(Context context) {
        this.context = context;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.filter = new IntentFilter("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        context.registerReceiver(this.broadcastReceiver, this.filter);
        this.filter = new IntentFilter("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        context.registerReceiver(this.broadcastReceiver, this.filter);
        this.filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        context.registerReceiver(this.broadcastReceiver, this.filter);
        this.filter = new IntentFilter("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
        context.registerReceiver(this.broadcastReceiver, this.filter);
        this.bluetoothDevices = new ArrayList<BluetoothDevice>();
        this.status = new MutableLiveData();
        this.devices = new MutableLiveData();
        this.devicesWithFilter = new MutableLiveData();
        this.device = new MutableLiveData();
    }

    public MutableLiveData<BluetoothDevice> getDevice(String macAddress) {
        this.bluetoothMethod = BluetoothMethod.GET_DEVICE;
        this.macAddress = macAddress;
        if (this.bluetoothAdapter.isEnabled()) {
            this.status.setValue((Object)"android.bluetooth.adapter.action.DISCOVERY_STARTED");
            boolean found = false;
            for (BluetoothDevice bluetoothDevice : this.bluetoothAdapter.getBondedDevices()) {
                if (!bluetoothDevice.getAddress().equals(macAddress)) continue;
                found = true;
                this.device.setValue((Object)bluetoothDevice);
                this.status.setValue((Object)"android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            }
            if (!found) {
                this.bluetoothDevices.clear();
                this.bluetoothAction = BluetoothAction.FIND_DEVICE;
                if (this.bluetoothAdapter.isDiscovering()) {
                    this.bluetoothAdapter.cancelDiscovery();
                }
                this.bluetoothAdapter.startDiscovery();
            }
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
        }
        return this.device;
    }

    public MutableLiveData<BluetoothDevice> getDevice(String macAddress, int timeout) {
        this.bluetoothMethod = BluetoothMethod.GET_DEVICE_WITH_TIMEOUT;
        this.macAddress = macAddress;
        this.timeOut = timeout;
        if (this.bluetoothAdapter.isEnabled()) {
            this.status.setValue((Object)"android.bluetooth.adapter.action.DISCOVERY_STARTED");
            boolean found = false;
            for (BluetoothDevice bluetoothDevice : this.bluetoothAdapter.getBondedDevices()) {
                if (!bluetoothDevice.getAddress().equals(macAddress)) continue;
                found = true;
                this.device.setValue((Object)bluetoothDevice);
                this.status.setValue((Object)"android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            }
            if (!found) {
                this.bluetoothDevices.clear();
                this.bluetoothAction = BluetoothAction.FIND_DEVICE;
                if (this.bluetoothAdapter.isDiscovering()) {
                    this.bluetoothAdapter.cancelDiscovery();
                }
                this.bluetoothAdapter.startDiscovery();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothScanning.this.bluetoothAdapter.cancelDiscovery();
                    }
                }, (long)timeout);
            }
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
        }
        return this.device;
    }

    public MutableLiveData<BluetoothDevice> getAllDevices() {
        this.bluetoothMethod = BluetoothMethod.GET_ALL_DEVICES;
        this.bluetoothAction = BluetoothAction.SCAN_DEVICES;
        if (this.bluetoothAdapter.isEnabled()) {
            if (this.bluetoothAdapter.isDiscovering()) {
                this.bluetoothAdapter.cancelDiscovery();
            }
            this.bluetoothAdapter.startDiscovery();
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
        }
        return this.devices;
    }

    public MutableLiveData<BluetoothDevice> getAllDevices(int timeout) {
        this.timeOut = timeout;
        this.bluetoothMethod = BluetoothMethod.GET_ALL_DEVICES_WITH_TIMEOUT;
        this.bluetoothAction = BluetoothAction.SCAN_DEVICES;
        if (this.bluetoothAdapter.isEnabled()) {
            if (this.bluetoothAdapter.isDiscovering()) {
                this.bluetoothAdapter.cancelDiscovery();
            }
            this.bluetoothAdapter.startDiscovery();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    BluetoothScanning.this.bluetoothAdapter.cancelDiscovery();
                }
            }, (long)timeout);
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
        }
        return this.devices;
    }

    public MutableLiveData<BluetoothDevice> getFilteredDevices(BluetoothFilter filter) {
        this.bluetoothMethod = BluetoothMethod.GET_FILTERED_DEVICES;
        this.bluetoothFilter = filter;
        this.bluetoothAction = BluetoothAction.SCAN_DEVICES;
        if (this.bluetoothAdapter.isEnabled()) {
            if (this.bluetoothAdapter.isDiscovering()) {
                this.bluetoothAdapter.cancelDiscovery();
            }
            this.bluetoothAdapter.startDiscovery();
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
        }
        return this.devicesWithFilter;
    }

    public MutableLiveData<BluetoothDevice> getFilteredDevices(BluetoothFilter filter, int timeout) {
        this.bluetoothMethod = BluetoothMethod.GET_FILTERED_DEVICE_WITH_TIMEOUT;
        this.bluetoothFilter = filter;
        this.timeOut = timeout;
        this.bluetoothAction = BluetoothAction.SCAN_DEVICES;
        if (this.bluetoothAdapter.isEnabled()) {
            if (this.bluetoothAdapter.isDiscovering()) {
                this.bluetoothAdapter.cancelDiscovery();
            }
            this.bluetoothAdapter.startDiscovery();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    BluetoothScanning.this.bluetoothAdapter.cancelDiscovery();
                }
            }, (long)timeout);
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
        }
        return this.devicesWithFilter;
    }

    public MutableLiveData<String> getStatus() {
        return this.status;
    }

    private boolean hasDevice(BluetoothDevice bluetoothDevice) {
        for (BluetoothDevice device : this.bluetoothDevices) {
            if (!device.getAddress().equals(bluetoothDevice)) continue;
            return true;
        }
        return false;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 3000) {
            if (this.bluetoothAdapter.isEnabled()) {
                switch (this.bluetoothMethod) {
                    case GET_DEVICE: {
                        this.getDevice(this.macAddress);
                        break;
                    }
                    case GET_DEVICE_WITH_TIMEOUT: {
                        this.getDevice(this.macAddress, this.timeOut);
                        break;
                    }
                    case GET_ALL_DEVICES: {
                        this.getAllDevices();
                        break;
                    }
                    case GET_ALL_DEVICES_WITH_TIMEOUT: {
                        this.getAllDevices(this.timeOut);
                        break;
                    }
                    case GET_FILTERED_DEVICES: {
                        this.getFilteredDevices(this.bluetoothFilter);
                        break;
                    }
                    case GET_FILTERED_DEVICE_WITH_TIMEOUT: {
                        this.getFilteredDevices(this.bluetoothFilter, this.timeOut);
                    }
                }
            } else {
                Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3000);
            }
        }
        return false;
    }

    public void onActivityDestroy() {
        ((AppCompatActivity)this.context).unregisterReceiver(this.broadcastReceiver);
    }
}

