/*
 * Decompiled with CFR 0.152.
 */
package com.othings.technologies.bluetooth.bluetoothCommunication;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.preference.PreferenceManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.othings.technologies.bluetooth.bluetoothBond.BluetoothBond;
import com.othings.technologies.bluetooth.bluetoothBond.BluetoothBondState;
import com.othings.technologies.bluetooth.bluetoothCommunication.BluetoothMethod;
import com.othings.technologies.bluetooth.bluetoothScanning.BluetoothScanning;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class BluetoothClient
implements PreferenceManager.OnActivityResultListener {
    private Context context;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothBond bluetoothBond;
    private BluetoothScanning scanning;
    private MutableLiveData<String> requestStatus;
    public static final String REQUEST_OK = "REQUEST_OK";
    public static final String DEVICE_NOT_FOUND = "DEVICE_NOT_FOUND";
    public static final String REFUSED_CONNECTION = "REFUSED_CONNECTION";
    public static final String DEVICE_NOT_PAIRED = "DEVICE_NOT_PAIRED";
    private static final int TURN_ON_BLUETOOTH_REQUEST_CODE = 3002;
    private BluetoothMethod bluetoothMethod;
    private BluetoothDevice bluetoothDevice;
    private byte[] data;
    private LifecycleOwner owner;
    private String macAddress;

    public BluetoothClient(Context context, BluetoothBond bluetoothBond, BluetoothScanning scanning) {
        this.context = context;
        this.bluetoothBond = bluetoothBond;
        this.scanning = scanning;
        this.requestStatus = new MutableLiveData();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public MutableLiveData<String> request(final BluetoothDevice bluetoothDevice, final byte[] data, final LifecycleOwner owner) {
        this.bluetoothDevice = bluetoothDevice;
        this.data = data;
        this.owner = owner;
        this.bluetoothMethod = BluetoothMethod.REQUEST_WITH_BLUETOOTH_DEVICE;
        if (this.bluetoothAdapter.isEnabled()) {
            if (bluetoothDevice.getBondState() == 12) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            UUID uuid = null;
                            if (bluetoothDevice.getUuids() != null) {
                                uuid = UUID.fromString(String.valueOf(bluetoothDevice.getUuids()[0]));
                                try {
                                    BluetoothSocket bluetoothSocket = bluetoothDevice.createRfcommSocketToServiceRecord(uuid);
                                    Looper.prepare();
                                    bluetoothSocket.connect();
                                    if (bluetoothSocket.isConnected()) {
                                        OutputStream outputStream = bluetoothSocket.getOutputStream();
                                        outputStream.write(data);
                                        Thread.sleep(100L);
                                        bluetoothSocket.close();
                                        Looper.myLooper().quit();
                                        BluetoothClient.this.requestStatus.postValue((Object)BluetoothClient.REQUEST_OK);
                                        break block6;
                                    }
                                    BluetoothClient.this.requestStatus.postValue((Object)BluetoothClient.REFUSED_CONNECTION);
                                }
                                catch (Exception e) {
                                    if (e instanceof IOException) {
                                        BluetoothClient.this.requestStatus.postValue((Object)"El dispositivo esta apagado y no fue posible conectar , verifique y vuelva a intentarlo.");
                                        break block6;
                                    }
                                    BluetoothClient.this.requestStatus.postValue((Object)e.getMessage());
                                }
                            } else {
                                BluetoothClient.this.requestStatus.postValue((Object)BluetoothClient.DEVICE_NOT_PAIRED);
                            }
                        }
                    }
                });
                thread.start();
            } else {
                this.bluetoothBond.bondDevice(bluetoothDevice).observe(owner, (Observer)new Observer<BluetoothBondState>(){

                    public void onChanged(BluetoothBondState bluetoothBondState) {
                        if (bluetoothBondState.getState() == 12) {
                            BluetoothClient.this.request(bluetoothBondState.getBluetoothDevice(), data, owner);
                        } else {
                            BluetoothClient.this.request(bluetoothDevice, data, owner);
                        }
                    }
                });
            }
        } else {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3002);
        }
        return this.requestStatus;
    }

    public MutableLiveData<String> request(String macAddress, final byte[] data, final LifecycleOwner owner) {
        this.bluetoothMethod = BluetoothMethod.REQUEST_WITH_MAC_ADDRESS;
        this.macAddress = macAddress;
        this.data = data;
        this.owner = owner;
        this.scanning.getDevice(macAddress).observe(owner, (Observer)new Observer<BluetoothDevice>(){

            public void onChanged(final BluetoothDevice bluetoothDevice) {
                if (bluetoothDevice != null) {
                    if (bluetoothDevice.getBondState() == 12) {
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                UUID uuid = UUID.fromString(String.valueOf(bluetoothDevice.getUuids()[0]));
                                try {
                                    BluetoothSocket bluetoothSocket = bluetoothDevice.createRfcommSocketToServiceRecord(uuid);
                                    Looper.prepare();
                                    bluetoothSocket.connect();
                                    if (bluetoothSocket.isConnected()) {
                                        OutputStream outputStream = bluetoothSocket.getOutputStream();
                                        outputStream.write(data);
                                        Thread.sleep(100L);
                                        bluetoothSocket.close();
                                        Looper.myLooper().quit();
                                        BluetoothClient.this.requestStatus.postValue((Object)BluetoothClient.REQUEST_OK);
                                    } else {
                                        BluetoothClient.this.requestStatus.postValue((Object)BluetoothClient.REFUSED_CONNECTION);
                                    }
                                }
                                catch (Exception e) {
                                    BluetoothClient.this.requestStatus.postValue((Object)e.getMessage());
                                }
                            }
                        });
                        thread.start();
                    } else {
                        BluetoothClient.this.bluetoothBond.bondDevice(bluetoothDevice).observe(owner, (Observer)new Observer<BluetoothBondState>(){

                            public void onChanged(BluetoothBondState bluetoothBondState) {
                                if (bluetoothBondState.getState() == 12) {
                                    BluetoothClient.this.request(bluetoothBondState.getBluetoothDevice(), data, owner);
                                } else {
                                    BluetoothClient.this.request(bluetoothDevice, data, owner);
                                }
                            }
                        });
                    }
                } else {
                    BluetoothClient.this.requestStatus.setValue((Object)BluetoothClient.DEVICE_NOT_FOUND);
                }
            }
        });
        return this.requestStatus;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 3002) {
            if (this.bluetoothAdapter.isEnabled()) {
                switch (this.bluetoothMethod) {
                    case REQUEST_WITH_BLUETOOTH_DEVICE: {
                        this.request(this.bluetoothDevice, this.data, this.owner);
                        break;
                    }
                    case REQUEST_WITH_MAC_ADDRESS: {
                        this.request(this.macAddress, this.data, this.owner);
                    }
                }
            } else {
                Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                ((AppCompatActivity)this.context).startActivityForResult(enableBtIntent, 3002);
            }
        }
        return false;
    }
}

