/*
 * Decompiled with CFR 0.152.
 */
package com.othings.technologies.bluetooth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.othings.technologies.bluetooth.bluetoothBond.BluetoothBond;
import com.othings.technologies.bluetooth.bluetoothCommunication.BluetoothClient;
import com.othings.technologies.bluetooth.bluetoothScanning.BluetoothScanning;

public class Bluetooth
implements PreferenceManager.OnActivityResultListener,
ActivityCompat.OnRequestPermissionsResultCallback,
PreferenceManager.OnActivityDestroyListener {
    private Context context;
    private BluetoothBond bond;
    private BluetoothScanning scanning;
    private BluetoothClient client;
    private String[] permissions = new String[]{"android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN", "android.permission.ACCESS_COARSE_LOCATION"};
    private static final int REQUEST_PERMISSIONS = 3000;

    public Bluetooth(Context context) {
        this.context = context;
        this.bond = new BluetoothBond(context);
        this.scanning = new BluetoothScanning(context);
        this.client = new BluetoothClient(context, this.bond, this.scanning);
        if (!this.hasPermissions()) {
            this.requestPermissions();
        }
    }

    public BluetoothBond getBond() {
        return this.bond;
    }

    public BluetoothScanning getScanning() {
        return this.scanning;
    }

    public BluetoothClient getClient() {
        return this.client;
    }

    private void requestPermissions() {
        ActivityCompat.requestPermissions((Activity)((AppCompatActivity)this.context), (String[])this.permissions, (int)3000);
    }

    private boolean hasPermission(String permission) {
        return ContextCompat.checkSelfPermission((Context)((AppCompatActivity)this.context), (String)permission) == 0;
    }

    private boolean hasPermissions() {
        for (String permission : this.permissions) {
            if (this.hasPermission(permission)) continue;
            return false;
        }
        return true;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        this.bond.onActivityResult(requestCode, resultCode, data);
        this.scanning.onActivityResult(requestCode, resultCode, data);
        this.client.onActivityResult(requestCode, resultCode, data);
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 3000 && !this.verifyPermissions(grantResults)) {
            this.requestPermissions();
        }
    }

    private boolean verifyPermissions(@NonNull int[] grantResults) {
        if (grantResults[0] == -1) {
            return false;
        }
        if (grantResults[1] == -1) {
            return false;
        }
        return grantResults[2] != -1;
    }

    public void onActivityDestroy() {
        this.scanning.onActivityDestroy();
    }
}

