/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Region;
import android.support.annotation.ColorInt;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.othershe.combinebitmap.helper.CombineHelper;
import com.othershe.combinebitmap.helper.Utils;
import com.othershe.combinebitmap.layout.DingLayoutManager;
import com.othershe.combinebitmap.layout.ILayoutManager;
import com.othershe.combinebitmap.layout.WechatLayoutManager;
import com.othershe.combinebitmap.listener.OnProgressListener;
import com.othershe.combinebitmap.listener.OnSubItemClickListener;
import com.othershe.combinebitmap.region.DingRegionManager;
import com.othershe.combinebitmap.region.IRegionManager;
import com.othershe.combinebitmap.region.WechatRegionManager;

public class Builder {
    public Context context;
    public ImageView imageView;
    public int size;
    public int gap;
    public int gapColor;
    public int placeholder;
    public int count;
    public int subSize;
    public ILayoutManager layoutManager;
    public Region[] regions;
    public OnSubItemClickListener subItemClickListener;
    public OnProgressListener progressListener;
    public Bitmap[] bitmaps;
    public int[] resourceIds;
    public String[] urls;

    public Builder(Context context) {
        this.context = context;
    }

    public Builder setImageView(ImageView imageView) {
        this.imageView = imageView;
        return this;
    }

    public Builder setSize(int size) {
        this.size = Utils.dp2px(this.context, size);
        return this;
    }

    public Builder setGap(int gap) {
        this.gap = Utils.dp2px(this.context, gap);
        return this;
    }

    public Builder setGapColor(@ColorInt int gapColor) {
        this.gapColor = gapColor;
        return this;
    }

    public Builder setPlaceholder(int placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public Builder setLayoutManager(ILayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        return this;
    }

    public Builder setOnProgressListener(OnProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public Builder setOnSubItemClickListener(OnSubItemClickListener subItemClickListener) {
        this.subItemClickListener = subItemClickListener;
        return this;
    }

    public Builder setBitmaps(Bitmap ... bitmaps) {
        this.bitmaps = bitmaps;
        this.count = bitmaps.length;
        return this;
    }

    public Builder setUrls(String ... urls) {
        this.urls = urls;
        this.count = urls.length;
        return this;
    }

    public Builder setResourceIds(int ... resourceIds) {
        this.resourceIds = resourceIds;
        this.count = resourceIds.length;
        return this;
    }

    public void build() {
        this.subSize = this.getSubSize(this.size, this.gap, this.layoutManager, this.count);
        this.initRegions();
        CombineHelper.init().load(this);
    }

    private int getSubSize(int size, int gap, ILayoutManager layoutManager, int count) {
        int subSize = 0;
        if (layoutManager instanceof DingLayoutManager) {
            subSize = size;
        } else if (layoutManager instanceof WechatLayoutManager) {
            if (count < 2) {
                subSize = size;
            } else if (count < 5) {
                subSize = (size - 3 * gap) / 2;
            } else if (count < 10) {
                subSize = (size - 4 * gap) / 3;
            }
        } else {
            throw new IllegalArgumentException("Must use DingLayoutManager or WechatRegionManager!");
        }
        return subSize;
    }

    private void initRegions() {
        IRegionManager regionManager;
        if (this.subItemClickListener == null || this.imageView == null) {
            return;
        }
        if (this.layoutManager instanceof DingLayoutManager) {
            regionManager = new DingRegionManager();
        } else if (this.layoutManager instanceof WechatLayoutManager) {
            regionManager = new WechatRegionManager();
        } else {
            throw new IllegalArgumentException("Must use DingLayoutManager or WechatRegionManager!");
        }
        this.regions = regionManager.calculateRegion(this.size, this.subSize, this.gap, this.count);
        this.imageView.setOnTouchListener(new View.OnTouchListener(){
            int initIndex = -1;
            int currentIndex = -1;
            Point point = new Point();

            public boolean onTouch(View v, MotionEvent event) {
                this.point.set((int)event.getX(), (int)event.getY());
                switch (event.getAction()) {
                    case 0: {
                        this.currentIndex = this.initIndex = Builder.this.getRegionIndex(this.point.x, this.point.y);
                        break;
                    }
                    case 2: {
                        this.currentIndex = Builder.this.getRegionIndex(this.point.x, this.point.y);
                        break;
                    }
                    case 1: {
                        this.currentIndex = Builder.this.getRegionIndex(this.point.x, this.point.y);
                        if (this.currentIndex == -1 || this.currentIndex != this.initIndex) break;
                        Builder.this.subItemClickListener.onSubItemClick(this.currentIndex);
                        break;
                    }
                    case 3: {
                        this.currentIndex = -1;
                        this.initIndex = -1;
                    }
                }
                return true;
            }
        });
    }

    private int getRegionIndex(int x, int y) {
        for (int i = 0; i < this.regions.length; ++i) {
            if (!this.regions[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }
}

