/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client.model;

import io.swagger.client.model.PlanDTO;
import io.swagger.client.model.TParameter;
import java.util.List;
import java.util.stream.Collectors;
import org.opentosca.container.client.model.PlanType;

public class Plan {
    private final PlanDTO plan;

    public String getId() {
        return this.plan.getId();
    }

    public String getName() {
        return this.plan.getName();
    }

    public PlanType getType() {
        return PlanType.fromString(this.plan.getPlanType());
    }

    public List<String> getInputParameters() {
        return this.plan.getInputParameters().stream().map(TParameter::getName).collect(Collectors.toList());
    }

    public boolean isBuildPlan() {
        return this.getType().equals((Object)PlanType.BUILD);
    }

    public boolean isTerminationPlan() {
        return this.getType().equals((Object)PlanType.TERMINATION);
    }

    public boolean isManagementPlan() {
        return this.getType().equals((Object)PlanType.MANAGEMENT);
    }

    public Plan(PlanDTO plan) {
        this.plan = plan;
    }
}

