/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client.model;

import io.swagger.client.model.PlanDTO;
import io.swagger.client.model.PlanInstanceDTO;
import io.swagger.client.model.ServiceTemplateInstanceDTO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.opentosca.container.client.model.Application;
import org.opentosca.container.client.model.NodeInstance;
import org.opentosca.container.client.model.Plan;
import org.opentosca.container.client.model.PlanInstance;

public class ApplicationInstance {
    private final Application application;
    private final ServiceTemplateInstanceDTO serviceTemplateInstance;
    private final List<NodeInstance> nodeInstances;
    private final List<PlanDTO> managementPlans;
    private final List<PlanInstanceDTO> managementPlanInstances;

    public String getId() {
        return this.serviceTemplateInstance.getId().toString();
    }

    public DateTime getCreatedAt() {
        return this.serviceTemplateInstance.getCreatedAt();
    }

    public ServiceTemplateInstanceDTO.StateEnum getState() {
        return this.serviceTemplateInstance.getState();
    }

    public List<NodeInstance> getNodeInstances() {
        return this.nodeInstances;
    }

    public List<Plan> getManagementPlans() {
        return this.managementPlans.stream().map(Plan::new).filter(Plan::isManagementPlan).collect(Collectors.toList());
    }

    public List<PlanInstance> getManagementPlanInstances() {
        return this.managementPlanInstances.stream().map(PlanInstance::new).filter(e -> e.getType().equals((Object)PlanInstanceDTO.TypeEnum.MANAGEMENT)).collect(Collectors.toList());
    }

    public Plan getTerminationPlan() {
        return this.managementPlans.stream().map(Plan::new).filter(Plan::isTerminationPlan).findFirst().orElseThrow(IllegalStateException::new);
    }

    public Application getApplication() {
        Objects.requireNonNull(this.application);
        return this.application;
    }

    ApplicationInstance(Application application, ServiceTemplateInstanceDTO serviceTemplateInstance, List<NodeInstance> nodeInstances, List<PlanDTO> managementPlans, List<PlanInstanceDTO> managementPlanInstances) {
        this.application = application;
        this.serviceTemplateInstance = serviceTemplateInstance;
        this.nodeInstances = nodeInstances;
        this.managementPlans = managementPlans;
        this.managementPlanInstances = managementPlanInstances;
    }

    public static ApplicationInstanceBuilder builder() {
        return new ApplicationInstanceBuilder();
    }

    public static class ApplicationInstanceBuilder {
        private Application application;
        private ServiceTemplateInstanceDTO serviceTemplateInstance;
        private List<NodeInstance> nodeInstances;
        private List<PlanDTO> managementPlans;
        private List<PlanInstanceDTO> managementPlanInstances;

        ApplicationInstanceBuilder() {
        }

        public ApplicationInstanceBuilder application(Application application) {
            this.application = application;
            return this;
        }

        public ApplicationInstanceBuilder serviceTemplateInstance(ServiceTemplateInstanceDTO serviceTemplateInstance) {
            this.serviceTemplateInstance = serviceTemplateInstance;
            return this;
        }

        public ApplicationInstanceBuilder nodeInstances(List<NodeInstance> nodeInstances) {
            this.nodeInstances = nodeInstances;
            return this;
        }

        public ApplicationInstanceBuilder managementPlans(List<PlanDTO> managementPlans) {
            this.managementPlans = managementPlans;
            return this;
        }

        public ApplicationInstanceBuilder managementPlanInstances(List<PlanInstanceDTO> managementPlanInstances) {
            this.managementPlanInstances = managementPlanInstances;
            return this;
        }

        public ApplicationInstance build() {
            return new ApplicationInstance(this.application, this.serviceTemplateInstance, this.nodeInstances, this.managementPlans, this.managementPlanInstances);
        }

        public String toString() {
            return "ApplicationInstance.ApplicationInstanceBuilder(application=" + this.application + ", serviceTemplateInstance=" + this.serviceTemplateInstance + ", nodeInstances=" + this.nodeInstances + ", managementPlans=" + this.managementPlans + ", managementPlanInstances=" + this.managementPlanInstances + ")";
        }
    }
}

