/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client.model;

import io.swagger.client.model.CsarDTO;
import io.swagger.client.model.InterfaceDTO;
import io.swagger.client.model.NodeTemplateDTO;
import io.swagger.client.model.PlanDTO;
import io.swagger.client.model.PlanInstanceDTO;
import io.swagger.client.model.ServiceTemplateDTO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentosca.container.client.model.Interface;
import org.opentosca.container.client.model.NodeTemplate;
import org.opentosca.container.client.model.Plan;
import org.opentosca.container.client.model.PlanInstance;
import org.opentosca.container.client.model.ServiceTemplate;

public class Application {
    private final CsarDTO csar;
    private final ServiceTemplateDTO serviceTemplate;
    private final List<NodeTemplateDTO> nodeTemplates;
    private final PlanDTO buildPlan;
    private final List<PlanInstanceDTO> buildPlanInstances;
    private final List<InterfaceDTO> interfaces;
    private final List<String> fileLocations;

    public String getId() {
        return this.csar.getId();
    }

    public String getVersion() {
        return this.csar.getVersion();
    }

    public List<String> getAuthors() {
        return this.csar.getAuthors();
    }

    public String getName() {
        return this.csar.getName();
    }

    public String getDisplayName() {
        return this.csar.getDisplayName();
    }

    public String getDescription() {
        return this.csar.getDescription();
    }

    public ServiceTemplate getServiceTemplate() {
        return new ServiceTemplate(this.serviceTemplate);
    }

    public List<NodeTemplate> getNodeTemplates() {
        Objects.requireNonNull(this.nodeTemplates);
        return this.nodeTemplates.stream().map(NodeTemplate::new).collect(Collectors.toList());
    }

    public Plan getBuildPlan() {
        return new Plan(this.buildPlan);
    }

    public List<PlanInstance> getBuildPlanInstances() {
        return this.buildPlanInstances.stream().map(PlanInstance::new).collect(Collectors.toList());
    }

    public List<Interface> getInterfaces() {
        return this.interfaces.stream().map(Interface::new).collect(Collectors.toList());
    }

    public List<String> getFileLocations() {
        return this.fileLocations;
    }

    Application(CsarDTO csar, ServiceTemplateDTO serviceTemplate, List<NodeTemplateDTO> nodeTemplates, PlanDTO buildPlan, List<PlanInstanceDTO> buildPlanInstances, List<InterfaceDTO> interfaces, List<String> fileLocations) {
        this.csar = csar;
        this.serviceTemplate = serviceTemplate;
        this.nodeTemplates = nodeTemplates;
        this.buildPlan = buildPlan;
        this.buildPlanInstances = buildPlanInstances;
        this.interfaces = interfaces;
        this.fileLocations = fileLocations;
    }

    public static ApplicationBuilder builder() {
        return new ApplicationBuilder();
    }

    public static class ApplicationBuilder {
        private CsarDTO csar;
        private ServiceTemplateDTO serviceTemplate;
        private List<NodeTemplateDTO> nodeTemplates;
        private PlanDTO buildPlan;
        private List<PlanInstanceDTO> buildPlanInstances;
        private List<InterfaceDTO> interfaces;
        private List<String> fileLocations;

        ApplicationBuilder() {
        }

        public ApplicationBuilder csar(CsarDTO csar) {
            this.csar = csar;
            return this;
        }

        public ApplicationBuilder serviceTemplate(ServiceTemplateDTO serviceTemplate) {
            this.serviceTemplate = serviceTemplate;
            return this;
        }

        public ApplicationBuilder nodeTemplates(List<NodeTemplateDTO> nodeTemplates) {
            this.nodeTemplates = nodeTemplates;
            return this;
        }

        public ApplicationBuilder buildPlan(PlanDTO buildPlan) {
            this.buildPlan = buildPlan;
            return this;
        }

        public ApplicationBuilder buildPlanInstances(List<PlanInstanceDTO> buildPlanInstances) {
            this.buildPlanInstances = buildPlanInstances;
            return this;
        }

        public ApplicationBuilder interfaces(List<InterfaceDTO> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public ApplicationBuilder fileLocations(List<String> fileLocations) {
            this.fileLocations = fileLocations;
            return this;
        }

        public Application build() {
            return new Application(this.csar, this.serviceTemplate, this.nodeTemplates, this.buildPlan, this.buildPlanInstances, this.interfaces, this.fileLocations);
        }

        public String toString() {
            return "Application.ApplicationBuilder(csar=" + this.csar + ", serviceTemplate=" + this.serviceTemplate + ", nodeTemplates=" + this.nodeTemplates + ", buildPlan=" + this.buildPlan + ", buildPlanInstances=" + this.buildPlanInstances + ", interfaces=" + this.interfaces + ", fileLocations=" + this.fileLocations + ")";
        }
    }
}

