/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.api.DefaultApi;
import io.swagger.client.model.CsarDTO;
import io.swagger.client.model.InterfaceDTO;
import io.swagger.client.model.NodeTemplateDTO;
import io.swagger.client.model.NodeTemplateInstanceDTO;
import io.swagger.client.model.PlanDTO;
import io.swagger.client.model.PlanInstanceDTO;
import io.swagger.client.model.PlanInstanceListDTO;
import io.swagger.client.model.ServiceTemplateDTO;
import io.swagger.client.model.ServiceTemplateInstanceDTO;
import io.swagger.client.model.TParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.opentosca.container.client.ContainerClient;
import org.opentosca.container.client.ContainerClientAsync;
import org.opentosca.container.client.impl.Exceptions;
import org.opentosca.container.client.impl.InvocationRequest;
import org.opentosca.container.client.impl.InvocationResponse;
import org.opentosca.container.client.model.Application;
import org.opentosca.container.client.model.ApplicationInstance;
import org.opentosca.container.client.model.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SwaggerContainerClient
implements ContainerClient,
ContainerClientAsync {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerContainerClient.class);
    protected final DefaultApi client = new DefaultApi();
    protected final ExecutorService executor = Executors.newCachedThreadPool();

    public SwaggerContainerClient(String basePath, int timeout) {
        this.client.getApiClient().setBasePath(basePath);
        this.client.getApiClient().setReadTimeout(timeout);
        this.client.getApiClient().setConnectTimeout(timeout);
    }

    @Override
    public CompletableFuture<List<Application>> getApplicationsAsync() {
        CompletableFuture<List<Application>> future = new CompletableFuture<List<Application>>();
        this.executor.submit(() -> {
            ArrayList<Application> applications = new ArrayList<Application>();
            try {
                for (CsarDTO csar : this.client.getCsars().getCsars()) {
                    applications.add(this.getApplication(csar.getId()).orElseThrow(IllegalStateException::new));
                }
                future.complete(applications);
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<Application>> getApplicationAsync(String id) {
        CompletableFuture<Optional<Application>> future = new CompletableFuture<Optional<Application>>();
        this.executor.submit(() -> {
            try {
                CsarDTO csar = this.client.getCsar(id);
                ServiceTemplateDTO serviceTemplate = this.client.getServiceTemplates(id).getServiceTemplates().get(0);
                String serviceTemplateId = this.encodeValue(serviceTemplate.getId());
                List<InterfaceDTO> interfaces = this.client.getBoundaryDefinitionInterfaces(csar.getId(), this.encodeValue(serviceTemplate.getId())).getInterfaces();
                PlanDTO buildPlan = this.client.getBuildPlans(csar.getId(), this.encodeValue(serviceTemplate.getId())).getPlans().get(0);
                List<NodeTemplateDTO> nodeTemplates = this.client.getNodeTemplates(csar.getId(), serviceTemplateId).getNodeTemplates();
                PlanInstanceListDTO planInstanceList = this.client.getBuildPlanInstances(buildPlan.getId(), csar.getId(), serviceTemplateId);
                List<PlanInstanceDTO> buildPlanInstances = planInstanceList.getPlanInstances();
                List<String> fileLocations = this.getApplicationContent(id);
                Application application = Application.builder().csar(csar).serviceTemplate(serviceTemplate).nodeTemplates(nodeTemplates).buildPlanInstances(buildPlanInstances).buildPlan(buildPlan).interfaces(interfaces).fileLocations(fileLocations).build();
                future.complete(Optional.of(application));
            }
            catch (ApiException e) {
                logger.error("HTTP response code {} while executing request", (Object)e.getCode());
                future.complete(Optional.empty());
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Application> uploadApplicationAsync(Path path) {
        CompletableFuture<Application> future = new CompletableFuture<Application>();
        this.executor.submit(() -> {
            try {
                File file = path.toFile();
                if (!file.exists()) {
                    throw new FileNotFoundException("File does not exist");
                }
                Client httpClient = this.client.getApiClient().getHttpClient();
                FormDataMultiPart formData = new FormDataMultiPart();
                formData.bodyPart((BodyPart)new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                Response response = httpClient.target(this.client.getApiClient().getBasePath() + "/csars").request().post(Entity.entity((Object)formData, (MediaType)formData.getMediaType()));
                int status = response.getStatus();
                if (status >= 200 && status < 400) {
                    future.complete(this.getApplication(file.getName()).orElseThrow(IllegalStateException::new));
                } else {
                    logger.error("HTTP response code {} while uploading file", (Object)status);
                    future.completeExceptionally(new RuntimeException("Failed to upload file: " + file.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> removeApplicationAsync(Application application) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.executor.submit(() -> {
            try {
                this.client.deleteCsar(application.getId());
                future.complete(true);
            }
            catch (ApiException e) {
                logger.error("HTTP response code {} while executing request", (Object)e.getCode());
                future.complete(false);
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ApplicationInstance> provisionApplicationAsync(Application application, Map<String, String> inputParameters) {
        CompletableFuture<ApplicationInstance> future = new CompletableFuture<ApplicationInstance>();
        this.executor.submit(() -> {
            try {
                String csarId = application.getId();
                String planId = this.encodeValue(application.getBuildPlan().getId());
                String serviceTemplateId = this.encodeValue(application.getServiceTemplate().getId());
                List<TParameter> parameters = inputParameters.entrySet().stream().map(e -> {
                    TParameter p = new TParameter();
                    p.setName((String)e.getKey());
                    p.setValue((String)e.getValue());
                    p.setRequired(TParameter.RequiredEnum.YES);
                    p.setType("String");
                    return p;
                }).collect(Collectors.toList());
                String correlationId = this.client.invokeBuildPlan(planId, parameters, csarId, serviceTemplateId);
                PlanInstanceDTO pi = this.waitForFinishedPlan(planId, correlationId, csarId, serviceTemplateId, null);
                if (pi == null) {
                    throw new RuntimeException("Could not determine plan instance");
                }
                ApplicationInstance i = this.getApplicationInstance(application, pi.getServiceTemplateInstanceId().toString()).orElseThrow(IllegalStateException::new);
                future.complete(i);
            }
            catch (Exception e2) {
                logger.error("Error executing request", (Throwable)e2);
                future.completeExceptionally(e2);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<ApplicationInstance>> getApplicationInstancesAsync(Application application) {
        return this.getApplicationInstancesAsync(application, ServiceTemplateInstanceDTO.StateEnum.values());
    }

    @Override
    public CompletableFuture<List<ApplicationInstance>> getApplicationInstancesAsync(Application application, ServiceTemplateInstanceDTO.StateEnum ... state) {
        List<ServiceTemplateInstanceDTO.StateEnum> validStates = Arrays.asList(state);
        CompletableFuture<List<ApplicationInstance>> future = new CompletableFuture<List<ApplicationInstance>>();
        this.executor.submit(() -> {
            ArrayList<ApplicationInstance> applicationInstances = new ArrayList<ApplicationInstance>();
            try {
                String csarId = application.getId();
                String serviceTemplateId = this.encodeValue(application.getServiceTemplate().getId());
                for (ServiceTemplateInstanceDTO dto : this.client.getServiceTemplateInstances(csarId, serviceTemplateId).getServiceTemplateInstances()) {
                    applicationInstances.add(this.getApplicationInstance(application, dto.getId().toString()).orElseThrow(IllegalStateException::new));
                }
                future.complete(applicationInstances.stream().filter(a -> validStates.contains((Object)a.getState())).collect(Collectors.toList()));
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<ApplicationInstance>> getApplicationInstanceAsync(Application application, String id) {
        CompletableFuture<Optional<ApplicationInstance>> future = new CompletableFuture<Optional<ApplicationInstance>>();
        this.executor.submit(() -> {
            String csarId = application.getId();
            String serviceTemplateId = this.encodeValue(application.getServiceTemplate().getId());
            try {
                ServiceTemplateInstanceDTO serviceTemplateInstance = this.client.getServiceTemplateInstance(csarId, serviceTemplateId, Long.valueOf(id));
                List<PlanDTO> plans = this.client.getManagementPlans(csarId, serviceTemplateId, Long.valueOf(id)).getPlans();
                ArrayList nodeTemplateInstances = new ArrayList();
                application.getNodeTemplates().forEach(Exceptions.rethrow(nodeTemplate -> {
                    String nodeTemplateId = this.encodeValue(nodeTemplate.getId());
                    nodeTemplateInstances.addAll(this.client.getNodeTemplateInstances(nodeTemplateId, csarId, serviceTemplateId, null, null).getNodeTemplateInstances().stream().filter(n -> n.getServiceTemplateInstanceId().equals(serviceTemplateInstance.getId())).collect(Collectors.toList()));
                }));
                List<NodeInstance> nodeInstances = nodeTemplateInstances.stream().map(Exceptions.rethrow(n -> {
                    String nodeTemplateId = this.encodeValue(n.getNodeTemplateId());
                    Map<String, Object> properties = this.client.getNodeTemplateInstancePropertiesAsJson(nodeTemplateId, csarId, serviceTemplateId, n.getId());
                    return new NodeInstance((NodeTemplateInstanceDTO)n, properties);
                })).collect(Collectors.toList());
                ApplicationInstance applicationInstance = ApplicationInstance.builder().application(application).serviceTemplateInstance(serviceTemplateInstance).nodeInstances(nodeInstances).managementPlans(plans).build();
                future.complete(Optional.of(applicationInstance));
            }
            catch (ApiException e) {
                logger.error("HTTP response code {} while executing request", (Object)e.getCode());
                future.complete(Optional.empty());
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> terminateApplicationInstanceAsync(ApplicationInstance instance) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.executor.submit(() -> {
            try {
                Application application = instance.getApplication();
                String csarId = application.getId();
                String planId = this.encodeValue(instance.getTerminationPlan().getId());
                String serviceTemplateId = this.encodeValue(application.getServiceTemplate().getId());
                Long id = Long.valueOf(instance.getId());
                String correlationId = this.client.invokeManagementPlan(planId, new ArrayList<TParameter>(), csarId, serviceTemplateId, id);
                PlanInstanceDTO pi = this.waitForFinishedPlan(planId, correlationId, csarId, serviceTemplateId, id);
                if (pi == null) {
                    throw new RuntimeException("Could not determine plan instance");
                }
                ApplicationInstance i = this.getApplicationInstance(application, pi.getServiceTemplateInstanceId().toString()).orElseThrow(IllegalStateException::new);
                if (i.getState().equals((Object)ServiceTemplateInstanceDTO.StateEnum.DELETED)) {
                    future.complete(true);
                } else {
                    future.complete(false);
                }
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Map<String, String>> executeNodeOperationAsync(ApplicationInstance instance, NodeInstance node, String interfaceName, String operationName, Map<String, String> parameters) {
        ObjectMapper mapper = new ObjectMapper();
        String endpointUrlTemplate = "http://%s:8086/ManagementBus/v1/invoker";
        CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        this.executor.submit(() -> {
            try {
                String csarId = instance.getApplication().getId();
                String serviceTemplateId = instance.getApplication().getServiceTemplate().getId();
                InvocationRequest requestData = InvocationRequest.builder().data(InvocationRequest.InvocationData.builder().csarId(csarId).serviceTemplateId(serviceTemplateId).serviceInstanceId("null/" + instance.getId()).nodeTemplateId(node.getTemplate()).interfaceName(interfaceName).operationName(operationName).build()).parameters(parameters).build();
                ApiClient apiClient = this.client.getApiClient();
                Client httpClient = apiClient.getHttpClient();
                String hostname = this.extractHostname(apiClient.getBasePath());
                String endpointUrl = String.format(endpointUrlTemplate, hostname);
                logger.debug("Body: {}", (Object)mapper.writeValueAsString((Object)requestData));
                Response response = httpClient.target(endpointUrl).request(new String[]{"application/json"}).post(Entity.entity((Object)requestData, (String)"application/json"));
                int status = response.getStatus();
                if (status >= 200 && status < 400) {
                    Response clientResponse;
                    InvocationResponse invocationResponse;
                    String location = (String)response.getHeaders().getFirst((Object)"Location");
                    while ((invocationResponse = (InvocationResponse)(clientResponse = httpClient.target(location).request(new String[]{"application/json"}).get()).readEntity(InvocationResponse.class)).getStatus() != null && invocationResponse.getStatus().equals("PENDING")) {
                    }
                    logger.debug("Response: {}", (Object)invocationResponse);
                    future.complete(invocationResponse.getResponse());
                } else {
                    logger.error("HTTP response code {} while executing node operation", (Object)status);
                    future.completeExceptionally(new RuntimeException("Failed to execute node operation"));
                }
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public List<Application> getApplications() {
        try {
            return this.getApplicationsAsync().get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Application> getApplication(String id) {
        try {
            return this.getApplicationAsync(id).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Application uploadApplication(Path path) {
        try {
            return this.uploadApplicationAsync(path).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeApplication(Application application) {
        try {
            return this.removeApplicationAsync(application).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public ApplicationInstance provisionApplication(Application application, Map<String, String> inputParameters) {
        try {
            return this.provisionApplicationAsync(application, inputParameters).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ApplicationInstance> getApplicationInstances(Application application) {
        try {
            return this.getApplicationInstancesAsync(application).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ApplicationInstance> getApplicationInstances(Application application, ServiceTemplateInstanceDTO.StateEnum ... state) {
        try {
            return this.getApplicationInstancesAsync(application, state).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<ApplicationInstance> getApplicationInstance(Application application, String id) {
        try {
            return this.getApplicationInstanceAsync(application, id).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean terminateApplicationInstance(ApplicationInstance instance) {
        try {
            return this.terminateApplicationInstanceAsync(instance).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> executeNodeOperation(ApplicationInstance instance, NodeInstance node, String interfaceName, String operationName, Map<String, String> parameters) {
        try {
            return this.executeNodeOperationAsync(instance, node, interfaceName, operationName, parameters).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getApplicationContent(String id) {
        try {
            return this.getApplicationContentAsync(id).get();
        }
        catch (Exception e) {
            logger.error("Error while waiting for future to be completed");
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<List<String>> getApplicationContentAsync(String id) {
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.executor.submit(() -> {
            try {
                Client httpClient = this.client.getApiClient().getHttpClient();
                Response response = httpClient.target(this.getCSARContentUrl(id) + "?recursive").request().header("Accept", (Object)"application/xml").get();
                int status = response.getStatus();
                if (status >= 200 && status < 400) {
                    future.complete(this.getFileLocations((String)response.readEntity(String.class)));
                } else {
                    logger.error("HTTP response code {} while requesting application content", (Object)status);
                    future.completeExceptionally(new RuntimeException("Failed to request application content: " + id));
                }
            }
            catch (Exception e) {
                logger.error("Error executing request", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private PlanInstanceDTO waitForFinishedPlan(String plan, String instance, String csar, String serviceTemplate, Long id) {
        PlanInstanceDTO pi = null;
        long sleep = 5000L;
        long timeout = TimeUnit.MINUTES.toMillis(10L);
        long waited = 0L;
        while (true) {
            boolean finished;
            try {
                pi = id == null ? this.client.getBuildPlanInstance(plan, instance, csar, serviceTemplate) : this.client.getManagementPlanInstance(plan, instance, csar, serviceTemplate, id);
                finished = pi.getState().equals((Object)PlanInstanceDTO.StateEnum.FINISHED);
            }
            catch (Exception e) {
                finished = false;
            }
            if (finished) break;
            if (waited >= timeout) {
                logger.warn("Timeout reached, plan has net been finished yet");
                break;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            waited += 5000L;
        }
        return pi;
    }

    private String extractHostname(String basePath) {
        Pattern pattern = Pattern.compile("^https?://(.+):.+$");
        Matcher matcher = pattern.matcher(basePath);
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        return matcher.toMatchResult().group(1);
    }

    private String getCSARUrl(String applicationId) {
        return this.client.getApiClient().getBasePath() + "/csars/" + applicationId;
    }

    private String getCSARContentUrl(String applicationId) {
        return this.getCSARUrl(applicationId) + "/content";
    }

    private List<String> getFileLocations(String contentResponse) throws XPathExpressionException {
        ArrayList<String> locations = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//*[local-name()='Link']/@*[local-name()='href']", new InputSource(new StringReader(contentResponse)), XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            locations.add(nodes.item(i).getTextContent());
        }
        return locations;
    }
}

