/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class InvocationRequest {
    @JsonProperty(value="invocation-information")
    private InvocationData data;
    @JsonProperty(value="params")
    private Map<String, String> parameters;

    InvocationRequest(InvocationData data, Map<String, String> parameters) {
        this.data = data;
        this.parameters = parameters;
    }

    public static InvocationRequestBuilder builder() {
        return new InvocationRequestBuilder();
    }

    private InvocationRequest() {
    }

    public InvocationData getData() {
        return this.data;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setData(InvocationData data) {
        this.data = data;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationRequest)) {
            return false;
        }
        InvocationRequest other = (InvocationRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InvocationData this$data = this.getData();
        InvocationData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvocationRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InvocationData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "InvocationRequest(data=" + this.getData() + ", parameters=" + this.getParameters() + ")";
    }

    public static class InvocationRequestBuilder {
        private InvocationData data;
        private Map<String, String> parameters;

        InvocationRequestBuilder() {
        }

        public InvocationRequestBuilder data(InvocationData data) {
            this.data = data;
            return this;
        }

        public InvocationRequestBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public InvocationRequest build() {
            return new InvocationRequest(this.data, this.parameters);
        }

        public String toString() {
            return "InvocationRequest.InvocationRequestBuilder(data=" + this.data + ", parameters=" + this.parameters + ")";
        }
    }

    public static class InvocationData {
        @JsonProperty(value="csarID")
        private String csarId;
        @JsonProperty(value="serviceTemplateID")
        private String serviceTemplateId;
        @JsonProperty(value="serviceInstanceID")
        private String serviceInstanceId;
        @JsonProperty(value="nodeTemplateID")
        private String nodeTemplateId;
        @JsonProperty(value="interface")
        private String interfaceName;
        @JsonProperty(value="operation")
        private String operationName;

        InvocationData(String csarId, String serviceTemplateId, String serviceInstanceId, String nodeTemplateId, String interfaceName, String operationName) {
            this.csarId = csarId;
            this.serviceTemplateId = serviceTemplateId;
            this.serviceInstanceId = serviceInstanceId;
            this.nodeTemplateId = nodeTemplateId;
            this.interfaceName = interfaceName;
            this.operationName = operationName;
        }

        public static InvocationDataBuilder builder() {
            return new InvocationDataBuilder();
        }

        private InvocationData() {
        }

        public String getCsarId() {
            return this.csarId;
        }

        public String getServiceTemplateId() {
            return this.serviceTemplateId;
        }

        public String getServiceInstanceId() {
            return this.serviceInstanceId;
        }

        public String getNodeTemplateId() {
            return this.nodeTemplateId;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setCsarId(String csarId) {
            this.csarId = csarId;
        }

        public void setServiceTemplateId(String serviceTemplateId) {
            this.serviceTemplateId = serviceTemplateId;
        }

        public void setServiceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        public void setNodeTemplateId(String nodeTemplateId) {
            this.nodeTemplateId = nodeTemplateId;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvocationData)) {
                return false;
            }
            InvocationData other = (InvocationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$csarId = this.getCsarId();
            String other$csarId = other.getCsarId();
            if (this$csarId == null ? other$csarId != null : !this$csarId.equals(other$csarId)) {
                return false;
            }
            String this$serviceTemplateId = this.getServiceTemplateId();
            String other$serviceTemplateId = other.getServiceTemplateId();
            if (this$serviceTemplateId == null ? other$serviceTemplateId != null : !this$serviceTemplateId.equals(other$serviceTemplateId)) {
                return false;
            }
            String this$serviceInstanceId = this.getServiceInstanceId();
            String other$serviceInstanceId = other.getServiceInstanceId();
            if (this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId)) {
                return false;
            }
            String this$nodeTemplateId = this.getNodeTemplateId();
            String other$nodeTemplateId = other.getNodeTemplateId();
            if (this$nodeTemplateId == null ? other$nodeTemplateId != null : !this$nodeTemplateId.equals(other$nodeTemplateId)) {
                return false;
            }
            String this$interfaceName = this.getInterfaceName();
            String other$interfaceName = other.getInterfaceName();
            if (this$interfaceName == null ? other$interfaceName != null : !this$interfaceName.equals(other$interfaceName)) {
                return false;
            }
            String this$operationName = this.getOperationName();
            String other$operationName = other.getOperationName();
            return !(this$operationName == null ? other$operationName != null : !this$operationName.equals(other$operationName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvocationData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $csarId = this.getCsarId();
            result = result * 59 + ($csarId == null ? 43 : $csarId.hashCode());
            String $serviceTemplateId = this.getServiceTemplateId();
            result = result * 59 + ($serviceTemplateId == null ? 43 : $serviceTemplateId.hashCode());
            String $serviceInstanceId = this.getServiceInstanceId();
            result = result * 59 + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
            String $nodeTemplateId = this.getNodeTemplateId();
            result = result * 59 + ($nodeTemplateId == null ? 43 : $nodeTemplateId.hashCode());
            String $interfaceName = this.getInterfaceName();
            result = result * 59 + ($interfaceName == null ? 43 : $interfaceName.hashCode());
            String $operationName = this.getOperationName();
            result = result * 59 + ($operationName == null ? 43 : $operationName.hashCode());
            return result;
        }

        public String toString() {
            return "InvocationRequest.InvocationData(csarId=" + this.getCsarId() + ", serviceTemplateId=" + this.getServiceTemplateId() + ", serviceInstanceId=" + this.getServiceInstanceId() + ", nodeTemplateId=" + this.getNodeTemplateId() + ", interfaceName=" + this.getInterfaceName() + ", operationName=" + this.getOperationName() + ")";
        }

        public static class InvocationDataBuilder {
            private String csarId;
            private String serviceTemplateId;
            private String serviceInstanceId;
            private String nodeTemplateId;
            private String interfaceName;
            private String operationName;

            InvocationDataBuilder() {
            }

            public InvocationDataBuilder csarId(String csarId) {
                this.csarId = csarId;
                return this;
            }

            public InvocationDataBuilder serviceTemplateId(String serviceTemplateId) {
                this.serviceTemplateId = serviceTemplateId;
                return this;
            }

            public InvocationDataBuilder serviceInstanceId(String serviceInstanceId) {
                this.serviceInstanceId = serviceInstanceId;
                return this;
            }

            public InvocationDataBuilder nodeTemplateId(String nodeTemplateId) {
                this.nodeTemplateId = nodeTemplateId;
                return this;
            }

            public InvocationDataBuilder interfaceName(String interfaceName) {
                this.interfaceName = interfaceName;
                return this;
            }

            public InvocationDataBuilder operationName(String operationName) {
                this.operationName = operationName;
                return this;
            }

            public InvocationData build() {
                return new InvocationData(this.csarId, this.serviceTemplateId, this.serviceInstanceId, this.nodeTemplateId, this.interfaceName, this.operationName);
            }

            public String toString() {
                return "InvocationRequest.InvocationData.InvocationDataBuilder(csarId=" + this.csarId + ", serviceTemplateId=" + this.serviceTemplateId + ", serviceInstanceId=" + this.serviceInstanceId + ", nodeTemplateId=" + this.nodeTemplateId + ", interfaceName=" + this.interfaceName + ", operationName=" + this.operationName + ")";
            }
        }
    }
}

