/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Exceptions {
    public static <T> Consumer<T> rethrow(Consumer_WithExceptions<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                Exceptions.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R> Function<T, R> rethrow(Function_WithExceptions<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                Exceptions.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> Supplier<T> rethrow(Supplier_WithExceptions<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                Exceptions.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static void uncheck(Runnable_WithExceptions runnable) {
        try {
            runnable.accept();
        }
        catch (Exception exception) {
            Exceptions.throwAsUnchecked(exception);
        }
    }

    public static <R> R uncheck(Supplier_WithExceptions<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            Exceptions.throwAsUnchecked(exception);
            return null;
        }
    }

    public static <T, R> R uncheck(Function_WithExceptions<T, R> function, T t) {
        try {
            return function.apply(t);
        }
        catch (Exception exception) {
            Exceptions.throwAsUnchecked(exception);
            return null;
        }
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface Runnable_WithExceptions {
        public void accept() throws Exception;
    }

    @FunctionalInterface
    public static interface Supplier_WithExceptions<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Consumer_WithExceptions<T> {
        public void accept(T var1) throws Exception;
    }
}

