/*
 * Decompiled with CFR 0.152.
 */
package org.opentosca.container.client;

import java.util.concurrent.TimeUnit;
import org.opentosca.container.client.ContainerClient;
import org.opentosca.container.client.ContainerClientAsync;
import org.opentosca.container.client.SmartServiceContainerClient;
import org.opentosca.container.client.SmartServiceContainerClientAsync;
import org.opentosca.container.client.impl.SmartServiceSwaggerContainerClient;
import org.opentosca.container.client.impl.SwaggerContainerClient;

public final class ContainerClientBuilder {
    private String hostname = "localhost";
    private Integer port = 1337;
    private Integer timeout = (int)TimeUnit.MINUTES.toMillis(5L);

    public static ContainerClientBuilder builder() {
        return new ContainerClientBuilder();
    }

    public static ContainerClient defaultClient() {
        return ContainerClientBuilder.builder().build();
    }

    public static ContainerClientAsync defaultClientAsync() {
        return ContainerClientBuilder.builder().buildAsync();
    }

    public ContainerClientBuilder withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public ContainerClientBuilder withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ContainerClientBuilder withTimeout(Integer timeout, TimeUnit timeUnit) {
        this.timeout = (int)timeUnit.toMillis(timeout.intValue());
        return this;
    }

    public ContainerClient build() {
        return new SwaggerContainerClient("http://" + this.hostname + ":" + this.port, this.timeout);
    }

    public ContainerClientAsync buildAsync() {
        return new SwaggerContainerClient("http://" + this.hostname + ":" + this.port, this.timeout);
    }

    public SmartServiceContainerClient buildSmart() {
        return new SmartServiceSwaggerContainerClient("http://" + this.hostname + ":" + this.port, this.timeout);
    }

    public SmartServiceContainerClientAsync buildSmartAsync() {
        return new SmartServiceSwaggerContainerClient("http://" + this.hostname + ":" + this.port, this.timeout);
    }
}

