/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.model.CsarDTO;
import io.swagger.client.model.CsarListDTO;
import io.swagger.client.model.CsarUploadRequest;
import io.swagger.client.model.InterfaceDTO;
import io.swagger.client.model.InterfaceListDTO;
import io.swagger.client.model.NodeTemplateDTO;
import io.swagger.client.model.NodeTemplateInstanceDTO;
import io.swagger.client.model.NodeTemplateInstanceListDTO;
import io.swagger.client.model.NodeTemplateListDTO;
import io.swagger.client.model.PlanDTO;
import io.swagger.client.model.PlanInstanceDTO;
import io.swagger.client.model.PlanInstanceEventDTO;
import io.swagger.client.model.PlanInstanceListDTO;
import io.swagger.client.model.PlanListDTO;
import io.swagger.client.model.PropertiesDTO;
import io.swagger.client.model.RelationshipTemplateDTO;
import io.swagger.client.model.RelationshipTemplateInstanceDTO;
import io.swagger.client.model.RelationshipTemplateInstanceListDTO;
import io.swagger.client.model.RelationshipTemplateListDTO;
import io.swagger.client.model.ServiceTemplateDTO;
import io.swagger.client.model.ServiceTemplateInstanceDTO;
import io.swagger.client.model.ServiceTemplateInstanceListDTO;
import io.swagger.client.model.ServiceTemplateListDTO;
import io.swagger.client.model.TParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class DefaultApi {
    private ApiClient apiClient;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteCsar(String csar) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling deleteCsar");
        }
        String localVarPath = "/csars/{csar}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public InterfaceDTO getBoundaryDefinitionInterface(String name, String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling getBoundaryDefinitionInterface");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBoundaryDefinitionInterface");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBoundaryDefinitionInterface");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/boundarydefinitions/interfaces/{name}".replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<InterfaceDTO> localVarReturnType = new GenericType<InterfaceDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InterfaceListDTO getBoundaryDefinitionInterfaces(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBoundaryDefinitionInterfaces");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBoundaryDefinitionInterfaces");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/boundarydefinitions/interfaces".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<InterfaceListDTO> localVarReturnType = new GenericType<InterfaceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PropertiesDTO getBoundaryDefinitionProperties(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBoundaryDefinitionProperties");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBoundaryDefinitionProperties");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/boundarydefinitions/properties".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PropertiesDTO> localVarReturnType = new GenericType<PropertiesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanDTO getBuildPlan(String plan, String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getBuildPlan");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBuildPlan");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBuildPlan");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans/{plan}".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanDTO> localVarReturnType = new GenericType<PlanDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanInstanceDTO getBuildPlanInstance(String plan, String instance, String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getBuildPlanInstance");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling getBuildPlanInstance");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBuildPlanInstance");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBuildPlanInstance");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans/{plan}/instances/{instance}".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{instance\\}", this.apiClient.escapeString(instance.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanInstanceDTO> localVarReturnType = new GenericType<PlanInstanceDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PlanInstanceEventDTO> getBuildPlanInstanceLogs(String plan, String instance, String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getBuildPlanInstanceLogs");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling getBuildPlanInstanceLogs");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBuildPlanInstanceLogs");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBuildPlanInstanceLogs");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans/{plan}/instances/{instance}/logs".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{instance\\}", this.apiClient.escapeString(instance.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<PlanInstanceEventDTO>> localVarReturnType = new GenericType<List<PlanInstanceEventDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getBuildPlanInstanceState(String plan, String instance, String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getBuildPlanInstanceState");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling getBuildPlanInstanceState");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBuildPlanInstanceState");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBuildPlanInstanceState");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans/{plan}/instances/{instance}/state".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{instance\\}", this.apiClient.escapeString(instance.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanInstanceListDTO getBuildPlanInstances(String plan, String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getBuildPlanInstances");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBuildPlanInstances");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBuildPlanInstances");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans/{plan}/instances".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanInstanceListDTO> localVarReturnType = new GenericType<PlanInstanceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanListDTO getBuildPlans(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getBuildPlans");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getBuildPlans");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanListDTO> localVarReturnType = new GenericType<PlanListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CsarDTO getCsar(String csar) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getCsar");
        }
        String localVarPath = "/csars/{csar}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CsarDTO> localVarReturnType = new GenericType<CsarDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CsarListDTO getCsars() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/csars";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CsarListDTO> localVarReturnType = new GenericType<CsarListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InterfaceListDTO getInterfaces(String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getInterfaces");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getInterfaces");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getInterfaces");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/boundarydefinitions/interfaces".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<InterfaceListDTO> localVarReturnType = new GenericType<InterfaceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanDTO getManagementPlan(String plan, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getManagementPlan");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getManagementPlan");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getManagementPlan");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getManagementPlan");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans/{plan}".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanDTO> localVarReturnType = new GenericType<PlanDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanInstanceDTO getManagementPlanInstance(String plan, String instance, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getManagementPlanInstance");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling getManagementPlanInstance");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getManagementPlanInstance");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getManagementPlanInstance");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getManagementPlanInstance");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans/{plan}/instances/{instance}".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{instance\\}", this.apiClient.escapeString(instance.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanInstanceDTO> localVarReturnType = new GenericType<PlanInstanceDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PlanInstanceEventDTO> getManagementPlanInstanceLogs(String plan, String instance, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getManagementPlanInstanceLogs");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling getManagementPlanInstanceLogs");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getManagementPlanInstanceLogs");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getManagementPlanInstanceLogs");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getManagementPlanInstanceLogs");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans/{plan}/instances/{instance}/logs".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{instance\\}", this.apiClient.escapeString(instance.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<PlanInstanceEventDTO>> localVarReturnType = new GenericType<List<PlanInstanceEventDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getManagementPlanInstanceState(String plan, String instance, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getManagementPlanInstanceState");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling getManagementPlanInstanceState");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getManagementPlanInstanceState");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getManagementPlanInstanceState");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getManagementPlanInstanceState");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans/{plan}/instances/{instance}/state".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{instance\\}", this.apiClient.escapeString(instance.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanInstanceListDTO getManagementPlanInstances(String plan, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling getManagementPlanInstances");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getManagementPlanInstances");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getManagementPlanInstances");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getManagementPlanInstances");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans/{plan}/instances".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanInstanceListDTO> localVarReturnType = new GenericType<PlanInstanceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PlanListDTO getManagementPlans(String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getManagementPlans");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getManagementPlans");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getManagementPlans");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PlanListDTO> localVarReturnType = new GenericType<PlanListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NodeTemplateDTO getNodeTemplate(String csar, String servicetemplate, String nodetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getNodeTemplate");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getNodeTemplate");
        }
        if (nodetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'nodetemplate' when calling getNodeTemplate");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/nodetemplates/{nodetemplate}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{nodetemplate\\}", this.apiClient.escapeString(nodetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NodeTemplateDTO> localVarReturnType = new GenericType<NodeTemplateDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NodeTemplateInstanceDTO getNodeTemplateInstance(String nodetemplate, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (nodetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'nodetemplate' when calling getNodeTemplateInstance");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getNodeTemplateInstance");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getNodeTemplateInstance");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getNodeTemplateInstance");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/nodetemplates/{nodetemplate}/instances/{id}".replaceAll("\\{nodetemplate\\}", this.apiClient.escapeString(nodetemplate.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NodeTemplateInstanceDTO> localVarReturnType = new GenericType<NodeTemplateInstanceDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, Object> getNodeTemplateInstancePropertiesAsJson(String nodetemplate, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (nodetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'nodetemplate' when calling getNodeTemplateInstancePropertiesAsJson");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getNodeTemplateInstancePropertiesAsJson");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getNodeTemplateInstancePropertiesAsJson");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getNodeTemplateInstancePropertiesAsJson");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/nodetemplates/{nodetemplate}/instances/{id}/properties".replaceAll("\\{nodetemplate\\}", this.apiClient.escapeString(nodetemplate.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Map<String, Object>> localVarReturnType = new GenericType<Map<String, Object>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getNodeTemplateInstanceState(String nodetemplate, String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (nodetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'nodetemplate' when calling getNodeTemplateInstanceState");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getNodeTemplateInstanceState");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getNodeTemplateInstanceState");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getNodeTemplateInstanceState");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/nodetemplates/{nodetemplate}/instances/{id}/state".replaceAll("\\{nodetemplate\\}", this.apiClient.escapeString(nodetemplate.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NodeTemplateInstanceListDTO getNodeTemplateInstances(String nodetemplate, String csar, String servicetemplate, List<String> state, List<Long> source) throws ApiException {
        Object localVarPostBody = null;
        if (nodetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'nodetemplate' when calling getNodeTemplateInstances");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getNodeTemplateInstances");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getNodeTemplateInstances");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/nodetemplates/{nodetemplate}/instances".replaceAll("\\{nodetemplate\\}", this.apiClient.escapeString(nodetemplate.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "state", state));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "source", source));
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NodeTemplateInstanceListDTO> localVarReturnType = new GenericType<NodeTemplateInstanceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NodeTemplateListDTO getNodeTemplates(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getNodeTemplates");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getNodeTemplates");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/nodetemplates".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NodeTemplateListDTO> localVarReturnType = new GenericType<NodeTemplateListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RelationshipTemplateDTO getRelationshipTemplate(String csar, String servicetemplate, String relationshiptemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getRelationshipTemplate");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getRelationshipTemplate");
        }
        if (relationshiptemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'relationshiptemplate' when calling getRelationshipTemplate");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/relationshiptemplates/{relationshiptemplate}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{relationshiptemplate\\}", this.apiClient.escapeString(relationshiptemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RelationshipTemplateDTO> localVarReturnType = new GenericType<RelationshipTemplateDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RelationshipTemplateInstanceDTO getRelationshipTemplateInstance(String csar, String servicetemplate, String relationshiptemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getRelationshipTemplateInstance");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getRelationshipTemplateInstance");
        }
        if (relationshiptemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'relationshiptemplate' when calling getRelationshipTemplateInstance");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRelationshipTemplateInstance");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/relationshiptemplates/{relationshiptemplate}/instances/{id}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{relationshiptemplate\\}", this.apiClient.escapeString(relationshiptemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RelationshipTemplateInstanceDTO> localVarReturnType = new GenericType<RelationshipTemplateInstanceDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getRelationshipTemplateInstanceState(String csar, String servicetemplate, String relationshiptemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getRelationshipTemplateInstanceState");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getRelationshipTemplateInstanceState");
        }
        if (relationshiptemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'relationshiptemplate' when calling getRelationshipTemplateInstanceState");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getRelationshipTemplateInstanceState");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/relationshiptemplates/{relationshiptemplate}/instances/{id}/state".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{relationshiptemplate\\}", this.apiClient.escapeString(relationshiptemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RelationshipTemplateInstanceListDTO getRelationshipTemplateInstances(String csar, String servicetemplate, String relationshiptemplate, Long target) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getRelationshipTemplateInstances");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getRelationshipTemplateInstances");
        }
        if (relationshiptemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'relationshiptemplate' when calling getRelationshipTemplateInstances");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/relationshiptemplates/{relationshiptemplate}/instances".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{relationshiptemplate\\}", this.apiClient.escapeString(relationshiptemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "target", target));
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RelationshipTemplateInstanceListDTO> localVarReturnType = new GenericType<RelationshipTemplateInstanceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RelationshipTemplateListDTO getRelationshipTemplates(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getRelationshipTemplates");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getRelationshipTemplates");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/relationshiptemplates".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RelationshipTemplateListDTO> localVarReturnType = new GenericType<RelationshipTemplateListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServiceTemplateDTO getServiceTemplate(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getServiceTemplate");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getServiceTemplate");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ServiceTemplateDTO> localVarReturnType = new GenericType<ServiceTemplateDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServiceTemplateInstanceDTO getServiceTemplateInstance(String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getServiceTemplateInstance");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getServiceTemplateInstance");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getServiceTemplateInstance");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ServiceTemplateInstanceDTO> localVarReturnType = new GenericType<ServiceTemplateInstanceDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getServiceTemplateInstanceState(String csar, String servicetemplate, Long id) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getServiceTemplateInstanceState");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getServiceTemplateInstanceState");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getServiceTemplateInstanceState");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/state".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServiceTemplateInstanceListDTO getServiceTemplateInstances(String csar, String servicetemplate) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getServiceTemplateInstances");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling getServiceTemplateInstances");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ServiceTemplateInstanceListDTO> localVarReturnType = new GenericType<ServiceTemplateInstanceListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServiceTemplateListDTO getServiceTemplates(String csar) throws ApiException {
        Object localVarPostBody = null;
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling getServiceTemplates");
        }
        String localVarPath = "/csars/{csar}/servicetemplates".replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ServiceTemplateListDTO> localVarReturnType = new GenericType<ServiceTemplateListDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String invokeBuildPlan(String plan, List<TParameter> body, String csar, String servicetemplate) throws ApiException {
        List<TParameter> localVarPostBody = body;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling invokeBuildPlan");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling invokeBuildPlan");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling invokeBuildPlan");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling invokeBuildPlan");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/buildplans/{plan}/instances".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String invokeManagementPlan(String plan, List<TParameter> body, String csar, String servicetemplate, Long id) throws ApiException {
        List<TParameter> localVarPostBody = body;
        if (plan == null) {
            throw new ApiException(400, "Missing the required parameter 'plan' when calling invokeManagementPlan");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling invokeManagementPlan");
        }
        if (csar == null) {
            throw new ApiException(400, "Missing the required parameter 'csar' when calling invokeManagementPlan");
        }
        if (servicetemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'servicetemplate' when calling invokeManagementPlan");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling invokeManagementPlan");
        }
        String localVarPath = "/csars/{csar}/servicetemplates/{servicetemplate}/instances/{id}/managementplans/{plan}/instances".replaceAll("\\{plan\\}", this.apiClient.escapeString(plan.toString())).replaceAll("\\{csar\\}", this.apiClient.escapeString(csar.toString())).replaceAll("\\{servicetemplate\\}", this.apiClient.escapeString(servicetemplate.toString())).replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void uploadCsar(CsarUploadRequest body) throws ApiException {
        CsarUploadRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadCsar");
        }
        String localVarPath = "/csars";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

