/*
 * Decompiled with CFR 0.152.
 */
package com.onecode.stickyheadergrid.tonicartos;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersBaseAdapter;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersSimpleAdapter;
import java.util.ArrayList;
import java.util.HashMap;

public class StickyGridHeadersSimpleAdapterWrapper
extends BaseAdapter
implements StickyGridHeadersBaseAdapter {
    private StickyGridHeadersSimpleAdapter mDelegate;
    private HeaderData[] mHeaders;

    public StickyGridHeadersSimpleAdapterWrapper(StickyGridHeadersSimpleAdapter adapter) {
        this.mDelegate = adapter;
        adapter.registerDataSetObserver(new DataSetObserverExtension());
        this.mHeaders = this.generateHeaderList(adapter);
    }

    public int getCount() {
        return this.mDelegate.getCount();
    }

    @Override
    public int getCountForHeader(int position) {
        return this.mHeaders[position].getCount();
    }

    @Override
    public View getHeaderView(int position, View convertView, ViewGroup parent) {
        return this.mDelegate.getHeaderView(this.mHeaders[position].getRefPosition(), convertView, parent);
    }

    public Object getItem(int position) {
        return this.mDelegate.getItem(position);
    }

    public long getItemId(int position) {
        return this.mDelegate.getItemId(position);
    }

    public int getItemViewType(int position) {
        return this.mDelegate.getItemViewType(position);
    }

    @Override
    public int getNumHeaders() {
        return this.mHeaders.length;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.mDelegate.getView(position, convertView, parent);
    }

    public int getViewTypeCount() {
        return this.mDelegate.getViewTypeCount();
    }

    public boolean hasStableIds() {
        return this.mDelegate.hasStableIds();
    }

    protected HeaderData[] generateHeaderList(StickyGridHeadersSimpleAdapter adapter) {
        HashMap<Long, HeaderData> mapping = new HashMap<Long, HeaderData>();
        ArrayList<HeaderData> headers = new ArrayList<HeaderData>();
        for (int i = 0; i < adapter.getCount(); ++i) {
            long headerId = adapter.getHeaderId(i);
            HeaderData headerData = (HeaderData)mapping.get(headerId);
            if (headerData == null) {
                headerData = new HeaderData(i);
                headers.add(headerData);
            }
            headerData.incrementCount();
            mapping.put(headerId, headerData);
        }
        return headers.toArray(new HeaderData[headers.size()]);
    }

    static /* synthetic */ HeaderData[] access$102(StickyGridHeadersSimpleAdapterWrapper x0, HeaderData[] x1) {
        x0.mHeaders = x1;
        return x1;
    }

    private class HeaderData {
        private int mCount;
        private int mRefPosition;

        public HeaderData(int refPosition) {
            this.mRefPosition = refPosition;
            this.mCount = 0;
        }

        public int getCount() {
            return this.mCount;
        }

        public int getRefPosition() {
            return this.mRefPosition;
        }

        public void incrementCount() {
            ++this.mCount;
        }
    }

    private final class DataSetObserverExtension
    extends DataSetObserver {
        private DataSetObserverExtension() {
        }

        public void onChanged() {
            StickyGridHeadersSimpleAdapterWrapper.access$102(StickyGridHeadersSimpleAdapterWrapper.this, StickyGridHeadersSimpleAdapterWrapper.this.generateHeaderList(StickyGridHeadersSimpleAdapterWrapper.this.mDelegate));
            StickyGridHeadersSimpleAdapterWrapper.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            StickyGridHeadersSimpleAdapterWrapper.access$102(StickyGridHeadersSimpleAdapterWrapper.this, StickyGridHeadersSimpleAdapterWrapper.this.generateHeaderList(StickyGridHeadersSimpleAdapterWrapper.this.mDelegate));
            StickyGridHeadersSimpleAdapterWrapper.this.notifyDataSetInvalidated();
        }
    }
}

