/*
 * Decompiled with CFR 0.152.
 */
package com.onecode.stickyheadergrid.tonicartos;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersBaseAdapter;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersBaseAdapterWrapper;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersListAdapterWrapper;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersSimpleAdapter;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersSimpleAdapterWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class StickyGridHeadersGridView
extends GridView
implements AbsListView.OnScrollListener,
AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener,
AdapterView.OnItemLongClickListener {
    private static final String ERROR_PLATFORM = "Error supporting platform " + Build.VERSION.SDK_INT + ".";
    private static final int MATCHED_STICKIED_HEADER = -2;
    private static final int NO_MATCHED_HEADER = -1;
    protected static final int TOUCH_MODE_DONE_WAITING = 2;
    protected static final int TOUCH_MODE_DOWN = 0;
    protected static final int TOUCH_MODE_FINISHED_LONG_PRESS = -2;
    protected static final int TOUCH_MODE_REST = -1;
    protected static final int TOUCH_MODE_TAP = 1;
    static final String TAG = StickyGridHeadersGridView.class.getSimpleName();
    public CheckForHeaderLongPress mPendingCheckForLongPress;
    public CheckForHeaderTap mPendingCheckForTap;
    private boolean mAreHeadersSticky = true;
    private final Rect mClippingRect = new Rect();
    private boolean mClippingToPadding;
    private boolean mClipToPaddingHasBeenSet;
    private int mColumnWidth;
    private long mCurrentHeaderId = -1L;
    private DataSetObserver mDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            StickyGridHeadersGridView.this.reset();
        }

        public void onInvalidated() {
            StickyGridHeadersGridView.this.reset();
        }
    };
    private int mHeaderBottomPosition;
    private boolean mHeadersIgnorePadding;
    private int mHorizontalSpacing;
    private boolean mMaskStickyHeaderRegion = true;
    private float mMotionY;
    private int mNumColumns;
    private boolean mNumColumnsSet;
    private int mNumMeasuredColumns = 1;
    private OnHeaderClickListener mOnHeaderClickListener;
    private OnHeaderLongClickListener mOnHeaderLongClickListener;
    private AdapterView.OnItemClickListener mOnItemClickListener;
    private AdapterView.OnItemLongClickListener mOnItemLongClickListener;
    private AdapterView.OnItemSelectedListener mOnItemSelectedListener;
    private PerformHeaderClick mPerformHeaderClick;
    private AbsListView.OnScrollListener mScrollListener;
    private int mScrollState = 0;
    private View mStickiedHeader;
    private Runnable mTouchModeReset;
    private int mTouchSlop;
    private int mVerticalSpacing;
    protected StickyGridHeadersBaseAdapterWrapper mAdapter;
    protected boolean mDataChanged;
    protected int mMotionHeaderPosition;
    protected int mTouchMode;
    boolean mHeaderChildBeingPressed = false;

    private static MotionEvent.PointerCoords[] getPointerCoords(MotionEvent e) {
        int n = e.getPointerCount();
        MotionEvent.PointerCoords[] r = new MotionEvent.PointerCoords[n];
        for (int i = 0; i < n; ++i) {
            r[i] = new MotionEvent.PointerCoords();
            e.getPointerCoords(i, r[i]);
        }
        return r;
    }

    private static int[] getPointerIds(MotionEvent e) {
        int n = e.getPointerCount();
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = e.getPointerId(i);
        }
        return r;
    }

    public StickyGridHeadersGridView(Context context) {
        this(context, null);
    }

    public StickyGridHeadersGridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010071);
    }

    public StickyGridHeadersGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.setVerticalFadingEdgeEnabled(false);
        if (!this.mNumColumnsSet) {
            this.mNumColumns = -1;
        }
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mTouchSlop = vc.getScaledTouchSlop();
    }

    public boolean areHeadersSticky() {
        return this.mAreHeadersSticky;
    }

    public View getHeaderAt(int position) {
        if (position == -2) {
            return this.mStickiedHeader;
        }
        try {
            return (View)this.getChildAt(position).getTag();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public View getStickiedHeader() {
        return this.mStickiedHeader;
    }

    public boolean getStickyHeaderIsTranscluent() {
        return !this.mMaskStickyHeaderRegion;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        this.mOnItemClickListener.onItemClick(parent, view, this.mAdapter.translatePosition((int)position).mPosition, id);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        return this.mOnItemLongClickListener.onItemLongClick(parent, view, this.mAdapter.translatePosition((int)position).mPosition, id);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        this.mOnItemSelectedListener.onItemSelected(parent, view, this.mAdapter.translatePosition((int)position).mPosition, id);
    }

    public void onNothingSelected(AdapterView<?> parent) {
        this.mOnItemSelectedListener.onNothingSelected(parent);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mAreHeadersSticky = ss.areHeadersSticky;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.areHeadersSticky = this.mAreHeadersSticky;
        return ss;
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        if (Build.VERSION.SDK_INT >= 8) {
            this.scrollChanged(firstVisibleItem);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
        this.mScrollState = scrollState;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        boolean wasHeaderChildBeingPressed = this.mHeaderChildBeingPressed;
        if (this.mHeaderChildBeingPressed) {
            View headerHolder;
            View tempHeader = this.getHeaderAt(this.mMotionHeaderPosition);
            View view = headerHolder = this.mMotionHeaderPosition == -2 ? tempHeader : this.getChildAt(this.mMotionHeaderPosition);
            if (action == 1 || action == 3) {
                this.mHeaderChildBeingPressed = false;
            }
            if (tempHeader != null) {
                tempHeader.dispatchTouchEvent(this.transformEvent(ev, this.mMotionHeaderPosition));
                tempHeader.invalidate();
                tempHeader.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        StickyGridHeadersGridView.this.invalidate(0, headerHolder.getTop(), StickyGridHeadersGridView.this.getWidth(), headerHolder.getTop() + headerHolder.getHeight());
                    }
                }, (long)ViewConfiguration.getPressedStateDuration());
                this.invalidate(0, headerHolder.getTop(), this.getWidth(), headerHolder.getTop() + headerHolder.getHeight());
            }
        }
        switch (action & 0xFF) {
            case 0: {
                if (this.mPendingCheckForTap == null) {
                    this.mPendingCheckForTap = new CheckForHeaderTap();
                }
                this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                int y = (int)ev.getY();
                this.mMotionY = y;
                this.mMotionHeaderPosition = this.findMotionHeader(y);
                if (this.mMotionHeaderPosition == -1 || this.mScrollState == 2) break;
                View tempHeader = this.getHeaderAt(this.mMotionHeaderPosition);
                if (tempHeader != null) {
                    if (tempHeader.dispatchTouchEvent(this.transformEvent(ev, this.mMotionHeaderPosition))) {
                        this.mHeaderChildBeingPressed = true;
                        tempHeader.setPressed(true);
                    }
                    tempHeader.invalidate();
                    if (this.mMotionHeaderPosition != -2) {
                        tempHeader = this.getChildAt(this.mMotionHeaderPosition);
                    }
                    this.invalidate(0, tempHeader.getTop(), this.getWidth(), tempHeader.getTop() + tempHeader.getHeight());
                }
                this.mTouchMode = 0;
                return true;
            }
            case 2: {
                Handler handler;
                if (this.mMotionHeaderPosition == -1 || !(Math.abs(ev.getY() - this.mMotionY) > (float)this.mTouchSlop)) break;
                this.mTouchMode = -1;
                final View header = this.getHeaderAt(this.mMotionHeaderPosition);
                if (header != null) {
                    header.setPressed(false);
                    header.invalidate();
                }
                if ((handler = this.getHandler()) != null) {
                    handler.removeCallbacks((Runnable)this.mPendingCheckForLongPress);
                }
                this.mMotionHeaderPosition = -1;
                break;
            }
            case 1: {
                if (this.mTouchMode == -2) {
                    this.mTouchMode = -1;
                    return true;
                }
                if (this.mTouchMode == -1 || this.mMotionHeaderPosition == -1) break;
                final View header = this.getHeaderAt(this.mMotionHeaderPosition);
                if (!wasHeaderChildBeingPressed && header != null) {
                    if (this.mTouchMode != 0) {
                        header.setPressed(false);
                    }
                    if (this.mPerformHeaderClick == null) {
                        this.mPerformHeaderClick = new PerformHeaderClick();
                    }
                    final PerformHeaderClick performHeaderClick = this.mPerformHeaderClick;
                    performHeaderClick.mClickMotionPosition = this.mMotionHeaderPosition;
                    performHeaderClick.rememberWindowAttachCount();
                    if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                        Handler handler = this.getHandler();
                        if (handler != null) {
                            handler.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                        }
                        if (!this.mDataChanged) {
                            this.mTouchMode = 1;
                            header.setPressed(true);
                            this.setPressed(true);
                            if (this.mTouchModeReset != null) {
                                this.removeCallbacks(this.mTouchModeReset);
                            }
                            this.mTouchModeReset = new Runnable(){

                                @Override
                                public void run() {
                                    StickyGridHeadersGridView.this.mMotionHeaderPosition = -1;
                                    StickyGridHeadersGridView.this.mTouchModeReset = null;
                                    StickyGridHeadersGridView.this.mTouchMode = -1;
                                    header.setPressed(false);
                                    StickyGridHeadersGridView.this.setPressed(false);
                                    header.invalidate();
                                    StickyGridHeadersGridView.this.invalidate(0, header.getTop(), StickyGridHeadersGridView.this.getWidth(), header.getHeight());
                                    if (!StickyGridHeadersGridView.this.mDataChanged) {
                                        performHeaderClick.run();
                                    }
                                }
                            };
                            this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                        } else {
                            this.mTouchMode = -1;
                        }
                    } else if (!this.mDataChanged) {
                        performHeaderClick.run();
                    }
                }
                this.mTouchMode = -1;
                return true;
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean performHeaderClick(View view, long id) {
        if (this.mOnHeaderClickListener != null) {
            this.playSoundEffect(0);
            if (view != null) {
                view.sendAccessibilityEvent(1);
            }
            this.mOnHeaderClickListener.onHeaderClick((AdapterView<?>)this, view, id);
            return true;
        }
        return false;
    }

    public boolean performHeaderLongPress(View view, long id) {
        boolean handled = false;
        if (this.mOnHeaderLongClickListener != null) {
            handled = this.mOnHeaderLongClickListener.onHeaderLongClick((AdapterView<?>)this, view, id);
        }
        if (handled) {
            if (view != null) {
                view.sendAccessibilityEvent(2);
            }
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        if (!this.mClipToPaddingHasBeenSet) {
            this.mClippingToPadding = true;
        }
        StickyGridHeadersBaseAdapter baseAdapter = adapter instanceof StickyGridHeadersBaseAdapter ? (StickyGridHeadersBaseAdapter)adapter : (adapter instanceof StickyGridHeadersSimpleAdapter ? new StickyGridHeadersSimpleAdapterWrapper((StickyGridHeadersSimpleAdapter)adapter) : new StickyGridHeadersListAdapterWrapper(adapter));
        this.mAdapter = new StickyGridHeadersBaseAdapterWrapper(this.getContext(), this, baseAdapter);
        this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        this.reset();
        super.setAdapter((ListAdapter)this.mAdapter);
    }

    public void setAreHeadersSticky(boolean useStickyHeaders) {
        if (useStickyHeaders != this.mAreHeadersSticky) {
            this.mAreHeadersSticky = useStickyHeaders;
            this.requestLayout();
        }
    }

    public void setClipToPadding(boolean clipToPadding) {
        super.setClipToPadding(clipToPadding);
        this.mClippingToPadding = clipToPadding;
        this.mClipToPaddingHasBeenSet = true;
    }

    public void setColumnWidth(int columnWidth) {
        super.setColumnWidth(columnWidth);
        this.mColumnWidth = columnWidth;
    }

    public void setHeadersIgnorePadding(boolean b) {
        this.mHeadersIgnorePadding = b;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        super.setHorizontalSpacing(horizontalSpacing);
        this.mHorizontalSpacing = horizontalSpacing;
    }

    public void setNumColumns(int numColumns) {
        super.setNumColumns(numColumns);
        this.mNumColumnsSet = true;
        this.mNumColumns = numColumns;
        if (numColumns != -1 && this.mAdapter != null) {
            this.mAdapter.setNumColumns(numColumns);
        }
    }

    public void setOnHeaderClickListener(OnHeaderClickListener listener) {
        this.mOnHeaderClickListener = listener;
    }

    public void setOnHeaderLongClickListener(OnHeaderLongClickListener listener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnHeaderLongClickListener = listener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        super.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
        super.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
        super.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mScrollListener = listener;
    }

    public void setStickyHeaderIsTranscluent(boolean isTranscluent) {
        this.mMaskStickyHeaderRegion = !isTranscluent;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        super.setVerticalSpacing(verticalSpacing);
        this.mVerticalSpacing = verticalSpacing;
    }

    private int findMotionHeader(float y) {
        if (this.mStickiedHeader != null && y <= (float)this.mHeaderBottomPosition) {
            return -2;
        }
        int vi = 0;
        int i = this.getFirstVisiblePosition();
        while (i <= this.getLastVisiblePosition()) {
            long id = this.getItemIdAtPosition(i);
            if (id == -1L) {
                View headerWrapper = this.getChildAt(vi);
                int bottom = headerWrapper.getBottom();
                int top = headerWrapper.getTop();
                if (y <= (float)bottom && y >= (float)top) {
                    return vi;
                }
            }
            i += this.mNumMeasuredColumns;
            vi += this.mNumMeasuredColumns;
        }
        return -1;
    }

    private int getHeaderHeight() {
        if (this.mStickiedHeader != null) {
            return this.mStickiedHeader.getMeasuredHeight();
        }
        return 0;
    }

    private long headerViewPositionToId(int pos) {
        if (pos == -2) {
            return this.mCurrentHeaderId;
        }
        return this.mAdapter.getHeaderId(this.getFirstVisiblePosition() + pos);
    }

    private void measureHeader() {
        if (this.mStickiedHeader == null) {
            return;
        }
        int widthMeasureSpec = this.mHeadersIgnorePadding ? View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
        int heightMeasureSpec = 0;
        ViewGroup.LayoutParams params = this.mStickiedHeader.getLayoutParams();
        heightMeasureSpec = params != null && params.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)params.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mStickiedHeader.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.mStickiedHeader.measure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeadersIgnorePadding) {
            this.mStickiedHeader.layout(this.getLeft(), 0, this.getRight(), this.mStickiedHeader.getMeasuredHeight());
        } else {
            this.mStickiedHeader.layout(this.getLeft() + this.getPaddingLeft(), 0, this.getRight() - this.getPaddingRight(), this.mStickiedHeader.getMeasuredHeight());
        }
    }

    private void reset() {
        this.mHeaderBottomPosition = 0;
        this.swapStickiedHeader(null);
        this.mCurrentHeaderId = Long.MIN_VALUE;
    }

    private void scrollChanged(int firstVisibleItem) {
        int childCount;
        long newHeaderId;
        int secondRowPosition;
        if (this.mAdapter == null || this.mAdapter.getCount() == 0 || !this.mAreHeadersSticky) {
            return;
        }
        View firstItem = this.getChildAt(0);
        if (firstItem == null) {
            return;
        }
        int selectedHeaderPosition = firstVisibleItem;
        int beforeRowPosition = firstVisibleItem - this.mNumMeasuredColumns;
        if (beforeRowPosition < 0) {
            beforeRowPosition = firstVisibleItem;
        }
        if ((secondRowPosition = firstVisibleItem + this.mNumMeasuredColumns) >= this.mAdapter.getCount()) {
            secondRowPosition = firstVisibleItem;
        }
        if (this.mVerticalSpacing == 0) {
            newHeaderId = this.mAdapter.getHeaderId(firstVisibleItem);
        } else if (this.mVerticalSpacing < 0) {
            newHeaderId = this.mAdapter.getHeaderId(firstVisibleItem);
            View firstSecondRowView = this.getChildAt(this.mNumMeasuredColumns);
            if (firstSecondRowView.getTop() <= 0) {
                newHeaderId = this.mAdapter.getHeaderId(secondRowPosition);
                selectedHeaderPosition = secondRowPosition;
            } else {
                newHeaderId = this.mAdapter.getHeaderId(firstVisibleItem);
            }
        } else {
            int margin = this.getChildAt(0).getTop();
            if (0 < margin && margin < this.mVerticalSpacing) {
                newHeaderId = this.mAdapter.getHeaderId(beforeRowPosition);
                selectedHeaderPosition = beforeRowPosition;
            } else {
                newHeaderId = this.mAdapter.getHeaderId(firstVisibleItem);
            }
        }
        if (this.mCurrentHeaderId != newHeaderId) {
            this.swapStickiedHeader(this.mAdapter.getHeaderView(selectedHeaderPosition, this.mStickiedHeader, (ViewGroup)this));
            this.measureHeader();
            this.mCurrentHeaderId = newHeaderId;
        }
        if ((childCount = this.getChildCount()) != 0) {
            View viewToWatch = null;
            int watchingChildDistance = 99999;
            for (int i = 0; i < childCount; i += this.mNumMeasuredColumns) {
                View child = super.getChildAt(i);
                int childDistance = this.mClippingToPadding ? child.getTop() - this.getPaddingTop() : child.getTop();
                if (childDistance < 0 || this.mAdapter.getItemId(this.getPositionForView(child)) != -1L || childDistance >= watchingChildDistance) continue;
                viewToWatch = child;
                watchingChildDistance = childDistance;
            }
            int headerHeight = this.getHeaderHeight();
            if (viewToWatch != null) {
                if (firstVisibleItem == 0 && super.getChildAt(0).getTop() > 0 && !this.mClippingToPadding) {
                    this.mHeaderBottomPosition = 0;
                } else if (this.mClippingToPadding) {
                    this.mHeaderBottomPosition = Math.min(viewToWatch.getTop(), headerHeight + this.getPaddingTop());
                    this.mHeaderBottomPosition = this.mHeaderBottomPosition < this.getPaddingTop() ? headerHeight + this.getPaddingTop() : this.mHeaderBottomPosition;
                } else {
                    this.mHeaderBottomPosition = Math.min(viewToWatch.getTop(), headerHeight);
                    this.mHeaderBottomPosition = this.mHeaderBottomPosition < 0 ? headerHeight : this.mHeaderBottomPosition;
                }
            } else {
                this.mHeaderBottomPosition = headerHeight;
                if (this.mClippingToPadding) {
                    this.mHeaderBottomPosition += this.getPaddingTop();
                }
            }
        }
    }

    private void swapStickiedHeader(View newStickiedHeader) {
        this.detachHeader(this.mStickiedHeader);
        this.attachHeader(newStickiedHeader);
        this.mStickiedHeader = newStickiedHeader;
    }

    private MotionEvent transformEvent(MotionEvent e, int headerPosition) {
        if (headerPosition == -2) {
            return e;
        }
        long downTime = e.getDownTime();
        long eventTime = e.getEventTime();
        int action = e.getAction();
        int pointerCount = e.getPointerCount();
        int[] pointerIds = StickyGridHeadersGridView.getPointerIds(e);
        MotionEvent.PointerCoords[] pointerCoords = StickyGridHeadersGridView.getPointerCoords(e);
        int metaState = e.getMetaState();
        float xPrecision = e.getXPrecision();
        float yPrecision = e.getYPrecision();
        int deviceId = e.getDeviceId();
        int edgeFlags = e.getEdgeFlags();
        int source = e.getSource();
        int flags = e.getFlags();
        View headerHolder = this.getChildAt(headerPosition);
        for (int i = 0; i < pointerCount; ++i) {
            pointerCoords[i].y -= (float)headerHolder.getTop();
        }
        MotionEvent n = MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (int)pointerCount, (int[])pointerIds, (MotionEvent.PointerCoords[])pointerCoords, (int)metaState, (float)xPrecision, (float)yPrecision, (int)deviceId, (int)edgeFlags, (int)source, (int)flags);
        return n;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT < 8) {
            this.scrollChanged(this.getFirstVisiblePosition());
        }
        boolean drawStickiedHeader = this.mStickiedHeader != null && this.mAreHeadersSticky && this.mStickiedHeader.getVisibility() == 0;
        int headerHeight = this.getHeaderHeight();
        int top = this.mHeaderBottomPosition - headerHeight;
        if (drawStickiedHeader && this.mMaskStickyHeaderRegion) {
            if (this.mHeadersIgnorePadding) {
                this.mClippingRect.left = 0;
                this.mClippingRect.right = this.getWidth();
            } else {
                this.mClippingRect.left = this.getPaddingLeft();
                this.mClippingRect.right = this.getWidth() - this.getPaddingRight();
            }
            this.mClippingRect.top = this.mHeaderBottomPosition;
            this.mClippingRect.bottom = this.getHeight();
            canvas.save();
            canvas.clipRect(this.mClippingRect);
        }
        super.dispatchDraw(canvas);
        ArrayList<Integer> headerPositions = new ArrayList<Integer>();
        int vi = 0;
        int i = this.getFirstVisiblePosition();
        while (i <= this.getLastVisiblePosition()) {
            long id = this.getItemIdAtPosition(i);
            if (id == -1L) {
                headerPositions.add(vi);
            }
            i += this.mNumMeasuredColumns;
            vi += this.mNumMeasuredColumns;
        }
        for (i = 0; i < headerPositions.size(); ++i) {
            boolean headerIsStickied;
            View header;
            View frame = this.getChildAt((Integer)headerPositions.get(i));
            try {
                header = (View)frame.getTag();
            }
            catch (Exception e) {
                return;
            }
            boolean bl = headerIsStickied = (long)((StickyGridHeadersBaseAdapterWrapper.HeaderFillerView)frame).getHeaderId() == this.mCurrentHeaderId && frame.getTop() < 0 && this.mAreHeadersSticky;
            if (header.getVisibility() != 0 || headerIsStickied) continue;
            int widthMeasureSpec = this.mHeadersIgnorePadding ? View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            header.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            header.measure(widthMeasureSpec, heightMeasureSpec);
            if (this.mHeadersIgnorePadding) {
                header.layout(this.getLeft(), 0, this.getRight(), frame.getHeight());
            } else {
                header.layout(this.getLeft() + this.getPaddingLeft(), 0, this.getRight() - this.getPaddingRight(), frame.getHeight());
            }
            if (this.mHeadersIgnorePadding) {
                this.mClippingRect.left = 0;
                this.mClippingRect.right = this.getWidth();
            } else {
                this.mClippingRect.left = this.getPaddingLeft();
                this.mClippingRect.right = this.getWidth() - this.getPaddingRight();
            }
            this.mClippingRect.bottom = frame.getBottom();
            this.mClippingRect.top = frame.getTop();
            canvas.save();
            canvas.clipRect(this.mClippingRect);
            if (this.mHeadersIgnorePadding) {
                canvas.translate(0.0f, (float)frame.getTop());
            } else {
                canvas.translate((float)this.getPaddingLeft(), (float)frame.getTop());
            }
            header.draw(canvas);
            canvas.restore();
        }
        if (drawStickiedHeader && this.mMaskStickyHeaderRegion) {
            canvas.restore();
        } else if (!drawStickiedHeader) {
            return;
        }
        int wantedWidth = this.mHeadersIgnorePadding ? this.getWidth() : this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        if (this.mStickiedHeader.getWidth() != wantedWidth) {
            int widthMeasureSpec = this.mHeadersIgnorePadding ? View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.mStickiedHeader.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mStickiedHeader.measure(widthMeasureSpec, heightMeasureSpec);
            if (this.mHeadersIgnorePadding) {
                this.mStickiedHeader.layout(this.getLeft(), 0, this.getRight(), this.mStickiedHeader.getHeight());
            } else {
                this.mStickiedHeader.layout(this.getLeft() + this.getPaddingLeft(), 0, this.getRight() - this.getPaddingRight(), this.mStickiedHeader.getHeight());
            }
        }
        if (this.mHeadersIgnorePadding) {
            this.mClippingRect.left = 0;
            this.mClippingRect.right = this.getWidth();
        } else {
            this.mClippingRect.left = this.getPaddingLeft();
            this.mClippingRect.right = this.getWidth() - this.getPaddingRight();
        }
        this.mClippingRect.bottom = top + headerHeight;
        this.mClippingRect.top = this.mClippingToPadding ? this.getPaddingTop() : 0;
        canvas.save();
        canvas.clipRect(this.mClippingRect);
        if (this.mHeadersIgnorePadding) {
            canvas.translate(0.0f, (float)top);
        } else {
            canvas.translate((float)this.getPaddingLeft(), (float)top);
        }
        if (this.mHeaderBottomPosition != headerHeight) {
            canvas.saveLayerAlpha(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), 255 * this.mHeaderBottomPosition / headerHeight, 31);
        }
        this.mStickiedHeader.draw(canvas);
        if (this.mHeaderBottomPosition != headerHeight) {
            canvas.restore();
        }
        canvas.restore();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mNumColumns == -1) {
            int numFittedColumns;
            if (this.mColumnWidth > 0) {
                int gridWidth = Math.max(View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight(), 0);
                numFittedColumns = gridWidth / this.mColumnWidth;
                if (numFittedColumns > 0) {
                    while (numFittedColumns != 1 && numFittedColumns * this.mColumnWidth + (numFittedColumns - 1) * this.mHorizontalSpacing > gridWidth) {
                        --numFittedColumns;
                    }
                } else {
                    numFittedColumns = 1;
                }
            } else {
                numFittedColumns = 2;
            }
            this.mNumMeasuredColumns = numFittedColumns;
        } else {
            this.mNumMeasuredColumns = this.mNumColumns;
        }
        if (this.mAdapter != null) {
            this.mAdapter.setNumColumns(this.mNumMeasuredColumns);
        }
        this.measureHeader();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    void attachHeader(View header) {
        if (header == null) {
            return;
        }
        try {
            Field attachInfoField = View.class.getDeclaredField("mAttachInfo");
            attachInfoField.setAccessible(true);
            Method method = View.class.getDeclaredMethod("dispatchAttachedToWindow", Class.forName("android.view.View$AttachInfo"), Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)header, attachInfoField.get((Object)this), 8);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimePlatformSupportException(e);
        }
    }

    void detachHeader(View header) {
        if (header == null) {
            return;
        }
        try {
            Method method = View.class.getDeclaredMethod("dispatchDetachedFromWindow", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)header, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimePlatformSupportException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimePlatformSupportException(e);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean areHeadersSticky;

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.areHeadersSticky = in.readByte() != 0;
        }

        public String toString() {
            return "StickyGridHeadersGridView.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " areHeadersSticky=" + this.areHeadersSticky + "}";
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.areHeadersSticky ? 1 : 0));
        }
    }

    class RuntimePlatformSupportException
    extends RuntimeException {
        private static final long serialVersionUID = -6512098808936536538L;

        public RuntimePlatformSupportException(Exception e) {
            super(ERROR_PLATFORM, e);
        }
    }

    final class CheckForHeaderTap
    implements Runnable {
        CheckForHeaderTap() {
        }

        @Override
        public void run() {
            if (StickyGridHeadersGridView.this.mTouchMode == 0) {
                StickyGridHeadersGridView.this.mTouchMode = 1;
                View header = StickyGridHeadersGridView.this.getHeaderAt(StickyGridHeadersGridView.this.mMotionHeaderPosition);
                if (header != null && !StickyGridHeadersGridView.this.mHeaderChildBeingPressed) {
                    if (!StickyGridHeadersGridView.this.mDataChanged) {
                        header.setPressed(true);
                        StickyGridHeadersGridView.this.setPressed(true);
                        StickyGridHeadersGridView.this.refreshDrawableState();
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = StickyGridHeadersGridView.this.isLongClickable();
                        if (longClickable) {
                            if (StickyGridHeadersGridView.this.mPendingCheckForLongPress == null) {
                                StickyGridHeadersGridView.this.mPendingCheckForLongPress = new CheckForHeaderLongPress();
                            }
                            StickyGridHeadersGridView.this.mPendingCheckForLongPress.rememberWindowAttachCount();
                            StickyGridHeadersGridView.this.postDelayed(StickyGridHeadersGridView.this.mPendingCheckForLongPress, longPressTimeout);
                        } else {
                            StickyGridHeadersGridView.this.mTouchMode = 2;
                        }
                    } else {
                        StickyGridHeadersGridView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    private class WindowRunnable {
        private int mOriginalAttachCount;

        private WindowRunnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = StickyGridHeadersGridView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return StickyGridHeadersGridView.this.hasWindowFocus() && StickyGridHeadersGridView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }

    private class PerformHeaderClick
    extends WindowRunnable
    implements Runnable {
        int mClickMotionPosition;

        private PerformHeaderClick() {
        }

        @Override
        public void run() {
            View view;
            if (StickyGridHeadersGridView.this.mDataChanged) {
                return;
            }
            if (StickyGridHeadersGridView.this.mAdapter != null && StickyGridHeadersGridView.this.mAdapter.getCount() > 0 && this.mClickMotionPosition != -1 && this.mClickMotionPosition < StickyGridHeadersGridView.this.mAdapter.getCount() && this.sameWindow() && (view = StickyGridHeadersGridView.this.getHeaderAt(this.mClickMotionPosition)) != null) {
                StickyGridHeadersGridView.this.performHeaderClick(view, StickyGridHeadersGridView.this.headerViewPositionToId(this.mClickMotionPosition));
            }
        }
    }

    private class CheckForHeaderLongPress
    extends WindowRunnable
    implements Runnable {
        private CheckForHeaderLongPress() {
        }

        @Override
        public void run() {
            View child = StickyGridHeadersGridView.this.getHeaderAt(StickyGridHeadersGridView.this.mMotionHeaderPosition);
            if (child != null) {
                long longPressId = StickyGridHeadersGridView.this.headerViewPositionToId(StickyGridHeadersGridView.this.mMotionHeaderPosition);
                boolean handled = false;
                if (this.sameWindow() && !StickyGridHeadersGridView.this.mDataChanged) {
                    handled = StickyGridHeadersGridView.this.performHeaderLongPress(child, longPressId);
                }
                if (handled) {
                    StickyGridHeadersGridView.this.mTouchMode = -2;
                    StickyGridHeadersGridView.this.setPressed(false);
                    child.setPressed(false);
                } else {
                    StickyGridHeadersGridView.this.mTouchMode = 2;
                }
            }
        }
    }

    public static interface OnHeaderLongClickListener {
        public boolean onHeaderLongClick(AdapterView<?> var1, View var2, long var3);
    }

    public static interface OnHeaderClickListener {
        public void onHeaderClick(AdapterView<?> var1, View var2, long var3);
    }
}

