/*
 * Decompiled with CFR 0.152.
 */
package com.onecode.stickyheadergrid.tonicartos;

import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersBaseAdapter;
import com.onecode.stickyheadergrid.tonicartos.StickyGridHeadersGridView;

public class StickyGridHeadersBaseAdapterWrapper
extends BaseAdapter {
    private static final int sNumViewTypes = 3;
    protected static final int ID_FILLER = -2;
    protected static final int ID_HEADER = -1;
    protected static final int ID_HEADER_FILLER = -3;
    protected static final int POSITION_FILLER = -1;
    protected static final int POSITION_HEADER = -2;
    protected static final int POSITION_HEADER_FILLER = -3;
    protected static final int VIEW_TYPE_FILLER = 0;
    protected static final int VIEW_TYPE_HEADER = 1;
    protected static final int VIEW_TYPE_HEADER_FILLER = 2;
    private final Context mContext;
    private int mCount;
    private boolean mCounted = false;
    private DataSetObserver mDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            StickyGridHeadersBaseAdapterWrapper.this.updateCount();
        }

        public void onInvalidated() {
            StickyGridHeadersBaseAdapterWrapper.this.mCounted = false;
        }
    };
    private final StickyGridHeadersBaseAdapter mDelegate;
    private StickyGridHeadersGridView mGridView;
    private View mLastHeaderViewSeen;
    private View mLastViewSeen;
    private int mNumColumns = 1;

    public StickyGridHeadersBaseAdapterWrapper(Context context, StickyGridHeadersGridView gridView, StickyGridHeadersBaseAdapter delegate) {
        this.mContext = context;
        this.mDelegate = delegate;
        this.mGridView = gridView;
        delegate.registerDataSetObserver(this.mDataSetObserver);
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public int getCount() {
        if (this.mCounted) {
            return this.mCount;
        }
        this.mCount = 0;
        int numHeaders = this.mDelegate.getNumHeaders();
        if (numHeaders == 0) {
            this.mCount = this.mDelegate.getCount();
            this.mCounted = true;
            return this.mCount;
        }
        for (int i = 0; i < numHeaders; ++i) {
            this.mCount += this.mDelegate.getCountForHeader(i) + this.unFilledSpacesInHeaderGroup(i) + this.mNumColumns;
        }
        this.mCounted = true;
        return this.mCount;
    }

    public Object getItem(int position) throws ArrayIndexOutOfBoundsException {
        Position adapterPosition = this.translatePosition(position);
        if (adapterPosition.mPosition == -1 || adapterPosition.mPosition == -2) {
            return null;
        }
        return this.mDelegate.getItem(adapterPosition.mPosition);
    }

    public long getItemId(int position) {
        Position adapterPosition = this.translatePosition(position);
        if (adapterPosition.mPosition == -2) {
            return -1L;
        }
        if (adapterPosition.mPosition == -1) {
            return -2L;
        }
        if (adapterPosition.mPosition == -3) {
            return -3L;
        }
        return this.mDelegate.getItemId(adapterPosition.mPosition);
    }

    public int getItemViewType(int position) {
        Position adapterPosition = this.translatePosition(position);
        if (adapterPosition.mPosition == -2) {
            return 1;
        }
        if (adapterPosition.mPosition == -1) {
            return 0;
        }
        if (adapterPosition.mPosition == -3) {
            return 2;
        }
        int itemViewType = this.mDelegate.getItemViewType(adapterPosition.mPosition);
        if (itemViewType == -1) {
            return itemViewType;
        }
        return itemViewType + 3;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Position adapterPosition = this.translatePosition(position);
        if (adapterPosition.mPosition == -2) {
            HeaderFillerView v = this.getHeaderFillerView(adapterPosition.mHeader, (View)convertView, parent);
            View view = this.mDelegate.getHeaderView(adapterPosition.mHeader, (View)v.getTag(), parent);
            this.mGridView.detachHeader((View)v.getTag());
            v.setTag(view);
            this.mGridView.attachHeader(view);
            convertView = v;
            this.mLastHeaderViewSeen = v;
            v.forceLayout();
        } else if (adapterPosition.mPosition == -3) {
            convertView = this.getFillerView((View)convertView, parent, this.mLastHeaderViewSeen);
            convertView.forceLayout();
        } else if (adapterPosition.mPosition == -1) {
            convertView = this.getFillerView((View)convertView, parent, this.mLastViewSeen);
        } else {
            this.mLastViewSeen = convertView = this.mDelegate.getView(adapterPosition.mPosition, (View)convertView, parent);
        }
        return convertView;
    }

    public int getViewTypeCount() {
        return this.mDelegate.getViewTypeCount() + 3;
    }

    public StickyGridHeadersBaseAdapter getWrappedAdapter() {
        return this.mDelegate;
    }

    public boolean hasStableIds() {
        return this.mDelegate.hasStableIds();
    }

    public boolean isEmpty() {
        return this.mDelegate.isEmpty();
    }

    public boolean isEnabled(int position) {
        Position adapterPosition = this.translatePosition(position);
        if (adapterPosition.mPosition == -1 || adapterPosition.mPosition == -2) {
            return false;
        }
        return this.mDelegate.isEnabled(adapterPosition.mPosition);
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        super.registerDataSetObserver(observer);
        this.mDelegate.registerDataSetObserver(observer);
    }

    public void setNumColumns(int numColumns) {
        this.mNumColumns = numColumns;
        this.mCounted = false;
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        super.unregisterDataSetObserver(observer);
        this.mDelegate.unregisterDataSetObserver(observer);
    }

    private FillerView getFillerView(View convertView, ViewGroup parent, View lastViewSeen) {
        FillerView fillerView = (FillerView)convertView;
        if (fillerView == null) {
            fillerView = new FillerView(this.mContext);
        }
        fillerView.setMeasureTarget(lastViewSeen);
        return fillerView;
    }

    private HeaderFillerView getHeaderFillerView(int headerPosition, View convertView, ViewGroup parent) {
        HeaderFillerView headerFillerView = (HeaderFillerView)convertView;
        if (headerFillerView == null) {
            headerFillerView = new HeaderFillerView(this.mContext);
        }
        return headerFillerView;
    }

    private int unFilledSpacesInHeaderGroup(int header) {
        if (this.mNumColumns == 0) {
            return 0;
        }
        int remainder = this.mDelegate.getCountForHeader(header) % this.mNumColumns;
        return remainder == 0 ? 0 : this.mNumColumns - remainder;
    }

    protected long getHeaderId(int position) {
        return this.translatePosition((int)position).mHeader;
    }

    protected View getHeaderView(int position, View convertView, ViewGroup parent) {
        if (this.mDelegate.getNumHeaders() == 0) {
            return null;
        }
        return this.mDelegate.getHeaderView(this.translatePosition((int)position).mHeader, convertView, parent);
    }

    protected Position translatePosition(int position) {
        int i;
        int numHeaders = this.mDelegate.getNumHeaders();
        if (numHeaders == 0) {
            if (position >= this.mDelegate.getCount()) {
                return new Position(-1, 0);
            }
            return new Position(position, 0);
        }
        int adapterPosition = position;
        int place = position;
        for (i = 0; i < numHeaders; ++i) {
            int sectionCount = this.mDelegate.getCountForHeader(i);
            if (place == 0) {
                return new Position(-2, i);
            }
            if ((place -= this.mNumColumns) < 0) {
                return new Position(-3, i);
            }
            adapterPosition -= this.mNumColumns;
            if (place < sectionCount) {
                return new Position(adapterPosition, i);
            }
            int filler = this.unFilledSpacesInHeaderGroup(i);
            adapterPosition -= filler;
            if ((place -= sectionCount + filler) >= 0) continue;
            return new Position(-1, i);
        }
        return new Position(-1, i);
    }

    protected void updateCount() {
        this.mCount = 0;
        int numHeaders = this.mDelegate.getNumHeaders();
        if (numHeaders == 0) {
            this.mCount = this.mDelegate.getCount();
            this.mCounted = true;
            return;
        }
        for (int i = 0; i < numHeaders; ++i) {
            this.mCount += this.mDelegate.getCountForHeader(i) + this.mNumColumns;
        }
        this.mCounted = true;
    }

    protected class Position {
        protected int mHeader;
        protected int mPosition;

        protected Position(int position, int header) {
            this.mPosition = position;
            this.mHeader = header;
        }
    }

    protected class HeaderHolder {
        protected View mHeaderView;

        protected HeaderHolder() {
        }
    }

    protected class HeaderFillerView
    extends FrameLayout {
        private int mHeaderId;

        public HeaderFillerView(Context context) {
            super(context);
        }

        public HeaderFillerView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public HeaderFillerView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public int getHeaderId() {
            return this.mHeaderId;
        }

        public void setHeaderId(int headerId) {
            this.mHeaderId = headerId;
        }

        protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
            return new FrameLayout.LayoutParams(-1, -1);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            View v = (View)this.getTag();
            ViewGroup.LayoutParams params = v.getLayoutParams();
            if (params == null) {
                params = this.generateDefaultLayoutParams();
                v.setLayoutParams(params);
            }
            if (v.getVisibility() != 8) {
                int heightSpec = HeaderFillerView.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)0, (int)0), (int)0, (int)params.height);
                int widthSpec = HeaderFillerView.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)StickyGridHeadersBaseAdapterWrapper.this.mGridView.getWidth(), (int)0x40000000), (int)0, (int)params.width);
                v.measure(widthSpec, heightSpec);
            }
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), v.getMeasuredHeight());
        }
    }

    protected class FillerView
    extends View {
        private View mMeasureTarget;

        public FillerView(Context context) {
            super(context);
        }

        public FillerView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public FillerView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public void setMeasureTarget(View lastViewSeen) {
            this.mMeasureTarget = lastViewSeen;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMeasureTarget.getMeasuredHeight(), (int)0x40000000);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

