/*
 * Decompiled with CFR 0.152.
 */
package com.onecode.stickyheadergrid.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.onecode.stickyheadergrid.viewholder.BaseViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class UtilAdapter<T, VH extends BaseViewHolder>
extends BaseAdapter {
    private List<T> mDataset = new ArrayList<T>();
    protected Context mContext;

    public UtilAdapter(Context context) {
        this.mContext = context;
    }

    public int getCount() {
        return this.mDataset.size();
    }

    public T getItem(int position) {
        return this.mDataset.get(position);
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        BaseViewHolder vh;
        if (view == null) {
            view = View.inflate((Context)this.mContext, (int)this.layout(), null);
            vh = this.viewHolder(view);
            view.setTag((Object)vh);
        } else {
            vh = (BaseViewHolder)view.getTag();
        }
        this.populate(this.getItem(position), vh);
        return view;
    }

    protected abstract int layout();

    protected abstract VH viewHolder(View var1);

    protected abstract void populate(T var1, VH var2);

    public final void insert(T elem, int position) {
        this.mDataset.add(position, elem);
        this.notifyDataSetChanged();
    }

    public final void appendTop(T elem) {
        this.insert(elem, 0);
    }

    public final void appendTopAll(Collection<T> elems) {
        this.mDataset.addAll(0, elems);
        this.notifyDataSetChanged();
    }

    public final void appendBottom(T elem) {
        this.insert(elem, this.mDataset.size());
    }

    public final void appendBottomAll(Collection<T> elems) {
        int startIndex = this.mDataset.size();
        this.mDataset.addAll(startIndex, elems);
        this.notifyDataSetChanged();
    }

    public final void remove(int position) {
        this.mDataset.remove(position);
        this.notifyDataSetChanged();
    }

    public final void clear() {
        int size = this.mDataset.size();
        this.mDataset.clear();
        this.notifyDataSetChanged();
    }
}

