/*
 * Decompiled with CFR 0.152.
 */
package cn.nodemedia;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class NodePlayer
implements TextureView.SurfaceTextureListener {
    public static final int LOG_LEVEL_ERROR = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final String RTSP_TRANSPORT_UDP = "udp";
    public static final String RTSP_TRANSPORT_TCP = "tcp";
    public static final String RTSP_TRANSPORT_UDP_MULTICAST = "udp_multicast";
    public static final String RTSP_TRANSPORT_HTTP = "http";
    private static final String TAG = "NodeMedia.java";
    private OnNodePlayerEventListener onNodePlayerEventListener = null;
    private TextureView tv = null;
    private Context ctx;
    private long id;
    private FrameLayout.LayoutParams LP = new FrameLayout.LayoutParams(-1, -1, 17);

    public NodePlayer(Context context, String license) {
        this.id = this.jniInit(context, license);
        this.ctx = context;
    }

    protected void finalize() {
        this.jniFree();
    }

    public void attachView(ViewGroup vg) {
        if (this.tv == null) {
            this.tv = new TextureView(this.ctx);
            this.tv.setLayoutParams((ViewGroup.LayoutParams)this.LP);
            this.tv.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            this.tv.setKeepScreenOn(true);
            vg.addView((View)this.tv);
        }
    }

    public TextureView getTextureView() {
        return this.tv;
    }

    public void detachView() {
        if (this.tv != null) {
            this.tv.setKeepScreenOn(false);
            this.tv = null;
        }
    }

    public void setOnNodePlayerEventListener(OnNodePlayerEventListener listener) {
        this.onNodePlayerEventListener = listener;
    }

    private void onEvent(int event, String msg) {
        if (this.onNodePlayerEventListener != null) {
            this.onNodePlayerEventListener.onEventCallback(this, event, msg);
        }
    }

    private native long jniInit(Context var1, String var2);

    private native void jniFree();

    public native int start(String var1);

    public native int stop();

    public native int pause(boolean var1);

    public native int seek(long var1);

    public native int screenshot(String var1);

    public native int startRecord(String var1);

    public native int stopRecord();

    public native boolean isVod();

    public native boolean isPause();

    public native long getDuration();

    public native long getCurrentPosition();

    public native long getBufferPosition();

    public native int getBufferPercentage();

    public native boolean isPlaying();

    public native void setLogLevel(int var1);

    public native void setBufferTime(int var1);

    public native void setScaleMode(int var1);

    public native void setVideoSurface(Surface var1);

    public native void setRTMPPageUrl(String var1);

    public native void setRTMPSwfUrl(String var1);

    public native void setRTSPTransport(String var1);

    public native void setHTTPReferer(String var1);

    public native void setHTTPUserAgent(String var1);

    public native void setCryptoKey(String var1);

    public native void setVolume(float var1);

    public native void setHWAccelEnable(boolean var1);

    public native void resizeVideoSurface();

    public native void rotateVideo(int var1);

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        this.setVideoSurface(new Surface(surfaceTexture));
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        this.resizeVideoSurface();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    static {
        System.loadLibrary("NodeMediaClient");
    }

    public static interface OnNodePlayerEventListener {
        public void onEventCallback(NodePlayer var1, int var2, String var3);
    }
}

