/*
 * Decompiled with CFR 0.152.
 */
package cn.nodemedia;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class NodePlayerView
extends FrameLayout
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener {
    private Context mContext;
    private RenderCallback mRenderCallback;
    private View renderView;
    private RenderType mCurrentRenderType;
    private UIViewContentMode mUIViewContentMode = UIViewContentMode.ScaleToFill;
    private FrameLayout.LayoutParams deflp = new FrameLayout.LayoutParams(-1, -1, 17);
    private Surface mSurface;
    private int mCanvasWidth = 0;
    private int mCanvasHeight = 0;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private float mZoomScale = 1.0f;
    private boolean isSurfaceCreate = false;
    private boolean isMediaOverlay = false;
    private final Runnable measureAndLayout = new Runnable(){

        @Override
        public void run() {
            NodePlayerView.this.measure(View.MeasureSpec.makeMeasureSpec((int)NodePlayerView.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)NodePlayerView.this.getHeight(), (int)0x40000000));
            NodePlayerView.this.layout(NodePlayerView.this.getLeft(), NodePlayerView.this.getTop(), NodePlayerView.this.getRight(), NodePlayerView.this.getBottom());
        }
    };

    public NodePlayerView(Context context) {
        super(context);
        this.initView(context);
    }

    public NodePlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public NodePlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @TargetApi(value=21)
    public NodePlayerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        this.setRenderType(RenderType.SURFACEVIEW);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mCanvasWidth = this.getWidth();
        this.mCanvasHeight = this.getHeight();
        if (this.isSurfaceCreate && this.mVideoWidth > 0 && this.mVideoWidth > 0) {
            this.setVideoSize(this.mVideoWidth, this.mVideoHeight);
        }
    }

    public void setRenderCallback(RenderCallback callback) {
        this.mRenderCallback = callback;
        if (this.isSurfaceCreate) {
            this.mRenderCallback.onSurfaceCreated(this.mSurface);
        }
    }

    public void setRenderType(RenderType renderType) {
        TextureView tv;
        SurfaceView sv;
        if (this.mCurrentRenderType == renderType) {
            return;
        }
        if (this.mCurrentRenderType == RenderType.SURFACEVIEW) {
            sv = (SurfaceView)this.renderView;
            sv.getHolder().removeCallback((SurfaceHolder.Callback)this);
            this.removeView(this.renderView);
            this.renderView = null;
        } else if (this.mCurrentRenderType == RenderType.TEXTUREVIEW) {
            tv = (TextureView)this.renderView;
            tv.setSurfaceTextureListener(null);
            this.removeView(this.renderView);
            this.renderView = null;
        }
        if (renderType == RenderType.SURFACEVIEW) {
            sv = new SurfaceView(this.mContext);
            sv.getHolder().addCallback((SurfaceHolder.Callback)this);
            sv.setLayoutParams((ViewGroup.LayoutParams)this.deflp);
            this.renderView = sv;
            this.addView(this.renderView);
        } else if (renderType == RenderType.TEXTUREVIEW) {
            tv = new TextureView(this.mContext);
            tv.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            tv.setLayoutParams((ViewGroup.LayoutParams)this.deflp);
            this.renderView = tv;
            this.addView(this.renderView);
        }
        this.mCurrentRenderType = renderType;
    }

    public RenderType getRenderType() {
        return this.mCurrentRenderType;
    }

    public View getRenderView() {
        return this.renderView;
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.renderView.setVisibility(visibility);
    }

    public void setVideoSize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.setUIViewContentMode(this.mUIViewContentMode);
    }

    public void setZoomScale(float zoomScale) {
        this.mZoomScale = zoomScale;
    }

    public void setUIViewContentMode(UIViewContentMode mode) {
        this.mUIViewContentMode = mode;
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            return;
        }
        Handler mainHandler = new Handler(this.mContext.getMainLooper());
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                float specAspectRatio = (float)NodePlayerView.this.mCanvasWidth / (float)NodePlayerView.this.mCanvasHeight;
                float displayAspectRatio = (float)NodePlayerView.this.mVideoWidth / (float)NodePlayerView.this.mVideoHeight;
                boolean shouldBeWider = displayAspectRatio > specAspectRatio;
                int fixWidth = NodePlayerView.this.mCanvasWidth;
                int fixHeight = NodePlayerView.this.mCanvasHeight;
                switch (NodePlayerView.this.mUIViewContentMode) {
                    case ScaleToFill: {
                        fixWidth = NodePlayerView.this.mCanvasWidth;
                        fixHeight = NodePlayerView.this.mCanvasHeight;
                        break;
                    }
                    case ScaleAspectFit: {
                        if (shouldBeWider) {
                            fixWidth = NodePlayerView.this.mCanvasWidth;
                            fixHeight = (int)((float)fixWidth / displayAspectRatio);
                            break;
                        }
                        fixHeight = NodePlayerView.this.mCanvasHeight;
                        fixWidth = (int)((float)fixHeight * displayAspectRatio);
                        break;
                    }
                    case ScaleAspectFill: {
                        if (shouldBeWider) {
                            fixHeight = NodePlayerView.this.mCanvasHeight;
                            fixWidth = (int)((float)fixHeight * displayAspectRatio);
                            break;
                        }
                        fixWidth = NodePlayerView.this.mCanvasWidth;
                        fixHeight = (int)((float)fixWidth / displayAspectRatio);
                    }
                }
                fixWidth = (int)((float)fixWidth * NodePlayerView.this.mZoomScale);
                fixHeight = (int)((float)fixHeight * NodePlayerView.this.mZoomScale);
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(fixWidth, fixHeight, 17);
                NodePlayerView.this.renderView.setLayoutParams((ViewGroup.LayoutParams)lp);
                NodePlayerView.this.requestLayout();
            }
        };
        mainHandler.post(myRunnable);
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.isSurfaceCreate = true;
        this.mSurface = surfaceHolder.getSurface();
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceCreated(this.mSurface);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceChanged(width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.isSurfaceCreate = false;
        this.mSurface = null;
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceDestroyed();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        this.isSurfaceCreate = true;
        this.mSurface = new Surface(surfaceTexture);
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceCreated(this.mSurface);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int wdith, int height) {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceChanged(wdith, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.isSurfaceCreate = false;
        if (this.mRenderCallback != null) {
            this.mSurface = null;
            surfaceTexture.release();
            this.mRenderCallback.onSurfaceDestroyed();
        }
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    static interface RenderCallback {
        public void onSurfaceCreated(@NonNull Surface var1);

        public void onSurfaceChanged(int var1, int var2);

        public void onSurfaceDestroyed();
    }

    public static enum UIViewContentMode {
        ScaleToFill,
        ScaleAspectFit,
        ScaleAspectFill;

    }

    public static enum RenderType {
        SURFACEVIEW,
        TEXTUREVIEW;

    }
}

