/*
 * Decompiled with CFR 0.152.
 */
package cn.nodemedia;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.view.Surface;
import cn.nodemedia.NodePlayerDelegate;
import cn.nodemedia.NodePlayerView;
import java.util.ArrayList;
import java.util.List;

public class NodePlayer
implements NodePlayerView.RenderCallback {
    private long id;
    private NodePlayerView mNodePlayerView;
    private NodePlayerDelegate mNodePlayerDelegate;
    private static AudioManager.OnAudioFocusChangeListener sAudioFocusChangeListener;
    private static List<NodePlayer> players;
    private String inputUrl;
    private String pageUrl;
    private String swfUrl;
    private String connArgs;
    private String cryptoKey;
    private String rtspTransport;
    private int bufferTime;
    private int maxBufferTime;
    private int autoReconnectWaitTimeout;
    private int connectWaitTimeout;
    private int logLevel;
    private boolean hwEnable;
    private boolean audioEnable;
    private boolean videoEnable;
    private boolean subscribe;
    public static final String RTSP_TRANSPORT_UDP = "udp";
    public static final String RTSP_TRANSPORT_TCP = "tcp";
    public static final String RTSP_TRANSPORT_UDP_MULTICAST = "udp_multicast";
    public static final String RTSP_TRANSPORT_HTTP = "http";
    public static final int NM_LOGLEVEL_ERROR = 0;
    public static final int NM_LOGLEVEL_INFO = 1;
    public static final int NM_LOGLEVEL_DEBUG = 2;

    public NodePlayer(@NonNull Context context) {
        this(context, "");
    }

    public NodePlayer(@NonNull Context context, @NonNull String license) {
        this.id = this.jniInit(context, license);
        this.inputUrl = "";
        this.pageUrl = "";
        this.swfUrl = "";
        this.connArgs = "";
        this.cryptoKey = "";
        this.logLevel = 0;
        this.rtspTransport = RTSP_TRANSPORT_UDP;
        this.bufferTime = 500;
        this.maxBufferTime = 1000;
        this.autoReconnectWaitTimeout = 2000;
        this.connectWaitTimeout = 0;
        this.hwEnable = true;
        this.audioEnable = true;
        this.videoEnable = true;
        this.subscribe = false;
        if (sAudioFocusChangeListener == null) {
            sAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                public void onAudioFocusChange(int focusChange) {
                    block3: {
                        block2: {
                            if (focusChange != -2) break block2;
                            for (NodePlayer player : players) {
                                if (!player.audioEnable) continue;
                                player.jniSetAudioEnable(false);
                            }
                            break block3;
                        }
                        if (focusChange != 1) break block3;
                        for (NodePlayer player : players) {
                            if (!player.audioEnable) continue;
                            player.jniSetAudioEnable(true);
                        }
                    }
                }
            };
            AudioManager am = (AudioManager)context.getSystemService("audio");
            am.requestAudioFocus(sAudioFocusChangeListener, 3, 1);
        }
        players.add(this);
    }

    public void release() {
        final NodePlayer self = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                self.mNodePlayerDelegate = null;
                self.mNodePlayerView = null;
                self.jniDeInit();
                self.id = 0L;
                players.remove(self);
            }
        }).start();
    }

    public void setInputUrl(@NonNull String inputUrl) {
        this.inputUrl = inputUrl.trim();
    }

    public void setPageUrl(@NonNull String pageUrl) {
        this.pageUrl = pageUrl.trim();
    }

    public void setSwfUrl(@NonNull String swfUrl) {
        this.swfUrl = swfUrl.trim();
    }

    public void setConnArgs(@NonNull String connArgs) {
        this.connArgs = connArgs;
    }

    public void setRtspTransport(@NonNull String rtspTransport) {
        this.rtspTransport = rtspTransport;
    }

    public void setBufferTime(int bufferTime) {
        this.bufferTime = bufferTime;
    }

    public void setMaxBufferTime(int maxBufferTime) {
        this.maxBufferTime = maxBufferTime;
    }

    public void setHWEnable(boolean hwEnable) {
        this.hwEnable = hwEnable;
    }

    public void setAutoReconnectWaitTimeout(int autoReconnectWaitTimeout) {
        this.autoReconnectWaitTimeout = autoReconnectWaitTimeout;
    }

    public void setConnectWaitTimeout(int connectWaitTimeout) {
        this.connectWaitTimeout = connectWaitTimeout;
    }

    public void setCryptoKey(String cryptoKey) {
        this.cryptoKey = cryptoKey;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setAudioEnable(boolean audioEnable) {
        this.audioEnable = audioEnable;
        this.jniSetAudioEnable(audioEnable);
    }

    public void setVideoEnable(boolean videoEnable) {
        this.videoEnable = videoEnable;
        this.jniSetVideoEnable(videoEnable);
    }

    public void setSubscribe(boolean subscribe) {
        this.subscribe = subscribe;
    }

    public void setPlayerView(@NonNull NodePlayerView npv) {
        this.mNodePlayerView = npv;
        this.jniSetVideoEnable(true);
        npv.setRenderCallback(this);
    }

    public void setNodePlayerDelegate(@NonNull NodePlayerDelegate delegate) {
        this.mNodePlayerDelegate = delegate;
    }

    private void onEvent(int event, String eventMsg) {
        if (this.mNodePlayerDelegate != null) {
            this.mNodePlayerDelegate.onEventCallback(this, event, eventMsg);
        }
        if (event == 1104 && this.mNodePlayerView != null) {
            this.mNodePlayerView.setVideoSize(Integer.valueOf(eventMsg.split("x")[0]), Integer.valueOf(eventMsg.split("x")[1]));
        }
    }

    private native long jniInit(Object var1, String var2);

    private native void jniDeInit();

    private native int jniSetSurface(Object var1);

    private native int jniSetSurfaceChange();

    private native int jniSetAudioEnable(boolean var1);

    private native int jniSetVideoEnable(boolean var1);

    public native int setVolume(float var1);

    public native int start();

    public native int stop();

    public native int pause();

    public native int seekTo(long var1);

    public native long getDuration();

    public native long getCurrentPosition();

    public native long getBufferPosition();

    public native int getBufferPercentage();

    public native boolean isPlaying();

    public native boolean isLive();

    @Override
    public void onSurfaceCreated(@NonNull Surface surface) {
        this.jniSetSurface(surface);
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        this.jniSetSurfaceChange();
    }

    @Override
    public void onSurfaceDestroyed() {
        this.jniSetSurface(null);
    }

    static {
        System.loadLibrary("NodeMediaClient");
        sAudioFocusChangeListener = null;
        players = new ArrayList<NodePlayer>(0);
    }
}

