/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtil {
    private static Pattern SPECIAL_CHAR_WHITESPACE = Pattern.compile("(\t| +|&[a-z]*;|&#x?([a-f]|[A-F]|[0-9])*;|\n)");
    private static Pattern SPECIAL_CHAR_NO_WHITESPACE = Pattern.compile("(&[a-z]*;|&#x?([a-f]|[A-F]|[0-9])*;)");
    private static Map<String, String> REPLACEMENTS = new HashMap<String, String>();

    public static String replaceHtmlEntities(String aText, boolean preserveFormatting) {
        Matcher matcher;
        StringBuffer result = new StringBuffer();
        HashMap<String, String> replacements = new HashMap<String, String>(REPLACEMENTS);
        if (preserveFormatting) {
            matcher = SPECIAL_CHAR_NO_WHITESPACE.matcher(aText);
        } else {
            matcher = SPECIAL_CHAR_WHITESPACE.matcher(aText);
            replacements.put("", " ");
            replacements.put("\n", " ");
        }
        while (matcher.find()) {
            matcher.appendReplacement(result, TextUtil.getReplacement(matcher, replacements));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String getReplacement(Matcher aMatcher, Map<String, String> replacements) {
        String match = aMatcher.group(0).trim();
        String result = replacements.get(match);
        if (result != null) {
            return result;
        }
        if (match.startsWith("&#")) {
            try {
                Integer code = match.startsWith("&#x") ? Integer.decode("0x" + match.substring(3, match.length() - 1)) : Integer.valueOf(Integer.parseInt(match.substring(2, match.length() - 1)));
                return "" + (char)code.intValue();
            }
            catch (NumberFormatException nfe) {
                return "";
            }
        }
        return "";
    }

    static {
        REPLACEMENTS.put("&nbsp;", "\u00a0");
        REPLACEMENTS.put("&amp;", "&");
        REPLACEMENTS.put("&quot;", "\"");
        REPLACEMENTS.put("&cent;", "\u00a2");
        REPLACEMENTS.put("&lt;", "<");
        REPLACEMENTS.put("&gt;", ">");
        REPLACEMENTS.put("&sect;", "\u00a7");
    }
}

