/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.types;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.netflix.iceberg.types.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Types {
    private static final ImmutableMap<String, Type.PrimitiveType> TYPES = ImmutableMap.builder().put((Object)BooleanType.get().toString(), (Object)BooleanType.get()).put((Object)IntegerType.get().toString(), (Object)IntegerType.get()).put((Object)LongType.get().toString(), (Object)LongType.get()).put((Object)FloatType.get().toString(), (Object)FloatType.get()).put((Object)DoubleType.get().toString(), (Object)DoubleType.get()).put((Object)DateType.get().toString(), (Object)DateType.get()).put((Object)TimeType.get().toString(), (Object)TimeType.get()).put((Object)TimestampType.withZone().toString(), (Object)TimestampType.withZone()).put((Object)TimestampType.withoutZone().toString(), (Object)TimestampType.withoutZone()).put((Object)StringType.get().toString(), (Object)StringType.get()).put((Object)UUIDType.get().toString(), (Object)UUIDType.get()).put((Object)BinaryType.get().toString(), (Object)BinaryType.get()).build();
    private static final Pattern FIXED = Pattern.compile("fixed\\[(\\d+)\\]");
    private static final Pattern DECIMAL = Pattern.compile("decimal\\((\\d+),\\s+(\\d+)\\)");

    public static Type.PrimitiveType fromPrimitiveString(String typeString) {
        String lowerTypeString = typeString.toLowerCase(Locale.ROOT);
        if (TYPES.containsKey((Object)lowerTypeString)) {
            return (Type.PrimitiveType)TYPES.get((Object)lowerTypeString);
        }
        Matcher fixed = FIXED.matcher(lowerTypeString);
        if (fixed.matches()) {
            return FixedType.ofLength(Integer.parseInt(fixed.group(1)));
        }
        Matcher decimal = DECIMAL.matcher(lowerTypeString);
        if (decimal.matches()) {
            return DecimalType.of(Integer.parseInt(decimal.group(1)), Integer.parseInt(decimal.group(2)));
        }
        throw new IllegalArgumentException("Cannot parse type string to primitive: " + typeString);
    }

    public static class MapType
    extends Type.NestedType {
        private final NestedField keyField;
        private final NestedField valueField;
        private transient List<NestedField> fields = null;

        public static MapType ofOptional(int keyId, int valueId, Type keyType, Type valueType) {
            Preconditions.checkNotNull((Object)valueType, (Object)"Value type cannot be null");
            return new MapType(NestedField.required(keyId, "key", keyType), NestedField.optional(valueId, "value", valueType));
        }

        public static MapType ofRequired(int keyId, int valueId, Type keyType, Type valueType) {
            Preconditions.checkNotNull((Object)valueType, (Object)"Value type cannot be null");
            return new MapType(NestedField.required(keyId, "key", keyType), NestedField.required(valueId, "value", valueType));
        }

        private MapType(NestedField keyField, NestedField valueField) {
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Type keyType() {
            return this.keyField.type();
        }

        public Type valueType() {
            return this.valueField.type();
        }

        @Override
        public Type fieldType(String name) {
            if ("key".equals(name)) {
                return this.keyField.type();
            }
            if ("value".equals(name)) {
                return this.valueField.type();
            }
            return null;
        }

        @Override
        public NestedField field(int id) {
            if (this.keyField.fieldId() == id) {
                return this.keyField;
            }
            if (this.valueField.fieldId() == id) {
                return this.valueField;
            }
            return null;
        }

        @Override
        public List<NestedField> fields() {
            return this.lazyFieldList();
        }

        public int keyId() {
            return this.keyField.fieldId();
        }

        public int valueId() {
            return this.valueField.fieldId();
        }

        public boolean isValueRequired() {
            return !this.valueField.isOptional;
        }

        public boolean isValueOptional() {
            return this.valueField.isOptional;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.MAP;
        }

        @Override
        public boolean isMapType() {
            return true;
        }

        @Override
        public MapType asMapType() {
            return this;
        }

        public String toString() {
            return String.format("map<%s, %s>", this.keyField.type(), this.valueField.type());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapType mapType = (MapType)o;
            if (!this.keyField.equals(mapType.keyField)) {
                return false;
            }
            return this.valueField.equals(mapType.valueField);
        }

        public int hashCode() {
            return Objects.hash(MapType.class, this.keyField, this.valueField);
        }

        private List<NestedField> lazyFieldList() {
            if (this.fields == null) {
                this.fields = ImmutableList.of((Object)this.keyField, (Object)this.valueField);
            }
            return this.fields;
        }
    }

    public static class ListType
    extends Type.NestedType {
        private final NestedField elementField;
        private transient List<NestedField> fields = null;

        public static ListType ofOptional(int elementId, Type elementType) {
            Preconditions.checkNotNull((Object)elementType, (Object)"Element type cannot be null");
            return new ListType(NestedField.optional(elementId, "element", elementType));
        }

        public static ListType ofRequired(int elementId, Type elementType) {
            Preconditions.checkNotNull((Object)elementType, (Object)"Element type cannot be null");
            return new ListType(NestedField.required(elementId, "element", elementType));
        }

        private ListType(NestedField elementField) {
            this.elementField = elementField;
        }

        public Type elementType() {
            return this.elementField.type();
        }

        @Override
        public Type fieldType(String name) {
            if ("element".equals(name)) {
                return this.elementType();
            }
            return null;
        }

        @Override
        public NestedField field(int id) {
            if (this.elementField.fieldId() == id) {
                return this.elementField;
            }
            return null;
        }

        @Override
        public List<NestedField> fields() {
            return this.lazyFieldList();
        }

        public int elementId() {
            return this.elementField.fieldId();
        }

        public boolean isElementRequired() {
            return !this.elementField.isOptional;
        }

        public boolean isElementOptional() {
            return this.elementField.isOptional;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.LIST;
        }

        @Override
        public boolean isListType() {
            return true;
        }

        @Override
        public ListType asListType() {
            return this;
        }

        public String toString() {
            return String.format("list<%s>", this.elementField.type());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListType listType = (ListType)o;
            return this.elementField.equals(listType.elementField);
        }

        public int hashCode() {
            return Objects.hash(ListType.class, this.elementField);
        }

        private List<NestedField> lazyFieldList() {
            if (this.fields == null) {
                this.fields = ImmutableList.of((Object)this.elementField);
            }
            return this.fields;
        }
    }

    public static class StructType
    extends Type.NestedType {
        private static final Joiner FIELD_SEP = Joiner.on((String)", ");
        private final NestedField[] fields;
        private transient List<NestedField> fieldList = null;
        private transient Map<String, NestedField> fieldsByName = null;
        private transient Map<String, NestedField> fieldsByLowerCaseName = null;
        private transient Map<Integer, NestedField> fieldsById = null;

        public static StructType of(NestedField ... fields) {
            return StructType.of(Arrays.asList(fields));
        }

        public static StructType of(List<NestedField> fields) {
            return new StructType(fields);
        }

        private StructType(List<NestedField> fields) {
            Preconditions.checkNotNull(fields, (Object)"Field list cannot be null");
            this.fields = new NestedField[fields.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = fields.get(i);
            }
        }

        @Override
        public List<NestedField> fields() {
            return this.lazyFieldList();
        }

        public NestedField field(String name) {
            return this.lazyFieldsByName().get(name);
        }

        public NestedField caseInsensitiveField(String name) {
            return this.lazyFieldsByLowerCaseName().get(name.toLowerCase(Locale.ROOT));
        }

        @Override
        public Type fieldType(String name) {
            NestedField field = this.field(name);
            if (field != null) {
                return field.type();
            }
            return null;
        }

        @Override
        public NestedField field(int id) {
            return this.lazyFieldsById().get(id);
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.STRUCT;
        }

        @Override
        public boolean isStructType() {
            return true;
        }

        @Override
        public StructType asStructType() {
            return this;
        }

        public String toString() {
            return String.format("struct<%s>", FIELD_SEP.join((Object[])this.fields));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructType that = (StructType)o;
            return Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Objects.hash(NestedField.class, Arrays.hashCode(this.fields));
        }

        private List<NestedField> lazyFieldList() {
            if (this.fieldList == null) {
                this.fieldList = ImmutableList.copyOf((Object[])this.fields);
            }
            return this.fieldList;
        }

        private Map<String, NestedField> lazyFieldsByName() {
            if (this.fieldsByName == null) {
                this.indexFields();
            }
            return this.fieldsByName;
        }

        private Map<String, NestedField> lazyFieldsByLowerCaseName() {
            if (this.fieldsByLowerCaseName == null) {
                this.indexFields();
            }
            return this.fieldsByLowerCaseName;
        }

        private Map<Integer, NestedField> lazyFieldsById() {
            if (this.fieldsById == null) {
                this.indexFields();
            }
            return this.fieldsById;
        }

        private void indexFields() {
            ImmutableMap.Builder byNameBuilder = ImmutableMap.builder();
            ImmutableMap.Builder byLowerCaseNameBuilder = ImmutableMap.builder();
            ImmutableMap.Builder byIdBuilder = ImmutableMap.builder();
            for (NestedField field : this.fields) {
                byNameBuilder.put((Object)field.name(), (Object)field);
                byLowerCaseNameBuilder.put((Object)field.name().toLowerCase(Locale.ROOT), (Object)field);
                byIdBuilder.put((Object)field.fieldId(), (Object)field);
            }
            this.fieldsByName = byNameBuilder.build();
            this.fieldsByLowerCaseName = byLowerCaseNameBuilder.build();
            this.fieldsById = byIdBuilder.build();
        }
    }

    public static class NestedField
    implements Serializable {
        private final boolean isOptional;
        private final int id;
        private final String name;
        private final Type type;
        private final String doc;

        public static NestedField optional(int id, String name, Type type) {
            return new NestedField(true, id, name, type, null);
        }

        public static NestedField optional(int id, String name, Type type, String doc) {
            return new NestedField(true, id, name, type, doc);
        }

        public static NestedField required(int id, String name, Type type) {
            return new NestedField(false, id, name, type, null);
        }

        public static NestedField required(int id, String name, Type type, String doc) {
            return new NestedField(false, id, name, type, doc);
        }

        private NestedField(boolean isOptional, int id, String name, Type type, String doc) {
            Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
            Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
            this.isOptional = isOptional;
            this.id = id;
            this.name = name;
            this.type = type;
            this.doc = doc;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public boolean isRequired() {
            return !this.isOptional;
        }

        public int fieldId() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.type;
        }

        public String doc() {
            return this.doc;
        }

        public String toString() {
            return String.format("%d: %s: %s %s", this.id, this.name, this.isOptional ? "optional" : "required", this.type) + (this.doc != null ? " (" + this.doc + ")" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedField that = (NestedField)o;
            if (this.isOptional != that.isOptional) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!Objects.equals(this.doc, that.doc)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(NestedField.class, this.id, this.isOptional, this.name, this.type);
        }
    }

    public static class DecimalType
    extends Type.PrimitiveType {
        private final int scale;
        private final int precision;

        public static DecimalType of(int precision, int scale) {
            return new DecimalType(precision, scale);
        }

        private DecimalType(int precision, int scale) {
            Preconditions.checkArgument((precision <= 38 ? 1 : 0) != 0, (String)"Decimals with precision larger than 38 are not supported: %s", (Object[])new Object[]{precision});
            this.scale = scale;
            this.precision = precision;
        }

        public int scale() {
            return this.scale;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DECIMAL;
        }

        public String toString() {
            return String.format("decimal(%d, %d)", this.precision, this.scale);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecimalType that = (DecimalType)o;
            if (this.scale != that.scale) {
                return false;
            }
            return this.precision == that.precision;
        }

        public int hashCode() {
            return Objects.hash(DecimalType.class, this.scale, this.precision);
        }
    }

    public static class BinaryType
    extends Type.PrimitiveType {
        private static final BinaryType INSTANCE = new BinaryType();

        public static BinaryType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.BINARY;
        }

        public String toString() {
            return "binary";
        }
    }

    public static class FixedType
    extends Type.PrimitiveType {
        private final int length;

        public static FixedType ofLength(int length) {
            return new FixedType(length);
        }

        private FixedType(int length) {
            this.length = length;
        }

        public int length() {
            return this.length;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.FIXED;
        }

        public String toString() {
            return String.format("fixed[%d]", this.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedType fixedType = (FixedType)o;
            return this.length == fixedType.length;
        }

        public int hashCode() {
            return Objects.hash(FixedType.class, this.length);
        }
    }

    public static class UUIDType
    extends Type.PrimitiveType {
        private static final UUIDType INSTANCE = new UUIDType();

        public static UUIDType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.UUID;
        }

        public String toString() {
            return "uuid";
        }
    }

    public static class StringType
    extends Type.PrimitiveType {
        private static final StringType INSTANCE = new StringType();

        public static StringType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.STRING;
        }

        public String toString() {
            return "string";
        }
    }

    public static class TimestampType
    extends Type.PrimitiveType {
        private static final TimestampType INSTANCE_WITH_ZONE = new TimestampType(true);
        private static final TimestampType INSTANCE_WITHOUT_ZONE = new TimestampType(false);
        private final boolean adjustToUTC;

        public static TimestampType withZone() {
            return INSTANCE_WITH_ZONE;
        }

        public static TimestampType withoutZone() {
            return INSTANCE_WITHOUT_ZONE;
        }

        private TimestampType(boolean adjustToUTC) {
            this.adjustToUTC = adjustToUTC;
        }

        public boolean shouldAdjustToUTC() {
            return this.adjustToUTC;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIMESTAMP;
        }

        public String toString() {
            if (this.shouldAdjustToUTC()) {
                return "timestamptz";
            }
            return "timestamp";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampType timestampType = (TimestampType)o;
            return this.adjustToUTC == timestampType.adjustToUTC;
        }

        public int hashCode() {
            return Objects.hash(TimestampType.class, this.adjustToUTC);
        }
    }

    public static class TimeType
    extends Type.PrimitiveType {
        private static final TimeType INSTANCE = new TimeType();

        public static TimeType get() {
            return INSTANCE;
        }

        private TimeType() {
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIME;
        }

        public String toString() {
            return "time";
        }
    }

    public static class DateType
    extends Type.PrimitiveType {
        private static final DateType INSTANCE = new DateType();

        public static DateType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DATE;
        }

        public String toString() {
            return "date";
        }
    }

    public static class DoubleType
    extends Type.PrimitiveType {
        private static final DoubleType INSTANCE = new DoubleType();

        public static DoubleType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DOUBLE;
        }

        public String toString() {
            return "double";
        }
    }

    public static class FloatType
    extends Type.PrimitiveType {
        private static final FloatType INSTANCE = new FloatType();

        public static FloatType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.FLOAT;
        }

        public String toString() {
            return "float";
        }
    }

    public static class LongType
    extends Type.PrimitiveType {
        private static final LongType INSTANCE = new LongType();

        public static LongType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.LONG;
        }

        public String toString() {
            return "long";
        }
    }

    public static class IntegerType
    extends Type.PrimitiveType {
        private static final IntegerType INSTANCE = new IntegerType();

        public static IntegerType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.INTEGER;
        }

        public String toString() {
            return "int";
        }
    }

    public static class BooleanType
    extends Type.PrimitiveType {
        private static final BooleanType INSTANCE = new BooleanType();

        public static BooleanType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.BOOLEAN;
        }

        public String toString() {
            return "boolean";
        }
    }
}

