/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.types;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.netflix.iceberg.Schema;
import com.netflix.iceberg.types.TypeUtil;
import com.netflix.iceberg.types.Types;
import java.util.List;
import java.util.Map;

public class IndexByName
extends TypeUtil.SchemaVisitor<Map<String, Integer>> {
    private static final Joiner DOT = Joiner.on((String)".");
    private final Map<String, Integer> nameToId = Maps.newHashMap();

    @Override
    public Map<String, Integer> schema(Schema schema, Map<String, Integer> structResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> struct(Types.StructType struct, List<Map<String, Integer>> fieldResults) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> field(Types.NestedField field, Map<String, Integer> fieldResult) {
        this.addField(field.name(), field.fieldId());
        return null;
    }

    @Override
    public Map<String, Integer> list(Types.ListType list, Map<String, Integer> elementResult) {
        for (Types.NestedField field : list.fields()) {
            this.addField(field.name(), field.fieldId());
        }
        return null;
    }

    @Override
    public Map<String, Integer> map(Types.MapType map, Map<String, Integer> keyResult, Map<String, Integer> valueResult) {
        for (Types.NestedField field : map.fields()) {
            this.addField(field.name(), field.fieldId());
        }
        return null;
    }

    private void addField(String name, int fieldId) {
        String fullName = name;
        if (!this.fieldNames.isEmpty()) {
            fullName = DOT.join((Object)DOT.join(this.fieldNames.descendingIterator()), (Object)name, new Object[0]);
        }
        this.nameToId.put(fullName, fieldId);
    }
}

