/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.google.common.base.Preconditions;
import com.netflix.iceberg.DataFile;
import com.netflix.iceberg.Schema;
import com.netflix.iceberg.expressions.Binder;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.Literal;
import com.netflix.iceberg.types.Conversions;
import com.netflix.iceberg.types.Types;
import java.nio.ByteBuffer;
import java.util.Map;

public class InclusiveMetricsEvaluator {
    private final Schema schema;
    private final Types.StructType struct;
    private final Expression expr;
    private transient ThreadLocal<MetricsEvalVisitor> visitors = null;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    private MetricsEvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new MetricsEvalVisitor());
        }
        return this.visitors.get();
    }

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound) {
        this.schema = schema;
        this.struct = schema.asStruct();
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(unbound), true);
    }

    public boolean eval(DataFile file) {
        return this.visitor().eval(file);
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(DataFile file) {
            if (file.recordCount() <= 0L) {
                return false;
            }
            this.valueCounts = file.valueCounts();
            this.nullCounts = file.nullValueCounts();
            this.lowerBounds = file.lowerBounds();
            this.upperBounds = file.upperBounds();
            return ExpressionVisitors.visit(InclusiveMetricsEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            Preconditions.checkNotNull((Object)InclusiveMetricsEvaluator.this.struct.field(id), (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.nullCounts != null && this.nullCounts.containsKey(id) && this.nullCounts.get(id) == 0L) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            Preconditions.checkNotNull((Object)InclusiveMetricsEvaluator.this.struct.field(id), (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.valueCounts != null && this.valueCounts.containsKey(id) && this.nullCounts != null && this.nullCounts.containsKey(id) && this.valueCounts.get(id) - this.nullCounts.get(id) == 0L) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = InclusiveMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull((Object)field, (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(field.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = InclusiveMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull((Object)field, (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(field.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = InclusiveMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull((Object)field, (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Types.NestedField field = InclusiveMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull((Object)field, (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            int cmp;
            Integer id = ref.fieldId();
            Types.NestedField field = InclusiveMetricsEvaluator.this.struct.field(id);
            Preconditions.checkNotNull((Object)field, (String)"Cannot filter by nested column: %s", (Object[])new Object[]{InclusiveMetricsEvaluator.this.schema.findField(id)});
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(InclusiveMetricsEvaluator.this.struct.field(id).type(), this.lowerBounds.get(id));
                cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(field.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }
    }
}

