/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg;

import com.netflix.iceberg.Schema;
import com.netflix.iceberg.types.Types;
import java.nio.ByteBuffer;
import java.util.List;

public interface ManifestFile {
    public static final Schema SCHEMA = new Schema(Types.NestedField.required(500, "manifest_path", Types.StringType.get()), Types.NestedField.required(501, "manifest_length", Types.LongType.get()), Types.NestedField.required(502, "partition_spec_id", Types.IntegerType.get()), Types.NestedField.optional(503, "added_snapshot_id", Types.LongType.get()), Types.NestedField.optional(504, "added_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(505, "existing_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(506, "deleted_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(507, "partitions", Types.ListType.ofRequired(508, Types.StructType.of(Types.NestedField.required(509, "contains_null", Types.BooleanType.get()), Types.NestedField.optional(510, "lower_bound", Types.BinaryType.get()), Types.NestedField.optional(511, "upper_bound", Types.BinaryType.get())))));

    public static Schema schema() {
        return SCHEMA;
    }

    public String path();

    public long length();

    public int partitionSpecId();

    public Long snapshotId();

    public Integer addedFilesCount();

    public Integer existingFilesCount();

    public Integer deletedFilesCount();

    public List<PartitionFieldSummary> partitions();

    public ManifestFile copy();

    public static interface PartitionFieldSummary {
        public static final Types.StructType TYPE = ManifestFile.schema().findType("partitions").asListType().elementType().asStructType();

        public static Types.StructType getType() {
            return TYPE;
        }

        public boolean containsNull();

        public ByteBuffer lowerBound();

        public ByteBuffer upperBound();

        public PartitionFieldSummary copy();
    }
}

