/*
 * Decompiled with CFR 0.152.
 */
package net.nashlegend.anypref;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import net.nashlegend.anypref.PrefUtil;
import net.nashlegend.anypref.SharedPrefs;

public class AnyPref {
    private static final String EXISTS_KEY = "key.i.am.here";
    private static Context mContext;

    public static void init(Context context) {
        mContext = context;
    }

    public static SharedPrefs getDefault() {
        return new SharedPrefs(mContext.getPackageName() + "_preferences", mContext);
    }

    public static SharedPrefs getPrefs(String key) {
        return new SharedPrefs(key, mContext);
    }

    public static SharedPrefs getPrefs(Class clazz) {
        return new SharedPrefs(PrefUtil.getKeyForClazz(clazz), mContext);
    }

    public static void clear(Class clazz) {
        if (clazz != null) {
            AnyPref.clear(clazz, PrefUtil.getKeyForClazz(clazz));
        }
    }

    public static void clear(Class clazz, String customKey) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)customKey)) {
            return;
        }
        for (Field field : PrefUtil.getFields(clazz)) {
            if (PrefUtil.isSubPref(field)) {
                AnyPref.clear(field.getType(), customKey + "$$$" + PrefUtil.getKeyForField(field));
                continue;
            }
            if (!PrefUtil.isArrayListPref(field)) continue;
            AnyPref.clearArrayList(field, customKey);
        }
        AnyPref.getPrefs(customKey).clear();
    }

    public static <T> T get(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return AnyPref.get(clazz, PrefUtil.getKeyForClazz(clazz));
    }

    public static <T> T get(Class<T> clazz, String customKey) {
        T obj;
        if (clazz == null || TextUtils.isEmpty((CharSequence)customKey)) {
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        SharedPreferences preferences = mContext.getSharedPreferences(customKey, 0);
        for (Field field : PrefUtil.getFields(clazz)) {
            AnyPref.get(preferences, field, obj, customKey);
        }
        return obj;
    }

    public static void put(Object object) {
        if (object == null) {
            return;
        }
        AnyPref.put(object, PrefUtil.getKeyForClazz(object.getClass()));
    }

    public static void put(Object object, String customKey) {
        if (object == null || TextUtils.isEmpty((CharSequence)customKey)) {
            return;
        }
        AnyPref.clear(object.getClass(), customKey);
        SharedPreferences.Editor editor = mContext.getSharedPreferences(customKey, 0).edit();
        for (Field field : PrefUtil.getFields(object.getClass())) {
            AnyPref.put(editor, field, object, customKey);
        }
        editor.apply();
    }

    private static void put(SharedPreferences.Editor editor, Field field, Object object, String prefKey) {
        String key = PrefUtil.getKeyForField(field);
        String type = field.getType().getCanonicalName();
        try {
            switch (type) {
                case "int": {
                    editor.putInt(key, field.getInt(object));
                    break;
                }
                case "float": {
                    editor.putFloat(key, field.getFloat(object));
                    break;
                }
                case "long": {
                    editor.putLong(key, field.getLong(object));
                    break;
                }
                case "boolean": {
                    editor.putBoolean(key, field.getBoolean(object));
                    break;
                }
                case "java.lang.String": {
                    editor.putString(key, String.valueOf(field.get(object)));
                    break;
                }
                default: {
                    if (PrefUtil.isSubPref(field)) {
                        AnyPref.put(field.get(object), prefKey + "$$$" + key);
                        break;
                    }
                    if (PrefUtil.isArrayListPref(field)) {
                        Object arr = field.get(object);
                        if (arr != null && arr instanceof ArrayList) {
                            AnyPref.putArrayList(editor, (ArrayList)arr, field, prefKey);
                        }
                    } else if (PrefUtil.isFieldStringSet(field)) {
                        editor.putStringSet(key, (Set)field.get(object));
                    }
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void get(SharedPreferences preferences, Field field, Object object, String prefKey) {
        String cacheKey = PrefUtil.getCacheKeyForField(field);
        String key = PrefUtil.getKeyForField(field);
        String type = field.getType().getCanonicalName();
        try {
            switch (type) {
                case "int": {
                    field.setInt(object, preferences.getInt(key, (int)PrefUtil.getDefaultNumber(cacheKey)));
                    break;
                }
                case "float": {
                    field.setFloat(object, preferences.getFloat(key, (float)PrefUtil.getDefaultNumber(cacheKey)));
                    break;
                }
                case "long": {
                    field.setLong(object, preferences.getLong(key, (long)PrefUtil.getDefaultNumber(cacheKey)));
                    break;
                }
                case "boolean": {
                    field.setBoolean(object, preferences.getBoolean(key, PrefUtil.getDefaultBoolean(cacheKey)));
                    break;
                }
                case "java.lang.String": {
                    field.set(object, preferences.getString(key, PrefUtil.getDefaultString(cacheKey)));
                    break;
                }
                default: {
                    if (PrefUtil.isSubPref(field)) {
                        field.set(object, AnyPref.get(field.getType(), prefKey + "$$$" + key));
                        break;
                    }
                    if (PrefUtil.isArrayListPref(field)) {
                        field.set(object, AnyPref.getArrayList(preferences, field, prefKey));
                        break;
                    }
                    if (PrefUtil.isFieldStringSet(field)) {
                        field.set(object, preferences.getStringSet(key, PrefUtil.getDefaultStringSet(cacheKey)));
                    }
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static ArrayList getArrayList(SharedPreferences preferences, Field field, String prefKey) {
        int length = preferences.getInt(PrefUtil.getArrayListLengthKey(field, prefKey), 0);
        ArrayList<String> keyList = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            keyList.add(PrefUtil.getArrayListItemKey(field, prefKey, i));
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < keyList.size(); ++i) {
            arrayList.add(AnyPref.get(PrefUtil.getArrayListType(field), (String)keyList.get(i)));
        }
        return arrayList;
    }

    private static void putArrayList(SharedPreferences.Editor editor, ArrayList arrayList, Field field, String prefKey) {
        for (int i = 0; i < arrayList.size(); ++i) {
            AnyPref.put(arrayList.get(i), PrefUtil.getArrayListItemKey(field, prefKey, i));
        }
        editor.putInt(PrefUtil.getArrayListLengthKey(field, prefKey), arrayList.size());
    }

    private static void clearArrayList(Field field, String prefKey) {
        ArrayList<String> keys = PrefUtil.getArrayListKeys(field, prefKey);
        for (int i = 0; i < keys.size(); ++i) {
            AnyPref.clear(PrefUtil.getArrayListType(field), keys.get(i));
        }
    }
}

