/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.client.StompMessage;

abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private static final String TAG = AbstractConnectionProvider.class.getSimpleName();
    private transient Disposable clientSendHeartBeatTask;
    private transient Disposable serverCheckHeartBeatTask;
    private Scheduler scheduler;
    private int serverHeartbeat = 0;
    private int clientHeartbeat = 0;
    private transient long lastServerHeartBeat = 0L;
    @NonNull
    private final PublishSubject<LifecycleEvent> mLifecycleStream = PublishSubject.create();
    @NonNull
    private final PublishSubject<String> mMessagesStream = PublishSubject.create();

    AbstractConnectionProvider() {
    }

    @Override
    @NonNull
    public Observable<String> messages() {
        return this.mMessagesStream.startWith((ObservableSource)this.initSocket().toObservable());
    }

    abstract void rawDisconnect();

    @Override
    public Completable disconnect() {
        if (this.clientSendHeartBeatTask != null) {
            this.clientSendHeartBeatTask.dispose();
        }
        if (this.serverCheckHeartBeatTask != null) {
            this.serverCheckHeartBeatTask.dispose();
        }
        this.lastServerHeartBeat = 0L;
        return Completable.fromAction(this::rawDisconnect);
    }

    private Completable initSocket() {
        return Completable.fromAction(this::createWebSocketConnection);
    }

    abstract void createWebSocketConnection();

    @Override
    @NonNull
    public Completable send(String stompMessage) {
        return Completable.fromCallable(() -> {
            if (this.getSocket() == null) {
                throw new IllegalStateException("Not connected yet");
            }
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.rawSend(stompMessage);
            return null;
        });
    }

    abstract void rawSend(String var1);

    @Nullable
    abstract Object getSocket();

    void emitLifecycleEvent(@NonNull LifecycleEvent lifecycleEvent) {
        Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
        this.mLifecycleStream.onNext((Object)lifecycleEvent);
    }

    void emitMessage(String stompMessage) {
        StompMessage sm = StompMessage.from(stompMessage);
        if ("CONNECTED".equals(sm.getStompCommand())) {
            Log.d((String)TAG, (String)"<<< CONNECTED");
            this.heartBeatHandshake(sm.findHeader("heart-beat"));
        } else if ("SEND".equals(sm.getStompCommand())) {
            this.abortClientHeartBeatSend();
        } else if ("MESSAGE".equals(sm.getStompCommand())) {
            this.abortServerHeartBeatCheck();
        }
        if (stompMessage.equals("\n")) {
            Log.d((String)TAG, (String)"<<< PONG");
            this.abortServerHeartBeatCheck();
        } else {
            Log.d((String)TAG, (String)("Receive STOMP message: " + stompMessage));
            this.mMessagesStream.onNext((Object)stompMessage);
        }
    }

    @Override
    @NonNull
    public Observable<LifecycleEvent> lifecycle() {
        return this.mLifecycleStream;
    }

    private void heartBeatHandshake(String heartBeatHeader) {
        if (heartBeatHeader != null) {
            String[] heartbeats = heartBeatHeader.split(",");
            if (this.clientHeartbeat > 0) {
                this.clientHeartbeat = Math.max(this.clientHeartbeat, Integer.parseInt(heartbeats[1]));
            }
            if (this.serverHeartbeat > 0) {
                this.serverHeartbeat = Math.max(this.serverHeartbeat, Integer.parseInt(heartbeats[0]));
            }
        }
        if (this.clientHeartbeat > 0 || this.serverHeartbeat > 0) {
            this.scheduler = Schedulers.io();
            if (this.clientHeartbeat > 0) {
                Log.d((String)TAG, (String)("Client will send heart-beat every " + this.clientHeartbeat + " ms"));
                this.scheduleClientHeartBeat();
            }
            if (this.serverHeartbeat > 0) {
                Log.d((String)TAG, (String)("Client will listen to server heart-beat every " + this.serverHeartbeat + " ms"));
                this.scheduleServerHeartBeatCheck();
                this.lastServerHeartBeat = System.currentTimeMillis();
            }
        }
    }

    protected void scheduleServerHeartBeatCheck() {
        if (this.serverHeartbeat > 0 && this.scheduler != null) {
            long now = System.currentTimeMillis();
            Log.d((String)TAG, (String)("Scheduling server heart-beat to be checked in " + this.serverHeartbeat + " ms and now is '" + now + "'"));
            this.serverCheckHeartBeatTask = this.scheduler.scheduleDirect(() -> this.checkServerHeartBeat(), (long)this.serverHeartbeat, TimeUnit.MILLISECONDS);
        }
    }

    private void checkServerHeartBeat() {
        if (this.serverHeartbeat > 0) {
            long now = System.currentTimeMillis();
            long boundary = now - (long)(3 * this.serverHeartbeat);
            if (this.lastServerHeartBeat < boundary) {
                Log.d((String)TAG, (String)("It's a sad day ;( Server didn't send heart-beat on time. Last received at '" + this.lastServerHeartBeat + "' and now is '" + now + "'"));
                LifecycleEvent failedServerHeartBeat = new LifecycleEvent(LifecycleEvent.Type.FAILED_SERVER_HEARTBEAT);
                this.emitLifecycleEvent(failedServerHeartBeat);
            } else {
                Log.d((String)TAG, (String)"We were checking and server sent heart-beat on time. So well-behaved :)");
                this.lastServerHeartBeat = System.currentTimeMillis();
            }
        }
    }

    private void abortServerHeartBeatCheck() {
        this.lastServerHeartBeat = System.currentTimeMillis();
        Log.d((String)TAG, (String)("Aborted last check because server sent heart-beat on time ('" + this.lastServerHeartBeat + "'). So well-behaved :)"));
        if (this.serverCheckHeartBeatTask != null) {
            this.serverCheckHeartBeatTask.dispose();
        }
        this.scheduleServerHeartBeatCheck();
    }

    public void scheduleClientHeartBeat() {
        if (this.clientHeartbeat > 0 && this.scheduler != null) {
            Log.d((String)TAG, (String)("Scheduling client heart-beat to be sent in " + this.clientHeartbeat + " ms"));
            this.clientSendHeartBeatTask = this.scheduler.scheduleDirect(() -> this.sendClientHeartBeat(), (long)this.clientHeartbeat, TimeUnit.MILLISECONDS);
        }
    }

    private void sendClientHeartBeat() {
        this.rawSend("\r\n");
        Log.d((String)TAG, (String)"PING >>>");
        this.scheduleClientHeartBeat();
    }

    private void abortClientHeartBeatSend() {
        if (this.clientSendHeartBeatTask != null) {
            this.clientSendHeartBeatTask.dispose();
        }
        this.scheduleClientHeartBeat();
    }

    @Override
    public void setServerHeartbeat(int ms) {
        this.serverHeartbeat = ms;
    }

    @Override
    public void setClientHeartbeat(int ms) {
        this.clientHeartbeat = ms;
    }
}

