/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.provider;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.subjects.PublishSubject;
import ua.naiksoftware.stomp.dto.LifecycleEvent;
import ua.naiksoftware.stomp.provider.ConnectionProvider;

public abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private static final String TAG = AbstractConnectionProvider.class.getSimpleName();
    @NonNull
    private final PublishSubject<LifecycleEvent> lifecycleStream = PublishSubject.create();
    @NonNull
    private final PublishSubject<String> messagesStream = PublishSubject.create();

    @Override
    @NonNull
    public Observable<String> messages() {
        return this.messagesStream.startWith((ObservableSource)this.initSocket().toObservable());
    }

    protected abstract void rawDisconnect();

    @Override
    public Completable disconnect() {
        return Completable.fromAction(this::rawDisconnect);
    }

    private Completable initSocket() {
        return Completable.fromAction(this::createWebSocketConnection);
    }

    protected abstract void createWebSocketConnection();

    @Override
    @NonNull
    public Completable send(String stompMessage) {
        return Completable.fromCallable(() -> {
            if (this.getSocket() == null) {
                throw new IllegalStateException("Not connected");
            }
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.rawSend(stompMessage);
            return null;
        });
    }

    protected abstract void rawSend(String var1);

    @Nullable
    protected abstract Object getSocket();

    protected void emitLifecycleEvent(@NonNull LifecycleEvent lifecycleEvent) {
        Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
        this.lifecycleStream.onNext((Object)lifecycleEvent);
    }

    protected void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Receive STOMP message: " + stompMessage));
        this.messagesStream.onNext((Object)stompMessage);
    }

    @Override
    @NonNull
    public Observable<LifecycleEvent> lifecycle() {
        return this.lifecycleStream;
    }
}

