/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import ua.naiksoftware.stomp.HeartBeatTask;
import ua.naiksoftware.stomp.dto.LifecycleEvent;
import ua.naiksoftware.stomp.dto.StompHeader;
import ua.naiksoftware.stomp.dto.StompMessage;
import ua.naiksoftware.stomp.pathmatcher.PathMatcher;
import ua.naiksoftware.stomp.pathmatcher.SimplePathMatcher;
import ua.naiksoftware.stomp.provider.ConnectionProvider;

public class StompClient {
    private static final String TAG = StompClient.class.getSimpleName();
    public static final String SUPPORTED_VERSIONS = "1.1,1.2";
    public static final String DEFAULT_ACK = "auto";
    private final ConnectionProvider connectionProvider;
    private ConcurrentHashMap<String, String> topics;
    private boolean legacyWhitespace;
    private PublishSubject<StompMessage> messageStream;
    private BehaviorSubject<Boolean> connectionStream;
    private ConcurrentHashMap<String, Flowable<StompMessage>> streamMap;
    private PathMatcher pathMatcher;
    private Disposable lifecycleDisposable;
    private Disposable messagesDisposable;
    private PublishSubject<LifecycleEvent> lifecyclePublishSubject;
    private List<StompHeader> headers;
    private HeartBeatTask heartBeatTask;

    public StompClient(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.streamMap = new ConcurrentHashMap();
        this.lifecyclePublishSubject = PublishSubject.create();
        this.pathMatcher = new SimplePathMatcher();
        this.heartBeatTask = new HeartBeatTask(this::sendHeartBeat, () -> this.lifecyclePublishSubject.onNext((Object)new LifecycleEvent(LifecycleEvent.Type.FAILED_SERVER_HEARTBEAT)));
    }

    public StompClient withServerHeartbeat(int ms) {
        this.heartBeatTask.setServerHeartbeat(ms);
        return this;
    }

    public StompClient withClientHeartbeat(int ms) {
        this.heartBeatTask.setClientHeartbeat(ms);
        return this;
    }

    public void connect() {
        this.connect(null);
    }

    public void connect(@Nullable List<StompHeader> _headers) {
        Log.d((String)TAG, (String)"Connect");
        this.headers = _headers;
        if (this.isConnected()) {
            Log.d((String)TAG, (String)"Already connected, ignore");
            return;
        }
        this.lifecycleDisposable = this.connectionProvider.lifecycle().subscribe(lifecycleEvent -> {
            switch (lifecycleEvent.getType()) {
                case OPENED: {
                    ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
                    headers.add(new StompHeader("accept-version", SUPPORTED_VERSIONS));
                    headers.add(new StompHeader("heart-beat", this.heartBeatTask.getClientHeartbeat() + "," + this.heartBeatTask.getServerHeartbeat()));
                    if (_headers != null) {
                        headers.addAll(_headers);
                    }
                    this.connectionProvider.send(new StompMessage("CONNECT", headers, null).compile(this.legacyWhitespace)).subscribe(() -> {
                        Log.d((String)TAG, (String)"Publish open");
                        this.lifecyclePublishSubject.onNext(lifecycleEvent);
                    });
                    break;
                }
                case CLOSED: {
                    Log.d((String)TAG, (String)"Socket closed");
                    this.disconnect();
                    break;
                }
                case ERROR: {
                    Log.d((String)TAG, (String)"Socket closed with error");
                    this.lifecyclePublishSubject.onNext(lifecycleEvent);
                }
            }
        });
        this.messagesDisposable = this.connectionProvider.messages().map(StompMessage::from).filter(this.heartBeatTask::consumeHeartBeat).doOnNext(arg_0 -> this.getMessageStream().onNext(arg_0)).filter(msg -> msg.getStompCommand().equals("CONNECTED")).subscribe(stompMessage -> this.getConnectionStream().onNext((Object)true), onError -> Log.e((String)TAG, (String)"Error parsing message", (Throwable)onError));
    }

    private synchronized BehaviorSubject<Boolean> getConnectionStream() {
        if (this.connectionStream == null || this.connectionStream.hasComplete()) {
            this.connectionStream = BehaviorSubject.createDefault((Object)false);
        }
        return this.connectionStream;
    }

    private synchronized PublishSubject<StompMessage> getMessageStream() {
        if (this.messageStream == null || this.messageStream.hasComplete()) {
            this.messageStream = PublishSubject.create();
        }
        return this.messageStream;
    }

    public Completable send(String destination) {
        return this.send(destination, null);
    }

    public Completable send(String destination, String data) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), data));
    }

    public Completable send(@NonNull StompMessage stompMessage) {
        Completable completable = this.connectionProvider.send(stompMessage.compile(this.legacyWhitespace));
        Completable connectionComplete = this.getConnectionStream().filter(isConnected -> isConnected).firstElement().ignoreElement();
        return completable.startWith((CompletableSource)connectionComplete);
    }

    @SuppressLint(value={"CheckResult"})
    private void sendHeartBeat(@NonNull String pingMessage) {
        Completable completable = this.connectionProvider.send(pingMessage);
        Completable connectionComplete = this.getConnectionStream().filter(isConnected -> isConnected).firstElement().ignoreElement();
        completable.startWith((CompletableSource)connectionComplete).onErrorComplete().subscribe();
    }

    public Flowable<LifecycleEvent> lifecycle() {
        return this.lifecyclePublishSubject.toFlowable(BackpressureStrategy.BUFFER);
    }

    @SuppressLint(value={"CheckResult"})
    public void reconnect() {
        this.disconnectCompletable().subscribe(() -> this.connect(this.headers), e -> Log.e((String)TAG, (String)"Disconnect error", (Throwable)e));
    }

    @SuppressLint(value={"CheckResult"})
    public void disconnect() {
        this.disconnectCompletable().subscribe(() -> {}, e -> Log.e((String)TAG, (String)"Disconnect error", (Throwable)e));
    }

    public Completable disconnectCompletable() {
        this.heartBeatTask.shutdown();
        if (this.lifecycleDisposable != null) {
            this.lifecycleDisposable.dispose();
        }
        if (this.messagesDisposable != null) {
            this.messagesDisposable.dispose();
        }
        return this.connectionProvider.disconnect().doFinally(() -> {
            Log.d((String)TAG, (String)"Stomp disconnected");
            this.getConnectionStream().onComplete();
            this.getMessageStream().onComplete();
            this.lifecyclePublishSubject.onNext((Object)new LifecycleEvent(LifecycleEvent.Type.CLOSED));
        });
    }

    public Flowable<StompMessage> topic(String destinationPath) {
        return this.topic(destinationPath, null);
    }

    public Flowable<StompMessage> topic(@NonNull String destPath, List<StompHeader> headerList) {
        if (destPath == null) {
            return Flowable.error((Throwable)new IllegalArgumentException("Topic path cannot be null"));
        }
        if (!this.streamMap.containsKey(destPath)) {
            this.streamMap.put(destPath, (Flowable<StompMessage>)Completable.defer(() -> this.subscribePath(destPath, headerList)).andThen((Publisher)this.getMessageStream().filter(msg -> this.pathMatcher.matches(destPath, (StompMessage)msg)).toFlowable(BackpressureStrategy.BUFFER).doFinally(() -> this.unsubscribePath(destPath).subscribe()).share()));
        }
        return this.streamMap.get(destPath);
    }

    private Completable subscribePath(String destinationPath, @Nullable List<StompHeader> headerList) {
        String topicId = UUID.randomUUID().toString();
        if (this.topics == null) {
            this.topics = new ConcurrentHashMap();
        }
        if (this.topics.containsKey(destinationPath)) {
            Log.d((String)TAG, (String)"Attempted to subscribe to already-subscribed path!");
            return Completable.complete();
        }
        this.topics.put(destinationPath, topicId);
        ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
        headers.add(new StompHeader("id", topicId));
        headers.add(new StompHeader("destination", destinationPath));
        headers.add(new StompHeader("ack", DEFAULT_ACK));
        if (headerList != null) {
            headers.addAll(headerList);
        }
        return this.send(new StompMessage("SUBSCRIBE", headers, null)).doOnError(throwable -> this.unsubscribePath(destinationPath).subscribe());
    }

    private Completable unsubscribePath(String dest) {
        this.streamMap.remove(dest);
        String topicId = this.topics.get(dest);
        if (topicId == null) {
            return Completable.complete();
        }
        this.topics.remove(dest);
        Log.d((String)TAG, (String)("Unsubscribe path: " + dest + " id: " + topicId));
        return this.send(new StompMessage("UNSUBSCRIBE", Collections.singletonList(new StompHeader("id", topicId)), null)).onErrorComplete();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public boolean isConnected() {
        return (Boolean)this.getConnectionStream().getValue();
    }

    public void setLegacyWhitespace(boolean legacyWhitespace) {
        this.legacyWhitespace = legacyWhitespace;
    }

    public String getTopicId(String dest) {
        return this.topics.get(dest);
    }
}

