/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Map;
import okhttp3.OkHttpClient;
import ua.naiksoftware.stomp.StompClient;
import ua.naiksoftware.stomp.provider.OkHttpConnectionProvider;
import ua.naiksoftware.stomp.provider.WebSocketsConnectionProvider;

public class Stomp {
    public static StompClient over(@NonNull ConnectionProvider connectionProvider, String uri) {
        return Stomp.over(connectionProvider, uri, null, null);
    }

    public static StompClient over(@NonNull ConnectionProvider connectionProvider, String uri, Map<String, String> connectHttpHeaders) {
        return Stomp.over(connectionProvider, uri, connectHttpHeaders, null);
    }

    public static StompClient over(@NonNull ConnectionProvider connectionProvider, String uri, @Nullable Map<String, String> connectHttpHeaders, @Nullable OkHttpClient okHttpClient) {
        if (connectionProvider == ConnectionProvider.JWS) {
            if (okHttpClient != null) {
                throw new IllegalArgumentException("You cannot pass an OkHttpClient when using JWS. Use null instead.");
            }
            return Stomp.createStompClient(new WebSocketsConnectionProvider(uri, connectHttpHeaders));
        }
        if (connectionProvider == ConnectionProvider.OKHTTP) {
            return Stomp.createStompClient(new OkHttpConnectionProvider(uri, connectHttpHeaders, okHttpClient == null ? new OkHttpClient() : okHttpClient));
        }
        throw new IllegalArgumentException("ConnectionProvider type not supported: " + connectionProvider.toString());
    }

    private static StompClient createStompClient(ua.naiksoftware.stomp.provider.ConnectionProvider connectionProvider) {
        return new StompClient(connectionProvider);
    }

    public static enum ConnectionProvider {
        OKHTTP,
        JWS;

    }
}

