/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import ua.naiksoftware.stomp.dto.StompMessage;

public class HeartBeatTask {
    private static final String TAG = HeartBeatTask.class.getSimpleName();
    private Scheduler scheduler;
    private int serverHeartbeat = 0;
    private int clientHeartbeat = 0;
    private int serverHeartbeatNew = 0;
    private int clientHeartbeatNew = 0;
    private transient long lastServerHeartBeat = 0L;
    private transient Disposable clientSendHeartBeatTask;
    private transient Disposable serverCheckHeartBeatTask;
    private FailedListener failedListener;
    private SendCallback sendCallback;

    public HeartBeatTask(SendCallback sendCallback, @Nullable FailedListener failedListener) {
        this.failedListener = failedListener;
        this.sendCallback = sendCallback;
    }

    public void setServerHeartbeat(int serverHeartbeat) {
        this.serverHeartbeatNew = serverHeartbeat;
    }

    public void setClientHeartbeat(int clientHeartbeat) {
        this.clientHeartbeatNew = clientHeartbeat;
    }

    public int getServerHeartbeat() {
        return this.serverHeartbeatNew;
    }

    public int getClientHeartbeat() {
        return this.clientHeartbeatNew;
    }

    public boolean consumeHeartBeat(StompMessage message) {
        switch (message.getStompCommand()) {
            case "CONNECTED": {
                this.heartBeatHandshake(message.findHeader("heart-beat"));
                break;
            }
            case "SEND": {
                this.abortClientHeartBeatSend();
                break;
            }
            case "MESSAGE": {
                this.abortServerHeartBeatCheck();
                break;
            }
            case "UNKNOWN": {
                if (!"\n".equals(message.getPayload())) break;
                Log.d((String)TAG, (String)"<<< PONG");
                this.abortServerHeartBeatCheck();
                return false;
            }
        }
        return true;
    }

    public void shutdown() {
        if (this.clientSendHeartBeatTask != null) {
            this.clientSendHeartBeatTask.dispose();
        }
        if (this.serverCheckHeartBeatTask != null) {
            this.serverCheckHeartBeatTask.dispose();
        }
        this.lastServerHeartBeat = 0L;
    }

    private void heartBeatHandshake(String heartBeatHeader) {
        if (heartBeatHeader != null) {
            String[] heartbeats = heartBeatHeader.split(",");
            if (this.clientHeartbeatNew > 0) {
                this.clientHeartbeat = Math.max(this.clientHeartbeatNew, Integer.parseInt(heartbeats[1]));
            }
            if (this.serverHeartbeatNew > 0) {
                this.serverHeartbeat = Math.max(this.serverHeartbeatNew, Integer.parseInt(heartbeats[0]));
            }
        }
        if (this.clientHeartbeat > 0 || this.serverHeartbeat > 0) {
            this.scheduler = Schedulers.io();
            if (this.clientHeartbeat > 0) {
                Log.d((String)TAG, (String)("Client will send heart-beat every " + this.clientHeartbeat + " ms"));
                this.scheduleClientHeartBeat();
            }
            if (this.serverHeartbeat > 0) {
                Log.d((String)TAG, (String)("Client will listen to server heart-beat every " + this.serverHeartbeat + " ms"));
                this.scheduleServerHeartBeatCheck();
                this.lastServerHeartBeat = System.currentTimeMillis();
            }
        }
    }

    private void scheduleServerHeartBeatCheck() {
        if (this.serverHeartbeat > 0 && this.scheduler != null) {
            long now = System.currentTimeMillis();
            Log.d((String)TAG, (String)("Scheduling server heart-beat to be checked in " + this.serverHeartbeat + " ms and now is '" + now + "'"));
            this.serverCheckHeartBeatTask = this.scheduler.scheduleDirect(() -> this.checkServerHeartBeat(), (long)this.serverHeartbeat, TimeUnit.MILLISECONDS);
        }
    }

    private void checkServerHeartBeat() {
        if (this.serverHeartbeat > 0) {
            long now = System.currentTimeMillis();
            long boundary = now - (long)(3 * this.serverHeartbeat);
            if (this.lastServerHeartBeat < boundary) {
                Log.d((String)TAG, (String)("It's a sad day ;( Server didn't send heart-beat on time. Last received at '" + this.lastServerHeartBeat + "' and now is '" + now + "'"));
                if (this.failedListener != null) {
                    this.failedListener.onServerHeartBeatFailed();
                }
            } else {
                Log.d((String)TAG, (String)"We were checking and server sent heart-beat on time. So well-behaved :)");
                this.lastServerHeartBeat = System.currentTimeMillis();
            }
        }
    }

    private void abortServerHeartBeatCheck() {
        this.lastServerHeartBeat = System.currentTimeMillis();
        Log.d((String)TAG, (String)("Aborted last check because server sent heart-beat on time ('" + this.lastServerHeartBeat + "'). So well-behaved :)"));
        if (this.serverCheckHeartBeatTask != null) {
            this.serverCheckHeartBeatTask.dispose();
        }
        this.scheduleServerHeartBeatCheck();
    }

    private void scheduleClientHeartBeat() {
        if (this.clientHeartbeat > 0 && this.scheduler != null) {
            Log.d((String)TAG, (String)("Scheduling client heart-beat to be sent in " + this.clientHeartbeat + " ms"));
            this.clientSendHeartBeatTask = this.scheduler.scheduleDirect(() -> this.sendClientHeartBeat(), (long)this.clientHeartbeat, TimeUnit.MILLISECONDS);
        }
    }

    private void sendClientHeartBeat() {
        this.sendCallback.sendClientHeartBeat("\r\n");
        Log.d((String)TAG, (String)"PING >>>");
        this.scheduleClientHeartBeat();
    }

    private void abortClientHeartBeatSend() {
        if (this.clientSendHeartBeatTask != null) {
            this.clientSendHeartBeatTask.dispose();
        }
        this.scheduleClientHeartBeat();
    }

    public static interface SendCallback {
        public void sendClientHeartBeat(String var1);
    }

    public static interface FailedListener {
        public void onServerHeartBeatFailed();
    }
}

