/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.provider;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import ua.naiksoftware.stomp.dto.LifecycleEvent;
import ua.naiksoftware.stomp.provider.AbstractConnectionProvider;

public class OkHttpConnectionProvider
extends AbstractConnectionProvider {
    public static final String TAG = "OkHttpConnProvider";
    private final String mUri;
    @NonNull
    private final Map<String, String> mConnectHttpHeaders;
    private final OkHttpClient mOkHttpClient;
    @Nullable
    private WebSocket openSocket;

    public OkHttpConnectionProvider(String uri, @Nullable Map<String, String> connectHttpHeaders, OkHttpClient okHttpClient) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
        this.mOkHttpClient = okHttpClient;
    }

    @Override
    public void rawDisconnect() {
        if (this.openSocket != null) {
            this.openSocket.close(1000, "");
        }
    }

    @Override
    void createWebSocketConnection() {
        Request.Builder requestBuilder = new Request.Builder().url(this.mUri);
        this.addConnectionHeadersToBuilder(requestBuilder, this.mConnectHttpHeaders);
        this.openSocket = this.mOkHttpClient.newWebSocket(requestBuilder.build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, @NonNull Response response) {
                LifecycleEvent openEvent = new LifecycleEvent(LifecycleEvent.Type.OPENED);
                TreeMap headersAsMap = OkHttpConnectionProvider.this.headersAsMap(response);
                openEvent.setHandshakeResponseHeaders(headersAsMap);
                OkHttpConnectionProvider.this.emitLifecycleEvent(openEvent);
            }

            public void onMessage(WebSocket webSocket, String text) {
                OkHttpConnectionProvider.this.emitMessage(text);
            }

            public void onMessage(WebSocket webSocket, @NonNull ByteString bytes) {
                OkHttpConnectionProvider.this.emitMessage(bytes.utf8());
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                OkHttpConnectionProvider.this.openSocket = null;
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, new Exception(t)));
                OkHttpConnectionProvider.this.openSocket = null;
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(code, reason);
            }
        });
    }

    @Override
    void rawSend(String stompMessage) {
        this.openSocket.send(stompMessage);
    }

    @Override
    @Nullable
    Object getSocket() {
        return this.openSocket;
    }

    @NonNull
    private TreeMap<String, String> headersAsMap(@NonNull Response response) {
        TreeMap<String, String> headersAsMap = new TreeMap<String, String>();
        Headers headers = response.headers();
        for (String key : headers.names()) {
            headersAsMap.put(key, headers.get(key));
        }
        return headersAsMap;
    }

    private void addConnectionHeadersToBuilder(@NonNull Request.Builder requestBuilder, @NonNull Map<String, String> mConnectHttpHeaders) {
        for (Map.Entry<String, String> headerEntry : mConnectHttpHeaders.entrySet()) {
            requestBuilder.addHeader(headerEntry.getKey(), headerEntry.getValue());
        }
    }
}

