/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ua.naiksoftware.stomp.dto.LifecycleEvent;
import ua.naiksoftware.stomp.dto.StompHeader;
import ua.naiksoftware.stomp.dto.StompMessage;
import ua.naiksoftware.stomp.pathmatcher.PathMatcher;
import ua.naiksoftware.stomp.pathmatcher.SimplePathMatcher;
import ua.naiksoftware.stomp.provider.ConnectionProvider;

public class StompClient {
    private static final String TAG = StompClient.class.getSimpleName();
    public static final String SUPPORTED_VERSIONS = "1.1,1.2";
    public static final String DEFAULT_ACK = "auto";
    private final String tag = StompClient.class.getSimpleName();
    private final ConnectionProvider mConnectionProvider;
    private ConcurrentHashMap<String, String> mTopics;
    private boolean mConnected;
    private boolean isConnecting;
    private boolean legacyWhitespace;
    private PublishSubject<StompMessage> mMessageStream;
    private ConcurrentHashMap<String, Flowable<StompMessage>> mStreamMap;
    private final BehaviorSubject<Boolean> mConnectionStream;
    private PathMatcher pathMatcher;
    private Disposable mLifecycleDisposable;
    private Disposable mMessagesDisposable;
    private List<StompHeader> mHeaders;
    private int serverHeartbeat = 0;
    private int clientHeartbeat = 0;

    public StompClient(ConnectionProvider connectionProvider) {
        this.mConnectionProvider = connectionProvider;
        this.mStreamMap = new ConcurrentHashMap();
        this.mConnectionStream = BehaviorSubject.createDefault((Object)false);
        this.pathMatcher = new SimplePathMatcher();
    }

    public StompClient withServerHeartbeat(int ms) {
        this.mConnectionProvider.setServerHeartbeat(ms);
        this.serverHeartbeat = ms;
        return this;
    }

    public StompClient withClientHeartbeat(int ms) {
        this.mConnectionProvider.setClientHeartbeat(ms);
        this.clientHeartbeat = ms;
        return this;
    }

    public void connect() {
        this.connect(null);
    }

    public void connect(@Nullable List<StompHeader> _headers) {
        Log.d((String)TAG, (String)"Connect");
        this.mHeaders = _headers;
        if (this.mConnected) {
            Log.d((String)TAG, (String)"Already connected, ignore");
            return;
        }
        this.mLifecycleDisposable = this.mConnectionProvider.lifecycle().subscribe(lifecycleEvent -> {
            switch (lifecycleEvent.getType()) {
                case OPENED: {
                    ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
                    headers.add(new StompHeader("accept-version", SUPPORTED_VERSIONS));
                    headers.add(new StompHeader("heart-beat", this.clientHeartbeat + "," + this.serverHeartbeat));
                    if (_headers != null) {
                        headers.addAll(_headers);
                    }
                    this.mConnectionProvider.send(new StompMessage("CONNECT", headers, null).compile(this.legacyWhitespace)).subscribe();
                    break;
                }
                case CLOSED: {
                    Log.d((String)TAG, (String)"Socket closed");
                    this.disconnect();
                    break;
                }
                case ERROR: {
                    Log.d((String)TAG, (String)"Socket closed with error");
                    break;
                }
                case FAILED_SERVER_HEARTBEAT: {
                    Log.d((String)TAG, (String)"Server failed to send heart-beat in time.");
                }
            }
        });
        this.isConnecting = true;
        this.mMessagesDisposable = this.mConnectionProvider.messages().map(StompMessage::from).doOnNext(arg_0 -> this.getMessageStream().onNext(arg_0)).filter(msg -> msg.getStompCommand().equals("CONNECTED")).subscribe(stompMessage -> {
            this.setConnected(true);
            this.isConnecting = false;
        });
    }

    private PublishSubject<StompMessage> getMessageStream() {
        if (this.mMessageStream == null || this.mMessageStream.hasComplete()) {
            this.mMessageStream = PublishSubject.create();
        }
        return this.mMessageStream;
    }

    private void setConnected(boolean connected) {
        this.mConnected = connected;
        this.mConnectionStream.onNext((Object)this.mConnected);
    }

    @SuppressLint(value={"CheckResult"})
    public void reconnect() {
        this.disconnectCompletable().subscribe(() -> this.connect(this.mHeaders), e -> Log.e((String)this.tag, (String)"Disconnect error", (Throwable)e));
    }

    public Completable send(String destination) {
        return this.send(destination, null);
    }

    public Completable send(String destination, String data) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), data));
    }

    public Completable send(@NonNull StompMessage stompMessage) {
        Completable completable = this.mConnectionProvider.send(stompMessage.compile(this.legacyWhitespace)).doOnError(t -> t.printStackTrace());
        Completable connectionComplete = this.mConnectionStream.filter(isConnected -> isConnected).firstOrError().ignoreElement();
        return completable.startWith((CompletableSource)connectionComplete);
    }

    public Flowable<LifecycleEvent> lifecycle() {
        return this.mConnectionProvider.lifecycle().toFlowable(BackpressureStrategy.BUFFER);
    }

    public void disconnect() {
        if (!this.mConnected) {
            Log.d((String)TAG, (String)"Skip disconnect, already not connected");
            return;
        }
        this.disconnectCompletable().subscribe(() -> {}, e -> Log.e((String)this.tag, (String)"Disconnect error", (Throwable)e));
    }

    public Completable disconnectCompletable() {
        return this.mConnectionProvider.disconnect().doOnComplete(() -> {
            this.setConnected(false);
            this.isConnecting = false;
            if (this.mLifecycleDisposable != null) {
                this.mLifecycleDisposable.dispose();
            }
            if (this.mMessagesDisposable != null) {
                this.mMessagesDisposable.dispose();
            }
            if (this.mMessageStream != null && !this.mMessageStream.hasComplete()) {
                this.mMessageStream.onComplete();
            }
        });
    }

    public Flowable<StompMessage> topic(String destinationPath) {
        return this.topic(destinationPath, null);
    }

    public Flowable<StompMessage> topic(@NonNull String destPath, List<StompHeader> headerList) {
        if (destPath == null) {
            return Flowable.error((Throwable)new IllegalArgumentException("Topic path cannot be null"));
        }
        if (!this.mStreamMap.containsKey(destPath)) {
            this.mStreamMap.put(destPath, (Flowable<StompMessage>)this.getMessageStream().filter(msg -> this.pathMatcher.matches(destPath, (StompMessage)msg)).toFlowable(BackpressureStrategy.BUFFER).doOnSubscribe(disposable -> this.subscribePath(destPath, headerList).subscribe()).doFinally(() -> this.unsubscribePath(destPath).subscribe()).share());
        }
        return this.mStreamMap.get(destPath);
    }

    public void setLegacyWhitespace(boolean legacyWhitespace) {
        this.legacyWhitespace = legacyWhitespace;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    private Completable subscribePath(String destinationPath, @Nullable List<StompHeader> headerList) {
        String topicId = UUID.randomUUID().toString();
        if (this.mTopics == null) {
            this.mTopics = new ConcurrentHashMap();
        }
        if (this.mTopics.containsKey(destinationPath)) {
            Log.d((String)TAG, (String)"Attempted to subscribe to already-subscribed path!");
            return Completable.complete();
        }
        this.mTopics.put(destinationPath, topicId);
        ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
        headers.add(new StompHeader("id", topicId));
        headers.add(new StompHeader("destination", destinationPath));
        headers.add(new StompHeader("ack", DEFAULT_ACK));
        if (headerList != null) {
            headers.addAll(headerList);
        }
        return this.send(new StompMessage("SUBSCRIBE", headers, null));
    }

    private Completable unsubscribePath(String dest) {
        this.mStreamMap.remove(dest);
        String topicId = this.mTopics.get(dest);
        this.mTopics.remove(dest);
        Log.d((String)TAG, (String)("Unsubscribe path: " + dest + " id: " + topicId));
        if (!this.mConnected) {
            Log.d((String)TAG, (String)("Not connected, skip sending Unsubscribe frame to " + dest));
            return Completable.complete();
        }
        return this.send(new StompMessage("UNSUBSCRIBE", Collections.singletonList(new StompHeader("id", topicId)), null));
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public boolean isConnecting() {
        return this.isConnecting;
    }
}

