/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.StompHeader;
import ua.naiksoftware.stomp.client.StompMessage;

public class StompClient {
    private static final String TAG = StompClient.class.getSimpleName();
    public static final String SUPPORTED_VERSIONS = "1.1,1.0";
    public static final String DEFAULT_ACK = "auto";
    private final String tag = StompClient.class.getSimpleName();
    private final ConnectionProvider mConnectionProvider;
    private ConcurrentHashMap<String, String> mTopics;
    private boolean mConnected;
    private boolean isConnecting;
    private boolean legacyWhitespace;
    private PublishSubject<StompMessage> mMessageStream;
    private ConcurrentHashMap<String, Flowable<StompMessage>> mStreamMap;
    private final BehaviorSubject<Boolean> mConnectionStream;
    private Parser parser;
    private Disposable mLifecycleDisposable;
    private Disposable mMessagesDisposable;
    private List<StompHeader> mHeaders;
    private int heartbeat;

    public StompClient(ConnectionProvider connectionProvider) {
        this.mConnectionProvider = connectionProvider;
        this.mMessageStream = PublishSubject.create();
        this.mStreamMap = new ConcurrentHashMap();
        this.mConnectionStream = BehaviorSubject.createDefault((Object)false);
        this.parser = Parser.NONE;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setHeartbeat(int ms) {
        this.heartbeat = ms;
        this.mConnectionProvider.setHeartbeat(ms).subscribe();
    }

    public void connect() {
        this.connect(null);
    }

    public void connect(@Nullable List<StompHeader> _headers) {
        Log.d((String)TAG, (String)"Connect");
        this.mHeaders = _headers;
        if (this.mConnected) {
            Log.d((String)TAG, (String)"Already connected, ignore");
            return;
        }
        this.mLifecycleDisposable = this.mConnectionProvider.lifecycle().subscribe(lifecycleEvent -> {
            switch (lifecycleEvent.getType()) {
                case OPENED: {
                    ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
                    headers.add(new StompHeader("version", SUPPORTED_VERSIONS));
                    headers.add(new StompHeader("heart-beat", "0," + this.heartbeat));
                    if (_headers != null) {
                        headers.addAll(_headers);
                    }
                    this.mConnectionProvider.send(new StompMessage("CONNECT", headers, null).compile(this.legacyWhitespace)).subscribe();
                    break;
                }
                case CLOSED: {
                    Log.d((String)TAG, (String)"Socket closed");
                    this.setConnected(false);
                    this.isConnecting = false;
                    break;
                }
                case ERROR: {
                    Log.d((String)TAG, (String)"Socket closed with error");
                    this.setConnected(false);
                    this.isConnecting = false;
                }
            }
        });
        this.isConnecting = true;
        this.mMessagesDisposable = this.mConnectionProvider.messages().map(StompMessage::from).doOnNext(this::callSubscribers).filter(msg -> msg.getStompCommand().equals("CONNECTED")).subscribe(stompMessage -> {
            this.setConnected(true);
            this.isConnecting = false;
        });
    }

    private void setConnected(boolean connected) {
        this.mConnected = connected;
        this.mConnectionStream.onNext((Object)this.mConnected);
    }

    public void reconnect() {
        this.disconnectCompletable().subscribe(() -> this.connect(this.mHeaders), e -> Log.e((String)this.tag, (String)"Disconnect error", (Throwable)e));
    }

    public Completable send(String destination) {
        return this.send(destination, null);
    }

    public Completable send(String destination, String data) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), data));
    }

    public Completable send(@NonNull StompMessage stompMessage) {
        Completable completable = this.mConnectionProvider.send(stompMessage.compile(this.legacyWhitespace));
        Completable connectionComplete = this.mConnectionStream.filter(isConnected -> isConnected).firstOrError().toCompletable();
        return completable.startWith((CompletableSource)connectionComplete);
    }

    private void callSubscribers(StompMessage stompMessage) {
        this.mMessageStream.onNext((Object)stompMessage);
    }

    public Flowable<LifecycleEvent> lifecycle() {
        return this.mConnectionProvider.lifecycle().toFlowable(BackpressureStrategy.BUFFER);
    }

    public void disconnect() {
        this.disconnectCompletable().subscribe(() -> {}, e -> Log.e((String)this.tag, (String)"Disconnect error", (Throwable)e));
    }

    public Completable disconnectCompletable() {
        if (this.mLifecycleDisposable != null) {
            this.mLifecycleDisposable.dispose();
        }
        if (this.mMessagesDisposable != null) {
            this.mMessagesDisposable.dispose();
        }
        return this.mConnectionProvider.disconnect().doOnComplete(() -> this.setConnected(false));
    }

    public Flowable<StompMessage> topic(String destinationPath) {
        return this.topic(destinationPath, null);
    }

    public Flowable<StompMessage> topic(@NonNull String destPath, List<StompHeader> headerList) {
        if (destPath == null) {
            return Flowable.error((Throwable)new IllegalArgumentException("Topic path cannot be null"));
        }
        if (!this.mStreamMap.containsKey(destPath)) {
            this.mStreamMap.put(destPath, (Flowable<StompMessage>)this.mMessageStream.filter(msg -> this.matches(destPath, (StompMessage)msg)).toFlowable(BackpressureStrategy.BUFFER).doOnSubscribe(disposable -> this.subscribePath(destPath, headerList).subscribe()).doFinally(() -> this.unsubscribePath(destPath).subscribe()).share());
        }
        return this.mStreamMap.get(destPath);
    }

    public void setLegacyWhitespace(boolean legacyWhitespace) {
        this.legacyWhitespace = legacyWhitespace;
    }

    private boolean matches(String path, StompMessage msg) {
        boolean ret;
        String dest = msg.findHeader("destination");
        if (dest == null) {
            return false;
        }
        switch (this.parser) {
            case NONE: {
                ret = path.equals(dest);
                break;
            }
            case RABBITMQ: {
                String[] split = path.split("\\.");
                ArrayList<String> transformed = new ArrayList<String>();
                String[] stringArray = split;
                int n = stringArray.length;
                block12: for (int i = 0; i < n; ++i) {
                    String s;
                    switch (s = stringArray[i]) {
                        case "*": {
                            transformed.add("[^.]+");
                            continue block12;
                        }
                        case "#": {
                            transformed.add(".*");
                            continue block12;
                        }
                        default: {
                            transformed.add(s);
                        }
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (String s : transformed) {
                    if (sb.length() > 0) {
                        sb.append("\\.");
                    }
                    sb.append(s);
                }
                String join = sb.toString();
                ret = dest.matches(join);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private Completable subscribePath(String destinationPath, @Nullable List<StompHeader> headerList) {
        String topicId = UUID.randomUUID().toString();
        if (this.mTopics == null) {
            this.mTopics = new ConcurrentHashMap();
        }
        if (this.mTopics.containsKey(destinationPath)) {
            Log.d((String)TAG, (String)"Attempted to subscribe to already-subscribed path!");
            return Completable.complete();
        }
        this.mTopics.put(destinationPath, topicId);
        ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
        headers.add(new StompHeader("id", topicId));
        headers.add(new StompHeader("destination", destinationPath));
        headers.add(new StompHeader("ack", DEFAULT_ACK));
        if (headerList != null) {
            headers.addAll(headerList);
        }
        return this.send(new StompMessage("SUBSCRIBE", headers, null));
    }

    private Completable unsubscribePath(String dest) {
        this.mStreamMap.remove(dest);
        String topicId = this.mTopics.get(dest);
        this.mTopics.remove(dest);
        Log.d((String)TAG, (String)("Unsubscribe path: " + dest + " id: " + topicId));
        return this.send(new StompMessage("UNSUBSCRIBE", Collections.singletonList(new StompHeader("id", topicId)), null));
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public boolean isConnecting() {
        return this.isConnecting;
    }

    public static enum Parser {
        NONE,
        RABBITMQ;

    }
}

