/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import ua.naiksoftware.stomp.AbstractConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;

class WebSocketsConnectionProvider
extends AbstractConnectionProvider {
    private static final String TAG = WebSocketsConnectionProvider.class.getSimpleName();
    private final String mUri;
    @NonNull
    private final Map<String, String> mConnectHttpHeaders;
    private WebSocketClient mWebSocketClient;
    private boolean haveConnection;
    private TreeMap<String, String> mServerHandshakeHeaders;

    WebSocketsConnectionProvider(String uri, @Nullable Map<String, String> connectHttpHeaders) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
    }

    @Override
    public void rawDisconnect() {
        this.mWebSocketClient.close();
    }

    @Override
    void createWebSocketConnection() {
        if (this.haveConnection) {
            throw new IllegalStateException("Already have connection to web socket");
        }
        this.mWebSocketClient = new WebSocketClient(URI.create(this.mUri), (Draft)new Draft_6455(), this.mConnectHttpHeaders, 0){

            public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, @NonNull ServerHandshake response) throws InvalidDataException {
                Log.d((String)TAG, (String)("onWebsocketHandshakeReceivedAsClient with response: " + response.getHttpStatus() + " " + response.getHttpStatusMessage()));
                WebSocketsConnectionProvider.this.mServerHandshakeHeaders = new TreeMap();
                Iterator keys = response.iterateHttpFields();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    WebSocketsConnectionProvider.this.mServerHandshakeHeaders.put(key, response.getFieldValue(key));
                }
            }

            public void onOpen(@NonNull ServerHandshake handshakeData) {
                Log.d((String)TAG, (String)("onOpen with handshakeData: " + handshakeData.getHttpStatus() + " " + handshakeData.getHttpStatusMessage()));
                LifecycleEvent openEvent = new LifecycleEvent(LifecycleEvent.Type.OPENED);
                openEvent.setHandshakeResponseHeaders(WebSocketsConnectionProvider.this.mServerHandshakeHeaders);
                WebSocketsConnectionProvider.this.emitLifecycleEvent(openEvent);
            }

            public void onMessage(String message) {
                Log.d((String)TAG, (String)("onMessage: " + message));
                WebSocketsConnectionProvider.this.emitMessage(message);
            }

            public void onClose(int code, String reason, boolean remote) {
                Log.d((String)TAG, (String)("onClose: code=" + code + " reason=" + reason + " remote=" + remote));
                WebSocketsConnectionProvider.this.haveConnection = false;
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
            }

            public void onError(Exception ex) {
                Log.e((String)TAG, (String)"onError", (Throwable)ex);
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, ex));
            }
        };
        if (this.mUri.startsWith("wss")) {
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, null, null);
                SSLSocketFactory factory = sc.getSocketFactory();
                this.mWebSocketClient.setSocket(factory.createSocket());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mWebSocketClient.connect();
        this.haveConnection = true;
    }

    @Override
    void rawSend(String stompMessage) {
        this.mWebSocketClient.send(stompMessage);
    }

    @Override
    Object getSocket() {
        return this.mWebSocketClient;
    }
}

