/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.subjects.PublishSubject;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;

abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private static final String TAG = AbstractConnectionProvider.class.getSimpleName();
    @NonNull
    private final PublishSubject<LifecycleEvent> mLifecycleStream = PublishSubject.create();
    @NonNull
    private final PublishSubject<String> mMessagesStream = PublishSubject.create();

    AbstractConnectionProvider() {
    }

    @Override
    @NonNull
    public Observable<String> messages() {
        return this.mMessagesStream.startWith((ObservableSource)this.initSocket().toObservable());
    }

    abstract void rawDisconnect();

    @Override
    public Completable disconnect() {
        return Completable.fromAction(this::rawDisconnect);
    }

    private Completable initSocket() {
        return Completable.fromAction(this::createWebSocketConnection);
    }

    @Override
    public Completable setHeartbeat(int ms) {
        return Completable.complete();
    }

    abstract void createWebSocketConnection();

    @Override
    @NonNull
    public Completable send(String stompMessage) {
        return Completable.fromCallable(() -> {
            if (this.getSocket() == null) {
                throw new IllegalStateException("Not connected yet");
            }
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.rawSend(stompMessage);
            return null;
        });
    }

    abstract void rawSend(String var1);

    @Nullable
    abstract Object getSocket();

    void emitLifecycleEvent(@NonNull LifecycleEvent lifecycleEvent) {
        Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
        this.mLifecycleStream.onNext((Object)lifecycleEvent);
    }

    void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Emit STOMP message: " + stompMessage));
        this.mMessagesStream.onNext((Object)stompMessage);
    }

    @Override
    @NonNull
    public Observable<LifecycleEvent> lifecycle() {
        return this.mLifecycleStream;
    }
}

