/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$1;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$2;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$3;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$4;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$5;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider;

class OkHttpConnectionProvider
implements ConnectionProvider {
    private static final String TAG = WebSocketsConnectionProvider.class.getSimpleName();
    private final String mUri;
    private final Map<String, String> mConnectHttpHeaders;
    private final OkHttpClient mOkHttpClient;
    private final List<FlowableEmitter<? super LifecycleEvent>> mLifecycleEmitters;
    private final List<FlowableEmitter<? super String>> mMessagesEmitters;
    private WebSocket openedSocked;

    OkHttpConnectionProvider(String uri, Map<String, String> connectHttpHeaders, OkHttpClient okHttpClient) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
        this.mLifecycleEmitters = Collections.synchronizedList(new ArrayList());
        this.mMessagesEmitters = new ArrayList<FlowableEmitter<? super String>>();
        this.mOkHttpClient = okHttpClient;
    }

    @Override
    public Flowable<String> messages() {
        List<FlowableEmitter<? super String>> list = this.mMessagesEmitters;
        list.getClass();
        Flowable flowable = Flowable.create((FlowableOnSubscribe)OkHttpConnectionProvider$$Lambda$1.lambdaFactory$(list), (BackpressureStrategy)BackpressureStrategy.BUFFER).doFinally(OkHttpConnectionProvider$$Lambda$2.lambdaFactory$(this));
        this.createWebSocketConnection();
        return flowable;
    }

    private void createWebSocketConnection() {
        if (this.openedSocked != null) {
            throw new IllegalStateException("Already have connection to web socket");
        }
        Request.Builder requestBuilder = new Request.Builder().url(this.mUri);
        this.addConnectionHeadersToBuilder(requestBuilder, this.mConnectHttpHeaders);
        this.openedSocked = this.mOkHttpClient.newWebSocket(requestBuilder.build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                LifecycleEvent openEvent = new LifecycleEvent(LifecycleEvent.Type.OPENED);
                TreeMap headersAsMap = OkHttpConnectionProvider.this.headersAsMap(response);
                openEvent.setHandshakeResponseHeaders(headersAsMap);
                OkHttpConnectionProvider.this.emitLifecycleEvent(openEvent);
            }

            public void onMessage(WebSocket webSocket, String text) {
                OkHttpConnectionProvider.this.emitMessage(text);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                OkHttpConnectionProvider.this.emitMessage(bytes.utf8());
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
                OkHttpConnectionProvider.this.openedSocked = null;
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, new Exception(t)));
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(code, reason);
            }
        });
    }

    @Override
    public Flowable<Void> send(String stompMessage) {
        return Flowable.create((FlowableOnSubscribe)OkHttpConnectionProvider$$Lambda$3.lambdaFactory$(this, stompMessage), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    @Override
    public Flowable<LifecycleEvent> getLifecycleReceiver() {
        List<FlowableEmitter<? super LifecycleEvent>> list = this.mLifecycleEmitters;
        list.getClass();
        return Flowable.create((FlowableOnSubscribe)OkHttpConnectionProvider$$Lambda$4.lambdaFactory$(list), (BackpressureStrategy)BackpressureStrategy.BUFFER).doFinally(OkHttpConnectionProvider$$Lambda$5.lambdaFactory$(this));
    }

    private TreeMap<String, String> headersAsMap(Response response) {
        TreeMap<String, String> headersAsMap = new TreeMap<String, String>();
        Headers headers = response.headers();
        for (String key : headers.names()) {
            headersAsMap.put(key, headers.get(key));
        }
        return headersAsMap;
    }

    private void addConnectionHeadersToBuilder(Request.Builder requestBuilder, Map<String, String> mConnectHttpHeaders) {
        for (Map.Entry<String, String> headerEntry : mConnectHttpHeaders.entrySet()) {
            requestBuilder.addHeader(headerEntry.getKey(), headerEntry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitLifecycleEvent(LifecycleEvent lifecycleEvent) {
        List<FlowableEmitter<? super LifecycleEvent>> list = this.mLifecycleEmitters;
        synchronized (list) {
            Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
            for (FlowableEmitter<? super LifecycleEvent> subscriber : this.mLifecycleEmitters) {
                subscriber.onNext((Object)lifecycleEvent);
            }
        }
    }

    private void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Emit STOMP message: " + stompMessage));
        for (FlowableEmitter<? super String> subscriber : this.mMessagesEmitters) {
            subscriber.onNext((Object)stompMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    /* synthetic */ void lambda$getLifecycleReceiver$2() throws Exception {
        List<FlowableEmitter<? super LifecycleEvent>> list = this.mLifecycleEmitters;
        synchronized (list) {
            Iterator<FlowableEmitter<? super LifecycleEvent>> iterator = this.mLifecycleEmitters.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isCancelled()) continue;
                iterator.remove();
            }
        }
    }

    /* synthetic */ void lambda$send$1(String stompMessage, FlowableEmitter subscriber) throws Exception {
        if (this.openedSocked == null) {
            subscriber.onError((Throwable)new IllegalStateException("Not connected yet"));
        } else {
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.openedSocked.send(stompMessage);
            subscriber.onComplete();
        }
    }

    /* synthetic */ void lambda$messages$0() throws Exception {
        Iterator<FlowableEmitter<? super String>> iterator = this.mMessagesEmitters.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isCancelled()) continue;
            iterator.remove();
        }
        if (this.mMessagesEmitters.size() < 1) {
            Log.d((String)TAG, (String)("Close web socket connection now in thread " + Thread.currentThread()));
            this.openedSocked.close(1000, "");
            this.openedSocked = null;
        }
    }
}

