/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.client;

import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.StompHeader;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$1;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$2;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$3;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$4;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$5;
import ua.naiksoftware.stomp.client.StompMessage;

public class StompClient {
    private static final String TAG = StompClient.class.getSimpleName();
    public static final String SUPPORTED_VERSIONS = "1.1,1.0";
    public static final String DEFAULT_ACK = "auto";
    private Disposable mMessagesDisposable;
    private Disposable mLifecycleDisposable;
    private Map<String, Set<FlowableEmitter<? super StompMessage>>> mEmitters = new ConcurrentHashMap<String, Set<FlowableEmitter<? super StompMessage>>>();
    private List<ConnectableFlowable<Void>> mWaitConnectionFlowables;
    private final ConnectionProvider mConnectionProvider;
    private HashMap<String, String> mTopics;
    private boolean mConnected;
    private boolean isConnecting;

    public StompClient(ConnectionProvider connectionProvider) {
        this.mConnectionProvider = connectionProvider;
        this.mWaitConnectionFlowables = new CopyOnWriteArrayList<ConnectableFlowable<Void>>();
    }

    public void connect() {
        this.connect(null);
    }

    public void connect(boolean reconnect) {
        this.connect(null, reconnect);
    }

    public void connect(List<StompHeader> _headers) {
        this.connect(_headers, false);
    }

    public void connect(List<StompHeader> _headers, boolean reconnect) {
        if (reconnect) {
            this.disconnect();
        }
        if (this.mConnected) {
            return;
        }
        this.mLifecycleDisposable = this.mConnectionProvider.getLifecycleReceiver().subscribe(StompClient$$Lambda$1.lambdaFactory$(this, _headers));
        this.isConnecting = true;
        this.mMessagesDisposable = this.mConnectionProvider.messages().map(StompClient$$Lambda$2.lambdaFactory$()).subscribe(StompClient$$Lambda$3.lambdaFactory$(this));
    }

    public Flowable<Void> send(String destination) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), null));
    }

    public Flowable<Void> send(String destination, String data) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), data));
    }

    public Flowable<Void> send(StompMessage stompMessage) {
        Flowable<Void> flowable = this.mConnectionProvider.send(stompMessage.compile());
        if (!this.mConnected) {
            ConnectableFlowable deffered = flowable.publish();
            this.mWaitConnectionFlowables.add((ConnectableFlowable<Void>)deffered);
            return deffered;
        }
        return flowable;
    }

    private void callSubscribers(StompMessage stompMessage) {
        String messageDestination = stompMessage.findHeader("destination");
        for (String dest : this.mEmitters.keySet()) {
            if (!dest.equals(messageDestination)) continue;
            for (FlowableEmitter<? super StompMessage> subscriber : this.mEmitters.get(dest)) {
                subscriber.onNext((Object)stompMessage);
            }
            return;
        }
    }

    public Flowable<LifecycleEvent> lifecycle() {
        return this.mConnectionProvider.getLifecycleReceiver();
    }

    public void disconnect() {
        if (this.mMessagesDisposable != null) {
            this.mMessagesDisposable.dispose();
        }
        if (this.mLifecycleDisposable != null) {
            this.mLifecycleDisposable.dispose();
        }
        this.mConnected = false;
    }

    public Flowable<StompMessage> topic(String destinationPath) {
        return this.topic(destinationPath, null);
    }

    public Flowable<StompMessage> topic(String destinationPath, List<StompHeader> headerList) {
        return Flowable.create((FlowableOnSubscribe)StompClient$$Lambda$4.lambdaFactory$(this, destinationPath, headerList), (BackpressureStrategy)BackpressureStrategy.BUFFER).doOnCancel(StompClient$$Lambda$5.lambdaFactory$(this));
    }

    private Flowable<Void> subscribePath(String destinationPath, List<StompHeader> headerList) {
        if (destinationPath == null) {
            return Flowable.empty();
        }
        String topicId = UUID.randomUUID().toString();
        if (this.mTopics == null) {
            this.mTopics = new HashMap();
        }
        this.mTopics.put(destinationPath, topicId);
        ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
        headers.add(new StompHeader("id", topicId));
        headers.add(new StompHeader("destination", destinationPath));
        headers.add(new StompHeader("ack", DEFAULT_ACK));
        if (headerList != null) {
            headers.addAll(headerList);
        }
        return this.send(new StompMessage("SUBSCRIBE", headers, null));
    }

    private Flowable<Void> unsubscribePath(String dest) {
        String topicId = this.mTopics.get(dest);
        Log.d((String)TAG, (String)("Unsubscribe path: " + dest + " id: " + topicId));
        return this.send(new StompMessage("UNSUBSCRIBE", Collections.singletonList(new StompHeader("id", topicId)), null));
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public boolean isConnecting() {
        return this.isConnecting;
    }

    /* synthetic */ void lambda$topic$3() throws Exception {
        Iterator<String> mapIterator = this.mEmitters.keySet().iterator();
        while (mapIterator.hasNext()) {
            String destinationUrl = mapIterator.next();
            Set<FlowableEmitter<? super StompMessage>> set = this.mEmitters.get(destinationUrl);
            Iterator<FlowableEmitter<? super StompMessage>> setIterator = set.iterator();
            while (setIterator.hasNext()) {
                FlowableEmitter<? super StompMessage> subscriber = setIterator.next();
                if (!subscriber.isCancelled()) continue;
                setIterator.remove();
                if (set.size() >= 1) continue;
                mapIterator.remove();
                this.unsubscribePath(destinationUrl).subscribe();
            }
        }
    }

    /* synthetic */ void lambda$topic$2(String destinationPath, List headerList, FlowableEmitter emitter) throws Exception {
        Set<FlowableEmitter<? super StompMessage>> emittersSet = this.mEmitters.get(destinationPath);
        if (emittersSet == null) {
            emittersSet = new HashSet<FlowableEmitter<? super StompMessage>>();
            this.mEmitters.put(destinationPath, emittersSet);
            this.subscribePath(destinationPath, headerList).subscribe();
        }
        emittersSet.add((FlowableEmitter<? super StompMessage>)emitter);
    }

    /* synthetic */ void lambda$connect$1(StompMessage stompMessage) throws Exception {
        if (stompMessage.getStompCommand().equals("CONNECTED")) {
            this.mConnected = true;
            this.isConnecting = false;
            for (ConnectableFlowable<Void> flowable : this.mWaitConnectionFlowables) {
                flowable.connect();
            }
            this.mWaitConnectionFlowables.clear();
        }
        this.callSubscribers(stompMessage);
    }

    /* synthetic */ void lambda$connect$0(List _headers, LifecycleEvent lifecycleEvent) throws Exception {
        switch (lifecycleEvent.getType()) {
            case OPENED: {
                ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
                headers.add(new StompHeader("version", SUPPORTED_VERSIONS));
                if (_headers != null) {
                    headers.addAll(_headers);
                }
                this.mConnectionProvider.send(new StompMessage("CONNECT", headers, null).compile()).subscribe();
                break;
            }
            case CLOSED: {
                this.mConnected = false;
                this.isConnecting = false;
                break;
            }
            case ERROR: {
                this.mConnected = false;
                this.isConnecting = false;
            }
        }
    }
}

