/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.OkHttpConnectionProvider;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider;
import ua.naiksoftware.stomp.client.StompClient;

public class Stomp {
    public static StompClient over(Class clazz, String uri) {
        return Stomp.over(clazz, uri, null, null);
    }

    public static StompClient over(Class clazz, String uri, Map<String, String> connectHttpHeaders) {
        return Stomp.over(clazz, uri, connectHttpHeaders, null);
    }

    public static StompClient over(Class clazz, String uri, Map<String, String> connectHttpHeaders, Object webSocketClient) {
        try {
            if (Class.forName("org.java_websocket.WebSocket") != null && clazz == org.java_websocket.WebSocket.class) {
                if (webSocketClient != null) {
                    throw new IllegalArgumentException("You cannot pass a webSocketClient with 'org.java_websocket.WebSocket'. use null instead.");
                }
                return Stomp.createStompClient(new WebSocketsConnectionProvider(uri, connectHttpHeaders));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (Class.forName("okhttp3.WebSocket") != null && clazz == WebSocket.class) {
                OkHttpClient okHttpClient = Stomp.getOkHttpClient(webSocketClient);
                return Stomp.createStompClient(new OkHttpConnectionProvider(uri, connectHttpHeaders, okHttpClient));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new RuntimeException("Not supported overlay transport: " + clazz.getName());
    }

    private static StompClient createStompClient(ConnectionProvider connectionProvider) {
        return new StompClient(connectionProvider);
    }

    private static OkHttpClient getOkHttpClient(Object webSocketClient) {
        if (webSocketClient != null) {
            if (webSocketClient instanceof OkHttpClient) {
                return (OkHttpClient)webSocketClient;
            }
            throw new IllegalArgumentException("You must pass a non-null instance of an 'okhttp3.OkHttpClient'. Or pass null to use a default websocket client.");
        }
        return new OkHttpClient();
    }
}

