/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import rx.Observable;
import rx.Subscriber;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$1;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$2;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$3;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$4;
import ua.naiksoftware.stomp.OkHttpConnectionProvider$$Lambda$5;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider;

class OkHttpConnectionProvider
implements ConnectionProvider {
    private static final String TAG = WebSocketsConnectionProvider.class.getSimpleName();
    private final String mUri;
    private final Map<String, String> mConnectHttpHeaders;
    private final OkHttpClient mOkHttpClient;
    private final List<Subscriber<? super LifecycleEvent>> mLifecycleSubscribers;
    private final List<Subscriber<? super String>> mMessagesSubscribers;
    private WebSocket openedSocked;

    OkHttpConnectionProvider(String uri, Map<String, String> connectHttpHeaders, OkHttpClient okHttpClient) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
        this.mLifecycleSubscribers = new ArrayList<Subscriber<? super LifecycleEvent>>();
        this.mMessagesSubscribers = new ArrayList<Subscriber<? super String>>();
        this.mOkHttpClient = okHttpClient;
    }

    @Override
    public Observable<String> messages() {
        Observable observable = Observable.create((Observable.OnSubscribe)OkHttpConnectionProvider$$Lambda$1.lambdaFactory$(this)).doOnUnsubscribe(OkHttpConnectionProvider$$Lambda$2.lambdaFactory$(this));
        this.createWebSocketConnection();
        return observable;
    }

    private void createWebSocketConnection() {
        if (this.openedSocked != null) {
            throw new IllegalStateException("Already have connection to web socket");
        }
        Request.Builder requestBuilder = new Request.Builder().url(this.mUri);
        this.addConnectionHeadersToBuilder(requestBuilder, this.mConnectHttpHeaders);
        this.openedSocked = this.mOkHttpClient.newWebSocket(requestBuilder.build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                LifecycleEvent openEvent = new LifecycleEvent(LifecycleEvent.Type.OPENED);
                TreeMap headersAsMap = OkHttpConnectionProvider.this.headersAsMap(response);
                openEvent.setHandshakeResponseHeaders(headersAsMap);
                OkHttpConnectionProvider.this.emitLifecycleEvent(openEvent);
            }

            public void onMessage(WebSocket webSocket, String text) {
                OkHttpConnectionProvider.this.emitMessage(text);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                OkHttpConnectionProvider.this.emitMessage(bytes.utf8());
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
                OkHttpConnectionProvider.this.openedSocked = null;
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                OkHttpConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, new Exception(t)));
            }
        });
    }

    @Override
    public Observable<Void> send(String stompMessage) {
        return Observable.create((Observable.OnSubscribe)OkHttpConnectionProvider$$Lambda$3.lambdaFactory$(this, stompMessage));
    }

    @Override
    public Observable<LifecycleEvent> getLifecycleReceiver() {
        return Observable.create((Observable.OnSubscribe)OkHttpConnectionProvider$$Lambda$4.lambdaFactory$(this)).doOnUnsubscribe(OkHttpConnectionProvider$$Lambda$5.lambdaFactory$(this));
    }

    private TreeMap<String, String> headersAsMap(Response response) {
        TreeMap<String, String> headersAsMap = new TreeMap<String, String>();
        Headers headers = response.headers();
        for (String key : headers.names()) {
            headersAsMap.put(key, headers.get(key));
        }
        return headersAsMap;
    }

    private void addConnectionHeadersToBuilder(Request.Builder requestBuilder, Map<String, String> mConnectHttpHeaders) {
        for (Map.Entry<String, String> headerEntry : mConnectHttpHeaders.entrySet()) {
            requestBuilder.addHeader(headerEntry.getKey(), headerEntry.getValue());
        }
    }

    private void emitLifecycleEvent(LifecycleEvent lifecycleEvent) {
        Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
        for (Subscriber<? super LifecycleEvent> subscriber : this.mLifecycleSubscribers) {
            subscriber.onNext((Object)lifecycleEvent);
        }
    }

    private void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Emit STOMP message: " + stompMessage));
        for (Subscriber<? super String> subscriber : this.mMessagesSubscribers) {
            subscriber.onNext((Object)stompMessage);
        }
    }

    /* synthetic */ void lambda$getLifecycleReceiver$4() {
        Iterator<Subscriber<? super LifecycleEvent>> iterator = this.mLifecycleSubscribers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isUnsubscribed()) continue;
            iterator.remove();
        }
    }

    /* synthetic */ void lambda$getLifecycleReceiver$3(Subscriber subscriber) {
        this.mLifecycleSubscribers.add((Subscriber<? super LifecycleEvent>)subscriber);
    }

    /* synthetic */ void lambda$send$2(String stompMessage, Subscriber subscriber) {
        if (this.openedSocked == null) {
            subscriber.onError((Throwable)new IllegalStateException("Not connected yet"));
        } else {
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.openedSocked.send(stompMessage);
            subscriber.onCompleted();
        }
    }

    /* synthetic */ void lambda$messages$1() {
        Iterator<Subscriber<? super String>> iterator = this.mMessagesSubscribers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isUnsubscribed()) continue;
            iterator.remove();
        }
        if (this.mMessagesSubscribers.size() < 1) {
            Log.d((String)TAG, (String)("Close web socket connection now in thread " + Thread.currentThread()));
            this.openedSocked.close(1000, "");
            this.openedSocked = null;
        }
    }

    /* synthetic */ void lambda$messages$0(Subscriber subscriber) {
        this.mMessagesSubscribers.add((Subscriber<? super String>)subscriber);
    }
}

