/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.util.Log;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import rx.Observable;
import rx.Subscriber;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$1;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$4;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$5;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$6;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$7;

public class WebSocketsConnectionProvider
implements ConnectionProvider {
    private static final String TAG = WebSocketsConnectionProvider.class.getSimpleName();
    private final String mUri;
    private final Map<String, String> mConnectHttpHeaders;
    private WebSocketClient mWebSocketClient;
    private List<Subscriber<? super LifecycleEvent>> mLifecycleSubscribers;
    private List<Subscriber<? super String>> mMessagesSubscribers;
    private boolean haveConnection;
    private TreeMap<String, String> mServerHandshakeHeaders;

    public WebSocketsConnectionProvider(String uri, Map<String, String> connectHttpHeaders) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
        this.mLifecycleSubscribers = new ArrayList<Subscriber<? super LifecycleEvent>>();
        this.mMessagesSubscribers = new ArrayList<Subscriber<? super String>>();
    }

    @Override
    public Observable<String> messages() {
        Observable observable = Observable.create((Observable.OnSubscribe)WebSocketsConnectionProvider$$Lambda$1.lambdaFactory$(this)).doOnUnsubscribe(WebSocketsConnectionProvider$$Lambda$4.lambdaFactory$(this));
        this.createWebSocketConnection();
        return observable;
    }

    private void createWebSocketConnection() {
        if (this.haveConnection) {
            throw new IllegalStateException("Already have connection to web socket");
        }
        this.mWebSocketClient = new WebSocketClient(URI.create(this.mUri), (Draft)new Draft_17(), this.mConnectHttpHeaders, 0){

            public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
                Log.d((String)TAG, (String)("onWebsocketHandshakeReceivedAsClient with response: " + response.getHttpStatus() + " " + response.getHttpStatusMessage()));
                WebSocketsConnectionProvider.this.mServerHandshakeHeaders = new TreeMap();
                Iterator keys = response.iterateHttpFields();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    WebSocketsConnectionProvider.this.mServerHandshakeHeaders.put(key, response.getFieldValue(key));
                }
            }

            public void onOpen(ServerHandshake handshakeData) {
                Log.d((String)TAG, (String)("onOpen with handshakeData: " + handshakeData.getHttpStatus() + " " + handshakeData.getHttpStatusMessage()));
                LifecycleEvent openEvent = new LifecycleEvent(LifecycleEvent.Type.OPENED);
                openEvent.setHandshakeResponseHeaders(WebSocketsConnectionProvider.this.mServerHandshakeHeaders);
                WebSocketsConnectionProvider.this.emitLifecycleEvent(openEvent);
            }

            public void onMessage(String message) {
                Log.d((String)TAG, (String)("onMessage: " + message));
                WebSocketsConnectionProvider.this.emitMessage(message);
            }

            public void onClose(int code, String reason, boolean remote) {
                Log.d((String)TAG, (String)("onClose: code=" + code + " reason=" + reason + " remote=" + remote));
                WebSocketsConnectionProvider.this.haveConnection = false;
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
            }

            public void onError(Exception ex) {
                Log.e((String)TAG, (String)"onError", (Throwable)ex);
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, ex));
            }
        };
        if (this.mUri.startsWith("wss")) {
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, null, null);
                SSLSocketFactory factory = sc.getSocketFactory();
                this.mWebSocketClient.setSocket(factory.createSocket());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mWebSocketClient.connect();
        this.haveConnection = true;
    }

    @Override
    public Observable<Void> send(String stompMessage) {
        return Observable.create((Observable.OnSubscribe)WebSocketsConnectionProvider$$Lambda$5.lambdaFactory$(this, stompMessage));
    }

    private void emitLifecycleEvent(LifecycleEvent lifecycleEvent) {
        Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
        for (Subscriber<? super LifecycleEvent> subscriber : this.mLifecycleSubscribers) {
            subscriber.onNext((Object)lifecycleEvent);
        }
    }

    private void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Emit STOMP message: " + stompMessage));
        for (Subscriber<? super String> subscriber : this.mMessagesSubscribers) {
            subscriber.onNext((Object)stompMessage);
        }
    }

    @Override
    public Observable<LifecycleEvent> getLifecycleReceiver() {
        return Observable.create((Observable.OnSubscribe)WebSocketsConnectionProvider$$Lambda$6.lambdaFactory$(this)).doOnUnsubscribe(WebSocketsConnectionProvider$$Lambda$7.lambdaFactory$(this));
    }

    /* synthetic */ void lambda$getLifecycleReceiver$4() {
        Iterator<Subscriber<? super LifecycleEvent>> iterator = this.mLifecycleSubscribers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isUnsubscribed()) continue;
            iterator.remove();
        }
    }

    /* synthetic */ void lambda$getLifecycleReceiver$3(Subscriber subscriber) {
        this.mLifecycleSubscribers.add((Subscriber<? super LifecycleEvent>)subscriber);
    }

    /* synthetic */ void lambda$send$2(String stompMessage, Subscriber subscriber) {
        if (this.mWebSocketClient == null) {
            subscriber.onError((Throwable)new IllegalStateException("Not connected yet"));
        } else {
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.mWebSocketClient.send(stompMessage);
            subscriber.onCompleted();
        }
    }

    /* synthetic */ void lambda$messages$1() {
        Iterator<Subscriber<? super String>> iterator = this.mMessagesSubscribers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isUnsubscribed()) continue;
            iterator.remove();
        }
        if (this.mMessagesSubscribers.size() < 1) {
            Log.d((String)TAG, (String)("Close web socket connection now in thread " + Thread.currentThread()));
            this.mWebSocketClient.close();
        }
    }

    /* synthetic */ void lambda$messages$0(Subscriber subscriber) {
        this.mMessagesSubscribers.add((Subscriber<? super String>)subscriber);
    }
}

