/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.client;

import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.observables.ConnectableObservable;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.StompHeader;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$1;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$2;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$3;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$4;
import ua.naiksoftware.stomp.client.StompClient$$Lambda$5;
import ua.naiksoftware.stomp.client.StompMessage;

public class StompClient {
    private static final String TAG = StompClient.class.getSimpleName();
    public static final String SUPPORTED_VERSIONS = "1.1,1.0";
    public static final String DEFAULT_ACK = "auto";
    private Subscription mMessagesSubscription;
    private Map<String, Set<Subscriber<? super StompMessage>>> mSubscribers = new HashMap<String, Set<Subscriber<? super StompMessage>>>();
    private List<ConnectableObservable<Void>> mWaitConnectionObservables;
    private final ConnectionProvider mConnectionProvider;
    private HashMap<String, String> mTopics;
    private boolean mConnected;

    public StompClient(ConnectionProvider connectionProvider) {
        this.mConnectionProvider = connectionProvider;
        this.mWaitConnectionObservables = new ArrayList<ConnectableObservable<Void>>();
    }

    public void connect() {
        this.connect(null);
    }

    public void connect(boolean reconnect) {
        this.connect(null, reconnect);
    }

    public void connect(List<StompHeader> _headers) {
        this.connect(_headers, false);
    }

    public void connect(List<StompHeader> _headers, boolean reconnect) {
        if (reconnect) {
            this.disconnect();
        }
        if (this.mConnected) {
            return;
        }
        this.mConnectionProvider.getLifecycleReceiver().subscribe(StompClient$$Lambda$1.lambdaFactory$(this, _headers));
        this.mMessagesSubscription = this.mConnectionProvider.messages().map(StompClient$$Lambda$2.lambdaFactory$()).subscribe(StompClient$$Lambda$3.lambdaFactory$(this));
    }

    public Observable<Void> send(String destination) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), null));
    }

    public Observable<Void> send(String destination, String data) {
        return this.send(new StompMessage("SEND", Collections.singletonList(new StompHeader("destination", destination)), data));
    }

    public Observable<Void> send(StompMessage stompMessage) {
        Observable<Void> observable = this.mConnectionProvider.send(stompMessage.compile());
        if (!this.mConnected) {
            ConnectableObservable deffered = observable.publish();
            this.mWaitConnectionObservables.add((ConnectableObservable<Void>)deffered);
            return deffered;
        }
        return observable;
    }

    private void callSubscribers(StompMessage stompMessage) {
        String messageDestination = stompMessage.findHeader("destination");
        for (String dest : this.mSubscribers.keySet()) {
            if (!dest.equals(messageDestination)) continue;
            for (Subscriber<? super StompMessage> subscriber : this.mSubscribers.get(dest)) {
                subscriber.onNext((Object)stompMessage);
            }
            return;
        }
    }

    public Observable<LifecycleEvent> lifecycle() {
        return this.mConnectionProvider.getLifecycleReceiver();
    }

    public void disconnect() {
        if (this.mMessagesSubscription != null) {
            this.mMessagesSubscription.unsubscribe();
        }
        this.mConnected = false;
    }

    public Observable<StompMessage> topic(String destinationPath) {
        return Observable.create((Observable.OnSubscribe)StompClient$$Lambda$4.lambdaFactory$(this, destinationPath)).doOnUnsubscribe(StompClient$$Lambda$5.lambdaFactory$(this));
    }

    private void subscribePath(String destinationPath) {
        if (destinationPath == null) {
            return;
        }
        String topicId = UUID.randomUUID().toString();
        Log.d((String)TAG, (String)("Subscribe path: " + destinationPath + " id: " + topicId));
        if (this.mTopics == null) {
            this.mTopics = new HashMap();
        }
        this.mTopics.put(destinationPath, topicId);
        this.send(new StompMessage("SUBSCRIBE", Arrays.asList(new StompHeader("id", topicId), new StompHeader("destination", destinationPath), new StompHeader("ack", DEFAULT_ACK)), null));
    }

    private void unsubscribePath(String dest) {
        String topicId = this.mTopics.get(dest);
        Log.d((String)TAG, (String)("Unsubscribe path: " + dest + " id: " + topicId));
        this.send(new StompMessage("UNSUBSCRIBE", Collections.singletonList(new StompHeader("id", topicId)), null));
    }

    private /* synthetic */ void lambda$topic$3() {
        for (String dest : this.mSubscribers.keySet()) {
            Set<Subscriber<? super StompMessage>> set = this.mSubscribers.get(dest);
            for (Subscriber<? super StompMessage> subscriber : set) {
                if (!subscriber.isUnsubscribed()) continue;
                set.remove(subscriber);
                if (set.size() >= 1) continue;
                this.mSubscribers.remove(dest);
                this.unsubscribePath(dest);
            }
        }
    }

    private /* synthetic */ void lambda$topic$2(String destinationPath, Subscriber subscriber) {
        Set<Subscriber<? super StompMessage>> subscribersSet = this.mSubscribers.get(destinationPath);
        if (subscribersSet == null) {
            subscribersSet = new HashSet<Subscriber<? super StompMessage>>();
            this.mSubscribers.put(destinationPath, subscribersSet);
            this.subscribePath(destinationPath);
        }
        subscribersSet.add((Subscriber<? super StompMessage>)subscriber);
    }

    private /* synthetic */ void lambda$connect$1(StompMessage stompMessage) {
        if (stompMessage.getStompCommand().equals("CONNECTED")) {
            this.mConnected = true;
            for (ConnectableObservable<Void> observable : this.mWaitConnectionObservables) {
                observable.connect();
            }
            this.mWaitConnectionObservables.clear();
        }
        this.callSubscribers(stompMessage);
    }

    private /* synthetic */ void lambda$connect$0(List _headers, LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.getType()) {
            case OPENED: {
                ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
                headers.add(new StompHeader("version", SUPPORTED_VERSIONS));
                if (_headers != null) {
                    headers.addAll(_headers);
                }
                this.mConnectionProvider.send(new StompMessage("CONNECT", headers, null).compile()).subscribe();
                break;
            }
            case CLOSED: {
                this.mConnected = false;
            }
        }
    }

    static /* synthetic */ void access$lambda$0(StompClient stompClient, List list, LifecycleEvent lifecycleEvent) {
        stompClient.lambda$connect$0(list, lifecycleEvent);
    }

    static /* synthetic */ void access$lambda$1(StompClient stompClient, StompMessage stompMessage) {
        stompClient.lambda$connect$1(stompMessage);
    }

    static /* synthetic */ void access$lambda$2(StompClient stompClient, String string, Subscriber subscriber) {
        stompClient.lambda$topic$2(string, subscriber);
    }

    static /* synthetic */ void access$lambda$3(StompClient stompClient) {
        stompClient.lambda$topic$3();
    }
}

