/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.util.Log;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;
import rx.Observable;
import rx.Subscriber;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$1;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$4;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$5;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$6;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$7;

public class WebSocketsConnectionProvider
implements ConnectionProvider {
    private static final String TAG = WebSocketsConnectionProvider.class.getSimpleName();
    private final String mUri;
    private final Map<String, String> mConnectHttpHeaders;
    private WebSocketClient mWebSocketClient;
    private List<Subscriber<? super LifecycleEvent>> mLifecycleSubscribers;
    private List<Subscriber<? super String>> mMessagesSubscribers;
    private boolean haveConnection;

    public WebSocketsConnectionProvider(String uri, Map<String, String> connectHttpHeaders) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
        this.mLifecycleSubscribers = new ArrayList<Subscriber<? super LifecycleEvent>>();
        this.mMessagesSubscribers = new ArrayList<Subscriber<? super String>>();
    }

    @Override
    public Observable<String> messages() {
        Observable observable = Observable.create((Observable.OnSubscribe)WebSocketsConnectionProvider$$Lambda$1.lambdaFactory$(this)).doOnUnsubscribe(WebSocketsConnectionProvider$$Lambda$4.lambdaFactory$(this));
        this.createWebSocketConnection();
        return observable;
    }

    private void createWebSocketConnection() {
        if (this.haveConnection) {
            throw new IllegalStateException("Already have connection to web socket");
        }
        this.mWebSocketClient = new WebSocketClient(URI.create(this.mUri), (Draft)new Draft_17(), this.mConnectHttpHeaders, 0){

            public void onOpen(ServerHandshake handshakeData) {
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.OPENED));
            }

            public void onMessage(String message) {
                WebSocketsConnectionProvider.this.emitMessage(message);
            }

            public void onClose(int code, String reason, boolean remote) {
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
            }

            public void onError(Exception ex) {
                ex.printStackTrace();
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, ex));
            }
        };
        this.mWebSocketClient.connect();
        this.haveConnection = true;
    }

    @Override
    public Observable<Void> send(String stompMessage) {
        return Observable.create((Observable.OnSubscribe)WebSocketsConnectionProvider$$Lambda$5.lambdaFactory$(this, stompMessage));
    }

    private void emitLifecycleEvent(LifecycleEvent lifecycleEvent) {
        Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
        for (Subscriber<? super LifecycleEvent> subscriber : this.mLifecycleSubscribers) {
            subscriber.onNext((Object)lifecycleEvent);
        }
    }

    private void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Emit STOMP message: " + stompMessage));
        for (Subscriber<? super String> subscriber : this.mMessagesSubscribers) {
            subscriber.onNext((Object)stompMessage);
        }
    }

    @Override
    public Observable<LifecycleEvent> getLifecycleReceiver() {
        return Observable.create((Observable.OnSubscribe)WebSocketsConnectionProvider$$Lambda$6.lambdaFactory$(this)).doOnUnsubscribe(WebSocketsConnectionProvider$$Lambda$7.lambdaFactory$(this));
    }

    private /* synthetic */ void lambda$getLifecycleReceiver$4() {
        for (Subscriber<? super LifecycleEvent> subscriber : this.mLifecycleSubscribers) {
            if (!subscriber.isUnsubscribed()) continue;
            this.mLifecycleSubscribers.remove(subscriber);
        }
    }

    private /* synthetic */ void lambda$getLifecycleReceiver$3(Subscriber subscriber) {
        this.mLifecycleSubscribers.add((Subscriber<? super LifecycleEvent>)subscriber);
    }

    private /* synthetic */ void lambda$send$2(String stompMessage, Subscriber subscriber) {
        if (this.mWebSocketClient == null) {
            subscriber.onError((Throwable)new IllegalStateException("Not connected yet"));
        } else {
            this.mWebSocketClient.send(stompMessage);
            subscriber.onCompleted();
        }
    }

    private /* synthetic */ void lambda$messages$1() {
        for (Subscriber<? super String> subscriber : this.mMessagesSubscribers) {
            if (!subscriber.isUnsubscribed()) continue;
            this.mMessagesSubscribers.remove(subscriber);
        }
        if (this.mMessagesSubscribers.size() < 1) {
            this.mWebSocketClient.close();
        }
    }

    private /* synthetic */ void lambda$messages$0(Subscriber subscriber) {
        this.mMessagesSubscribers.add((Subscriber<? super String>)subscriber);
    }

    static /* synthetic */ void access$lambda$0(WebSocketsConnectionProvider webSocketsConnectionProvider, Subscriber subscriber) {
        webSocketsConnectionProvider.lambda$messages$0(subscriber);
    }

    static /* synthetic */ void access$lambda$1(WebSocketsConnectionProvider webSocketsConnectionProvider) {
        webSocketsConnectionProvider.lambda$messages$1();
    }

    static /* synthetic */ void access$lambda$2(WebSocketsConnectionProvider webSocketsConnectionProvider, String string, Subscriber subscriber) {
        webSocketsConnectionProvider.lambda$send$2(string, subscriber);
    }

    static /* synthetic */ void access$lambda$3(WebSocketsConnectionProvider webSocketsConnectionProvider, Subscriber subscriber) {
        webSocketsConnectionProvider.lambda$getLifecycleReceiver$3(subscriber);
    }

    static /* synthetic */ void access$lambda$4(WebSocketsConnectionProvider webSocketsConnectionProvider) {
        webSocketsConnectionProvider.lambda$getLifecycleReceiver$4();
    }
}

