/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp;

import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$1;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$4;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$5;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$6;
import ua.naiksoftware.stomp.WebSocketsConnectionProvider$$Lambda$7;

class WebSocketsConnectionProvider
implements ConnectionProvider {
    private static final String TAG = WebSocketsConnectionProvider.class.getSimpleName();
    private final String mUri;
    private final Map<String, String> mConnectHttpHeaders;
    private final List<FlowableEmitter<? super LifecycleEvent>> mLifecycleEmitters;
    private final List<FlowableEmitter<? super String>> mMessagesEmitters;
    private WebSocketClient mWebSocketClient;
    private boolean haveConnection;
    private TreeMap<String, String> mServerHandshakeHeaders;
    private final Object mLifecycleLock = new Object();

    WebSocketsConnectionProvider(String uri, Map<String, String> connectHttpHeaders) {
        this.mUri = uri;
        this.mConnectHttpHeaders = connectHttpHeaders != null ? connectHttpHeaders : new HashMap();
        this.mLifecycleEmitters = new ArrayList<FlowableEmitter<? super LifecycleEvent>>();
        this.mMessagesEmitters = new ArrayList<FlowableEmitter<? super String>>();
    }

    @Override
    public Flowable<String> messages() {
        List<FlowableEmitter<? super String>> list = this.mMessagesEmitters;
        list.getClass();
        Flowable flowable = Flowable.create((FlowableOnSubscribe)WebSocketsConnectionProvider$$Lambda$1.lambdaFactory$(list), (BackpressureStrategy)BackpressureStrategy.BUFFER).doOnCancel(WebSocketsConnectionProvider$$Lambda$4.lambdaFactory$(this));
        this.createWebSocketConnection();
        return flowable;
    }

    private void createWebSocketConnection() {
        if (this.haveConnection) {
            throw new IllegalStateException("Already have connection to web socket");
        }
        this.mWebSocketClient = new WebSocketClient(URI.create(this.mUri), (Draft)new Draft_17(), this.mConnectHttpHeaders, 0){

            public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
                Log.d((String)TAG, (String)("onWebsocketHandshakeReceivedAsClient with response: " + response.getHttpStatus() + " " + response.getHttpStatusMessage()));
                WebSocketsConnectionProvider.this.mServerHandshakeHeaders = new TreeMap();
                Iterator keys = response.iterateHttpFields();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    WebSocketsConnectionProvider.this.mServerHandshakeHeaders.put(key, response.getFieldValue(key));
                }
            }

            public void onOpen(ServerHandshake handshakeData) {
                Log.d((String)TAG, (String)("onOpen with handshakeData: " + handshakeData.getHttpStatus() + " " + handshakeData.getHttpStatusMessage()));
                LifecycleEvent openEvent = new LifecycleEvent(LifecycleEvent.Type.OPENED);
                openEvent.setHandshakeResponseHeaders(WebSocketsConnectionProvider.this.mServerHandshakeHeaders);
                WebSocketsConnectionProvider.this.emitLifecycleEvent(openEvent);
            }

            public void onMessage(String message) {
                Log.d((String)TAG, (String)("onMessage: " + message));
                WebSocketsConnectionProvider.this.emitMessage(message);
            }

            public void onClose(int code, String reason, boolean remote) {
                Log.d((String)TAG, (String)("onClose: code=" + code + " reason=" + reason + " remote=" + remote));
                WebSocketsConnectionProvider.this.haveConnection = false;
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.CLOSED));
            }

            public void onError(Exception ex) {
                Log.e((String)TAG, (String)"onError", (Throwable)ex);
                WebSocketsConnectionProvider.this.emitLifecycleEvent(new LifecycleEvent(LifecycleEvent.Type.ERROR, ex));
            }
        };
        if (this.mUri.startsWith("wss")) {
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, null, null);
                SSLSocketFactory factory = sc.getSocketFactory();
                this.mWebSocketClient.setSocket(factory.createSocket());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mWebSocketClient.connect();
        this.haveConnection = true;
    }

    @Override
    public Flowable<Void> send(String stompMessage) {
        return Flowable.create((FlowableOnSubscribe)WebSocketsConnectionProvider$$Lambda$5.lambdaFactory$(this, stompMessage), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitLifecycleEvent(LifecycleEvent lifecycleEvent) {
        Object object = this.mLifecycleLock;
        synchronized (object) {
            Log.d((String)TAG, (String)("Emit lifecycle event: " + lifecycleEvent.getType().name()));
            for (FlowableEmitter<? super LifecycleEvent> emitter : this.mLifecycleEmitters) {
                emitter.onNext((Object)lifecycleEvent);
            }
        }
    }

    private void emitMessage(String stompMessage) {
        Log.d((String)TAG, (String)("Emit STOMP message: " + stompMessage));
        for (FlowableEmitter<? super String> emitter : this.mMessagesEmitters) {
            emitter.onNext((Object)stompMessage);
        }
    }

    @Override
    public Flowable<LifecycleEvent> getLifecycleReceiver() {
        List<FlowableEmitter<? super LifecycleEvent>> list = this.mLifecycleEmitters;
        list.getClass();
        return Flowable.create((FlowableOnSubscribe)WebSocketsConnectionProvider$$Lambda$6.lambdaFactory$(list), (BackpressureStrategy)BackpressureStrategy.BUFFER).doOnCancel(WebSocketsConnectionProvider$$Lambda$7.lambdaFactory$(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    /* synthetic */ void lambda$getLifecycleReceiver$2() throws Exception {
        Object object = this.mLifecycleLock;
        synchronized (object) {
            Iterator<FlowableEmitter<? super LifecycleEvent>> iterator = this.mLifecycleEmitters.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isCancelled()) continue;
                iterator.remove();
            }
        }
    }

    /* synthetic */ void lambda$send$1(String stompMessage, FlowableEmitter emitter) throws Exception {
        if (this.mWebSocketClient == null) {
            emitter.onError((Throwable)new IllegalStateException("Not connected yet"));
        } else {
            Log.d((String)TAG, (String)("Send STOMP message: " + stompMessage));
            this.mWebSocketClient.send(stompMessage);
            emitter.onComplete();
        }
    }

    /* synthetic */ void lambda$messages$0() throws Exception {
        Iterator<FlowableEmitter<? super String>> iterator = this.mMessagesEmitters.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isCancelled()) continue;
            iterator.remove();
        }
        if (this.mMessagesEmitters.size() < 1) {
            Log.d((String)TAG, (String)("Close web socket connection now in thread " + Thread.currentThread()));
            this.mWebSocketClient.close();
        }
    }
}

