/*
 * Decompiled with CFR 0.152.
 */
package com.github.cropbitmap;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;

public class CropViewUtils {
    public static Bitmap compressBitmap(Context context, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
            int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
            inSampleSize = Math.max(heightRatio, widthRatio);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmap(BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options), reqWidth, reqHeight);
    }

    public static Bitmap compressBitmap(String pathName, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        int degree = CropViewUtils.readPictureDegree(pathName);
        if (CropViewUtils.is90And270(degree)) {
            reqWidth = reqHeight - reqWidth;
            reqHeight -= reqWidth;
            reqWidth = reqHeight + reqWidth;
        }
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
            int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
            inSampleSize = Math.max(heightRatio, widthRatio);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmap(BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options), reqWidth, reqHeight, degree);
    }

    public static Bitmap compressBitmap(byte[] data, int offset, int length, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
            int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
            inSampleSize = Math.max(heightRatio, widthRatio);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmap(BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options), reqWidth, reqHeight);
    }

    public static Bitmap compressBitmap(FileDescriptor fd, Rect outPadding, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
            int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
            inSampleSize = Math.max(heightRatio, widthRatio);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmap(BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options), reqWidth, reqHeight);
    }

    public static Bitmap compressBitmap(Resources res, TypedValue value, InputStream is, Rect pad, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
            int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
            inSampleSize = Math.max(heightRatio, widthRatio);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmap(BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options), reqWidth, reqHeight);
    }

    public static Bitmap compressBitmap(InputStream is, Rect outPadding, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = (int)Math.floor((float)height / (float)reqHeight);
            int widthRatio = (int)Math.floor((float)width / (float)reqWidth);
            inSampleSize = Math.max(heightRatio, widthRatio);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmap(BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options), reqWidth, reqHeight);
    }

    public static Bitmap compressBitmapForHeight(Context context, int resId, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight) {
            int heightRatio;
            inSampleSize = heightRatio = (int)Math.floor((float)height / (float)reqHeight);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForHeight(BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options), reqHeight);
    }

    public static Bitmap compressBitmapForHeight(String pathName, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int inSampleSize = 1;
        int degree = CropViewUtils.readPictureDegree(pathName);
        if (CropViewUtils.is90And270(degree)) {
            height = options.outWidth;
        }
        if (height > reqHeight) {
            int heightRatio;
            inSampleSize = heightRatio = (int)Math.floor((float)height / (float)reqHeight);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForHeight(BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options), reqHeight, degree);
    }

    public static Bitmap compressBitmapForHeight(byte[] data, int offset, int length, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight) {
            int heightRatio;
            inSampleSize = heightRatio = (int)Math.floor((float)height / (float)reqHeight);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForHeight(BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options), reqHeight);
    }

    public static Bitmap compressBitmapForHeight(FileDescriptor fd, Rect outPadding, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight) {
            int heightRatio;
            inSampleSize = heightRatio = (int)Math.floor((float)height / (float)reqHeight);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForHeight(BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options), reqHeight);
    }

    public static Bitmap compressBitmapForHeight(Resources res, TypedValue value, InputStream is, Rect pad, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight) {
            int heightRatio;
            inSampleSize = heightRatio = (int)Math.floor((float)height / (float)reqHeight);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForHeight(BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options), reqHeight);
    }

    public static Bitmap compressBitmapForHeight(InputStream is, Rect outPadding, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight) {
            int heightRatio;
            inSampleSize = heightRatio = (int)Math.floor((float)height / (float)reqHeight);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForHeight(BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options), reqHeight);
    }

    public static Bitmap compressBitmapForWidth(Context context, int resId, int reqWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int inSampleSize = 1;
        if (width > reqWidth) {
            int widthRatio;
            inSampleSize = widthRatio = (int)Math.floor((float)width / (float)reqWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForWidth(BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options), reqWidth);
    }

    public static Bitmap compressBitmapForWidth(String pathName, int reqWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int inSampleSize = 1;
        int degree = CropViewUtils.readPictureDegree(pathName);
        if (CropViewUtils.is90And270(degree)) {
            width = options.outHeight;
        }
        if (width > reqWidth) {
            int widthRatio;
            inSampleSize = widthRatio = (int)Math.floor((float)width / (float)reqWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForWidth(BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options), reqWidth, degree);
    }

    public static Bitmap compressBitmapForWidth(byte[] data, int offset, int length, int reqWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int inSampleSize = 1;
        if (width > reqWidth) {
            int widthRatio;
            inSampleSize = widthRatio = (int)Math.floor((float)width / (float)reqWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForWidth(BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options), reqWidth);
    }

    public static Bitmap compressBitmapForWidth(FileDescriptor fd, Rect outPadding, int reqWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int inSampleSize = 1;
        if (width > reqWidth) {
            int widthRatio;
            inSampleSize = widthRatio = (int)Math.floor((float)width / (float)reqWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForWidth(BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options), reqWidth);
    }

    public static Bitmap compressBitmapForWidth(Resources res, TypedValue value, InputStream is, Rect pad, int reqWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int inSampleSize = 1;
        if (width > reqWidth) {
            int widthRatio;
            inSampleSize = widthRatio = (int)Math.floor((float)width / (float)reqWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForWidth(BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options), reqWidth);
    }

    public static Bitmap compressBitmapForWidth(InputStream is, Rect outPadding, int reqWidth) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int inSampleSize = 1;
        if (width > reqWidth) {
            int widthRatio;
            inSampleSize = widthRatio = (int)Math.floor((float)width / (float)reqWidth);
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        return CropViewUtils.scaleBitmapForWidth(BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options), reqWidth);
    }

    public static Bitmap compressBitmapForScale(Context context, int resId, int scaleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleSize > 1 ? scaleSize : 1;
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBitmapForScale(String pathName, int scaleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleSize > 1 ? scaleSize : 1;
        int degree = CropViewUtils.readPictureDegree(pathName);
        if (CropViewUtils.is90And270(degree)) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
            Bitmap newBitmap = CropViewUtils.createBitmapForMatrix(bitmap, 1.0f, degree);
            return newBitmap;
        }
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBitmapForScale(byte[] data, int offset, int length, int scaleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleSize > 1 ? scaleSize : 1;
        return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBitmapForScale(FileDescriptor fd, Rect outPadding, int scaleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleSize > 1 ? scaleSize : 1;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBitmapForScale(Resources res, TypedValue value, InputStream is, Rect pad, int scaleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleSize > 1 ? scaleSize : 1;
        return BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
    }

    public static Bitmap compressBitmapForScale(InputStream is, Rect outPadding, int scaleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleSize > 1 ? scaleSize : 1;
        return BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
    }

    public static Bitmap scaleBitmapForWidth(Bitmap bitmap, int newWidth, int degree) {
        int bWidth = bitmap.getWidth();
        int bHeight = bitmap.getHeight();
        if (CropViewUtils.is90And270(degree)) {
            bWidth = bitmap.getHeight();
            bHeight = bitmap.getWidth();
        }
        float initScale = (float)newWidth * 1.0f / (float)bWidth;
        Bitmap newBitmap = CropViewUtils.createBitmapForMatrix(bitmap, initScale, degree);
        return newBitmap;
    }

    public static Bitmap scaleBitmapForWidth(Bitmap bitmap, int newWidth) {
        return CropViewUtils.scaleBitmapForWidth(bitmap, newWidth, 0);
    }

    public static Bitmap scaleBitmapForHeight(Bitmap bitmap, int newHeight, int degree) {
        int bWidth = bitmap.getWidth();
        int bHeight = bitmap.getHeight();
        if (CropViewUtils.is90And270(degree)) {
            bWidth = bitmap.getHeight();
            bHeight = bitmap.getWidth();
        }
        float initScale = (float)newHeight * 1.0f / (float)bHeight;
        Bitmap newBitmap = CropViewUtils.createBitmapForMatrix(bitmap, initScale, degree);
        return newBitmap;
    }

    public static Bitmap scaleBitmapForHeight(Bitmap bitmap, int newHeight) {
        return CropViewUtils.scaleBitmapForHeight(bitmap, newHeight, 0);
    }

    public static Bitmap scaleBitmap(Bitmap bitmap, int newWidth, int newHeight, int degree) {
        float initTranslateY;
        float initTranslateX;
        float initScale = 1.0f;
        if ((float)bitmap.getWidth() * 1.0f / (float)bitmap.getHeight() > (float)newWidth * 1.0f / (float)newHeight) {
            initScale = (float)newWidth * 1.0f / (float)bitmap.getWidth();
            initTranslateX = 0.0f;
            initTranslateY = ((float)newHeight - (float)bitmap.getHeight() * initScale) / 2.0f;
        } else {
            initScale = (float)newHeight * 1.0f / (float)bitmap.getHeight();
            initTranslateX = ((float)newWidth - (float)bitmap.getWidth() * initScale) / 2.0f;
            initTranslateY = 0.0f;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(initScale, initScale);
        matrix.postTranslate(initTranslateX, initTranslateY);
        Bitmap newBitmap = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawBitmap(bitmap, matrix, null);
        matrix.setRotate((float)degree);
        newBitmap = Bitmap.createBitmap((Bitmap)newBitmap, (int)0, (int)0, (int)newBitmap.getWidth(), (int)newBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return newBitmap;
    }

    public static Bitmap scaleBitmap(Bitmap bitmap, int newWidth, int newHeight) {
        return CropViewUtils.scaleBitmap(bitmap, newWidth, newHeight, 0);
    }

    public static int[] getBitmapSize(Resources res, int id) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static int[] getBitmapSize(byte[] data, int offset, int length) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static int[] getBitmapSize(String pathName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static int[] getBitmapSize(FileDescriptor fd, Rect outPadding) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static int[] getBitmapSize(Resources res, TypedValue value, InputStream is, Rect pad) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static int[] getBitmapSize(InputStream is, Rect outPadding) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static int readPictureDegree(String filePath) {
        int rotate = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(filePath);
            int result = exifInterface.getAttributeInt("Orientation", 0);
            switch (result) {
                case 6: {
                    rotate = 90;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 8: {
                    rotate = 270;
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rotate;
    }

    private static boolean is90And270(int degree) {
        return degree > 0 && (degree == 90 || degree % 270 == 0);
    }

    private static Bitmap createBitmapForMatrix(Bitmap bitmap, float initScale, int degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        matrix.postScale(initScale, initScale);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return newBitmap;
    }
}

