/*
 * Decompiled with CFR 0.152.
 */
package com.github.cropbitmap;

import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.github.cropbitmap.LikeXMCropViewUtils;

public class LikeXMCropView
extends View {
    private LikeXMCropViewUtils viewUtils;
    private GestureDetector gestureDetector;
    private int currentState = -1;
    private final int touch_status_bitmap = 0;
    private final int touch_status_left = 1;
    private final int touch_status_top = 2;
    private final int touch_status_right = 3;
    private final int touch_status_bottom = 4;
    private final int touch_status_left_top = 5;
    private final int touch_status_right_top = 6;
    private final int touch_status_left_bottom = 7;
    private final int touch_status_right_bottom = 8;
    private ValueAnimator animator;

    private void Log(String str) {
        Log.i((String)"===", (String)("@@===" + str));
    }

    public LikeXMCropView(Context context) {
        super(context);
        this.init(null);
    }

    public LikeXMCropView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LikeXMCropView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.viewUtils = new LikeXMCropViewUtils();
        this.viewUtils.touchWidth = this.dip2px(15.0f);
        this.viewUtils.borderDistance = this.viewUtils.touchWidth * 2.0f + (float)this.dip2px(20.0f);
        this.initGestureDetector();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.animator != null && this.animator.isRunning()) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.viewUtils.leftBorderTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 1;
                    this.viewUtils.touchOffsetX = event.getX() - this.viewUtils.cropRect.left;
                    break;
                }
                if (this.viewUtils.topBorderTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 2;
                    this.viewUtils.touchOffsetY = event.getY() - this.viewUtils.cropRect.top;
                    break;
                }
                if (this.viewUtils.rightBorderTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 3;
                    this.viewUtils.touchOffsetX = this.viewUtils.cropRect.right - event.getX();
                    break;
                }
                if (this.viewUtils.bottomBorderTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 4;
                    this.viewUtils.touchOffsetY = this.viewUtils.cropRect.bottom - event.getY();
                    break;
                }
                if (this.viewUtils.leftTopTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 5;
                    this.viewUtils.touchOffsetX = event.getX() - this.viewUtils.cropRect.left;
                    this.viewUtils.touchOffsetY = event.getY() - this.viewUtils.cropRect.top;
                    break;
                }
                if (this.viewUtils.rightTopTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 6;
                    this.viewUtils.touchOffsetX = this.viewUtils.cropRect.right - event.getX();
                    this.viewUtils.touchOffsetY = event.getY() - this.viewUtils.cropRect.top;
                    break;
                }
                if (this.viewUtils.leftBottomTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 7;
                    this.viewUtils.touchOffsetX = event.getX() - this.viewUtils.cropRect.left;
                    this.viewUtils.touchOffsetY = this.viewUtils.cropRect.bottom - event.getY();
                    break;
                }
                if (this.viewUtils.rightBottomTouchRect.contains(event.getX(), event.getY())) {
                    this.currentState = 8;
                    this.viewUtils.touchOffsetX = this.viewUtils.cropRect.right - event.getX();
                    this.viewUtils.touchOffsetY = this.viewUtils.cropRect.bottom - event.getY();
                    break;
                }
                if (!this.viewUtils.showBitmapRect.contains(event.getX(), event.getY())) break;
                this.currentState = 0;
                this.Log("===\u89e6\u6478\u56fe\u7247");
                break;
            }
            case 1: {
                this.viewUtils.refreshShowBitmapRect();
                if (this.currentState == 0) {
                    this.updateBitmapLocation();
                }
                if (this.currentState != 0 && this.currentState != -1) {
                    this.updateCropBorderLocation();
                }
                this.currentState = -1;
                break;
            }
        }
        this.gestureDetector.onTouchEvent(event);
        return true;
    }

    private void updateCropBorderLocation() {
        float rectWidth = this.viewUtils.cropRect.right - this.viewUtils.cropRect.left;
        float rectHeight = this.viewUtils.cropRect.bottom - this.viewUtils.cropRect.top;
        float offsetsX = 0.0f;
        float offsetsY = 0.0f;
        float scale = 1.0f;
        if (rectHeight < (float)this.getHeight() && rectWidth < (float)this.getWidth()) {
            offsetsX = this.viewUtils.cropRect.left + (float)this.getWidth() - this.viewUtils.cropRect.right;
            offsetsY = this.viewUtils.cropRect.top + (float)this.getHeight() - this.viewUtils.cropRect.bottom;
            scale = (float)this.getWidth() * 1.0f / rectWidth < (float)this.getHeight() * 1.0f / rectHeight ? (float)this.getWidth() * 1.0f / rectWidth : (float)this.getHeight() * 1.0f / rectHeight;
        } else if (rectHeight < (float)this.getHeight()) {
            offsetsY = this.viewUtils.cropRect.top + (float)this.getHeight() - this.viewUtils.cropRect.bottom;
        } else if (rectWidth < (float)this.getWidth()) {
            offsetsX = this.viewUtils.cropRect.left + (float)this.getWidth() - this.viewUtils.cropRect.right;
        }
        float translateX = 0.0f;
        float translateY = 0.0f;
        if (offsetsX != 0.0f) {
            translateX = offsetsX * 1.0f / 2.0f - this.viewUtils.cropRect.left;
        }
        if (offsetsY != 0.0f) {
            translateY = offsetsY * 1.0f / 2.0f - this.viewUtils.cropRect.top;
        }
        RectF beforeRectF = new RectF(this.viewUtils.cropRect);
        RectF afterRectF = new RectF(this.viewUtils.cropRect);
        Matrix matrix = new Matrix();
        matrix.postTranslate(translateX, translateY);
        matrix.postScale(scale, scale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        matrix.mapRect(afterRectF);
        PropertyValuesHolder dst1X = PropertyValuesHolder.ofFloat((String)"dst1X", (float[])new float[]{this.viewUtils.cropRect.left, afterRectF.left});
        PropertyValuesHolder dst1Y = PropertyValuesHolder.ofFloat((String)"dst1Y", (float[])new float[]{this.viewUtils.cropRect.top, afterRectF.top});
        PropertyValuesHolder dst2X = PropertyValuesHolder.ofFloat((String)"dst2X", (float[])new float[]{this.viewUtils.cropRect.right, afterRectF.right});
        PropertyValuesHolder dst2Y = PropertyValuesHolder.ofFloat((String)"dst2Y", (float[])new float[]{this.viewUtils.cropRect.top, afterRectF.top});
        PropertyValuesHolder dst3X = PropertyValuesHolder.ofFloat((String)"dst3X", (float[])new float[]{this.viewUtils.cropRect.right, afterRectF.right});
        PropertyValuesHolder dst3Y = PropertyValuesHolder.ofFloat((String)"dst3Y", (float[])new float[]{this.viewUtils.cropRect.bottom, afterRectF.bottom});
        this.animator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{dst1X, dst1Y, dst2X, dst2Y, dst3X, dst3Y});
        final float[] dst = new float[]{beforeRectF.left, beforeRectF.top, beforeRectF.right, beforeRectF.top, beforeRectF.right, beforeRectF.bottom};
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float dst1X = ((Float)animation.getAnimatedValue("dst1X")).floatValue();
                float dst1Y = ((Float)animation.getAnimatedValue("dst1Y")).floatValue();
                float dst2X = ((Float)animation.getAnimatedValue("dst2X")).floatValue();
                float dst2Y = ((Float)animation.getAnimatedValue("dst2Y")).floatValue();
                float dst3X = ((Float)animation.getAnimatedValue("dst3X")).floatValue();
                float dst3Y = ((Float)animation.getAnimatedValue("dst3Y")).floatValue();
                Matrix tempMatrix = new Matrix();
                tempMatrix.setPolyToPoly(dst, 0, new float[]{dst1X, dst1Y, dst2X, dst2Y, dst3X, dst3Y}, 0, 3);
                ((LikeXMCropView)LikeXMCropView.this).viewUtils.showBitmapMatrix.postConcat(tempMatrix);
                ((LikeXMCropView)LikeXMCropView.this).viewUtils.cropRect.left = dst1X;
                ((LikeXMCropView)LikeXMCropView.this).viewUtils.cropRect.top = dst1Y;
                ((LikeXMCropView)LikeXMCropView.this).viewUtils.cropRect.right = dst2X;
                ((LikeXMCropView)LikeXMCropView.this).viewUtils.cropRect.bottom = dst3Y;
                LikeXMCropView.this.viewUtils.refreshCropPath();
                LikeXMCropView.this.viewUtils.refreshTouchBorder(((LikeXMCropView)LikeXMCropView.this).viewUtils.cropRect);
                LikeXMCropView.this.viewUtils.refreshShowBitmapRect();
                dst[0] = dst1X;
                dst[1] = dst1Y;
                dst[2] = dst2X;
                dst[3] = dst2Y;
                dst[4] = dst3X;
                dst[5] = dst3Y;
                LikeXMCropView.this.invalidate();
            }
        });
        this.animator.setDuration(410L);
        this.animator.setInterpolator(null);
        this.animator.start();
    }

    private void updateBitmapLocation() {
        float tempX = 0.0f;
        float tempY = 0.0f;
        if (this.viewUtils.showBitmapRect.left > this.viewUtils.cropRect.left) {
            tempX = this.viewUtils.cropRect.left - this.viewUtils.showBitmapRect.left;
        } else if (this.viewUtils.showBitmapRect.right < this.viewUtils.cropRect.right) {
            tempX = this.viewUtils.cropRect.right - this.viewUtils.showBitmapRect.right;
        }
        if (this.viewUtils.showBitmapRect.top > this.viewUtils.cropRect.top) {
            tempY = this.viewUtils.cropRect.top - this.viewUtils.showBitmapRect.top;
        } else if (this.viewUtils.showBitmapRect.bottom < this.viewUtils.cropRect.bottom) {
            tempY = this.viewUtils.cropRect.bottom - this.viewUtils.showBitmapRect.bottom;
        }
        if (tempX != 0.0f || tempY != 0.0f) {
            float trans_x = this.getShowBitmapMatrixAttr(2);
            float trans_y = this.getShowBitmapMatrixAttr(5);
            PropertyValuesHolder holderX = PropertyValuesHolder.ofFloat((String)"x", (float[])new float[]{0.0f, tempX});
            PropertyValuesHolder holderY = PropertyValuesHolder.ofFloat((String)"y", (float[])new float[]{0.0f, tempY});
            this.animator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{holderX, holderY});
            final float[] beforeX = new float[]{0.0f};
            final float[] beforeY = new float[]{0.0f};
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float x = ((Float)animation.getAnimatedValue("x")).floatValue();
                    float y = ((Float)animation.getAnimatedValue("y")).floatValue();
                    ((LikeXMCropView)LikeXMCropView.this).viewUtils.showBitmapMatrix.postTranslate(x - beforeX[0], y - beforeY[0]);
                    beforeX[0] = x;
                    beforeY[0] = y;
                    LikeXMCropView.this.viewUtils.refreshShowBitmapRect();
                    LikeXMCropView.this.invalidate();
                }
            });
            this.animator.setDuration(400L);
            this.animator.start();
        }
    }

    private float getShowBitmapMatrixAttr(int flag) {
        float[] values = new float[9];
        this.viewUtils.showBitmapMatrix.getValues(values);
        return values[flag];
    }

    private float getMatrixAttr(Matrix matrix, int flag) {
        float[] values = new float[9];
        matrix.getValues(values);
        return values[flag];
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewUtils.centerX = w / 2;
        this.viewUtils.centerY = h / 2;
        this.viewUtils.viewWidth = w;
        this.viewUtils.viewHeight = h;
        this.viewUtils.initScale = 1.0f;
        if ((float)this.viewUtils.showBitmap.getWidth() * 1.0f / (float)this.viewUtils.showBitmap.getHeight() > (float)w * 1.0f / (float)h) {
            this.viewUtils.initScale = (float)w * 1.0f / (float)this.viewUtils.showBitmap.getWidth();
            this.viewUtils.needMoveX = 0.0f;
            this.viewUtils.needMoveY = 1.0f * ((float)h - (float)this.viewUtils.showBitmap.getHeight() * this.viewUtils.initScale) / 2.0f;
        } else {
            this.viewUtils.initScale = (float)h * 1.0f / (float)this.viewUtils.showBitmap.getHeight();
            this.viewUtils.needMoveX = 1.0f * ((float)w - (float)this.viewUtils.showBitmap.getWidth() * this.viewUtils.initScale) / 2.0f;
            this.viewUtils.needMoveY = 0.0f;
        }
        this.viewUtils.prepare();
        this.viewUtils.showBitmapRect.set(0.0f, 0.0f, (float)this.viewUtils.showBitmap.getWidth(), (float)this.viewUtils.showBitmap.getHeight());
        this.viewUtils.showBitmapMatrix.postScale(this.viewUtils.initScale, this.viewUtils.initScale);
        this.viewUtils.showBitmapMatrix.postTranslate(this.viewUtils.needMoveX, this.viewUtils.needMoveY);
        this.viewUtils.showBitmapMatrix.mapRect(this.viewUtils.showBitmapRect);
        this.Log(this.viewUtils.showBitmapRect.toString());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.viewUtils.showBitmap, this.viewUtils.showBitmapMatrix, null);
        canvas.drawPath(this.viewUtils.cropPath, this.viewUtils.cropPaint);
        canvas.drawPath(this.viewUtils.maskLayerPath, this.viewUtils.maskLayerPaint);
        canvas.drawRect(this.viewUtils.leftBorderTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.topBorderTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.rightBorderTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.bottomBorderTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.leftTopTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.rightTopTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.leftBottomTouchRect, this.viewUtils.cropPaint);
        canvas.drawRect(this.viewUtils.rightBottomTouchRect, this.viewUtils.cropPaint);
    }

    public void setBitMap(Bitmap bitmap) {
        this.viewUtils.showBitmap = bitmap;
    }

    private void prepare() {
    }

    private int dip2px(float dipValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private void initGestureDetector() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                switch (LikeXMCropView.this.currentState) {
                    case 1: {
                        LikeXMCropView.this.moveLeftBorder(distanceX, e2);
                        break;
                    }
                    case 2: {
                        LikeXMCropView.this.moveTopBorder(distanceY, e2);
                        break;
                    }
                    case 3: {
                        LikeXMCropView.this.moveRightBorder(distanceX, e2);
                        break;
                    }
                    case 4: {
                        LikeXMCropView.this.moveBottomBorder(distanceY, e2);
                        break;
                    }
                    case 5: {
                        LikeXMCropView.this.moveLeftBorder(distanceX, e2);
                        LikeXMCropView.this.moveTopBorder(distanceY, e2);
                        break;
                    }
                    case 6: {
                        LikeXMCropView.this.moveTopBorder(distanceY, e2);
                        LikeXMCropView.this.moveRightBorder(distanceX, e2);
                        break;
                    }
                    case 7: {
                        LikeXMCropView.this.moveLeftBorder(distanceX, e2);
                        LikeXMCropView.this.moveBottomBorder(distanceY, e2);
                        break;
                    }
                    case 8: {
                        LikeXMCropView.this.moveRightBorder(distanceX, e2);
                        LikeXMCropView.this.moveBottomBorder(distanceY, e2);
                    }
                }
                LikeXMCropView.this.viewUtils.refreshCropPath();
                LikeXMCropView.this.viewUtils.refreshTouchBorder(((LikeXMCropView)LikeXMCropView.this).viewUtils.cropRect);
                if (0 == LikeXMCropView.this.currentState) {
                    ((LikeXMCropView)LikeXMCropView.this).viewUtils.showBitmapMatrix.postTranslate(-distanceX, -distanceY);
                }
                LikeXMCropView.this.invalidate();
                return true;
            }
        });
    }

    private void moveBottomBorder(float distanceY, MotionEvent e2) {
        if (distanceY < 0.0f) {
            if (this.viewUtils.cropRect.bottom <= this.viewUtils.showBitmapRect.bottom && this.viewUtils.cropRect.bottom < (float)this.getHeight() && this.isCanExpandCrop() && this.viewUtils.cropRect.bottom - this.viewUtils.touchOffsetY <= e2.getY()) {
                float tempDistance = Math.min(this.viewUtils.showBitmapRect.bottom - this.viewUtils.cropRect.bottom, Math.abs(distanceY));
                tempDistance = Math.min(tempDistance, (float)this.getHeight() - this.viewUtils.cropRect.bottom);
                this.viewUtils.cropRect.bottom += tempDistance;
            }
        } else if (this.viewUtils.cropRect.bottom - this.viewUtils.touchOffsetY >= e2.getY()) {
            if (this.viewUtils.cropRect.top + this.viewUtils.borderDistance + Math.abs(distanceY) > this.viewUtils.cropRect.bottom) {
                float tempDistance = this.viewUtils.cropRect.bottom - this.viewUtils.cropRect.top - this.viewUtils.borderDistance;
                this.viewUtils.cropRect.bottom = this.getCropBottom(tempDistance);
            } else {
                this.viewUtils.cropRect.bottom = this.getCropBottom(Math.abs(distanceY));
            }
        }
    }

    private void moveRightBorder(float distanceX, MotionEvent e2) {
        if (distanceX < 0.0f) {
            if (this.viewUtils.cropRect.right <= this.viewUtils.showBitmapRect.right && this.viewUtils.cropRect.right < (float)this.getWidth() && this.isCanExpandCrop() && this.viewUtils.cropRect.right - this.viewUtils.touchOffsetX <= e2.getX()) {
                float tempDistance = Math.min(this.viewUtils.showBitmapRect.right - this.viewUtils.cropRect.right, Math.abs(distanceX));
                tempDistance = Math.min((float)this.getWidth() - this.viewUtils.cropRect.right, tempDistance);
                this.viewUtils.cropRect.right += tempDistance;
            }
        } else if (this.viewUtils.cropRect.right - this.viewUtils.touchOffsetX >= e2.getX()) {
            if (this.viewUtils.cropRect.left + this.viewUtils.borderDistance + Math.abs(distanceX) > this.viewUtils.cropRect.right) {
                float tempDistance = this.viewUtils.cropRect.right - this.viewUtils.cropRect.left - this.viewUtils.borderDistance;
                this.viewUtils.cropRect.right = this.getCropRight(tempDistance);
            } else {
                this.viewUtils.cropRect.right = this.getCropRight(Math.abs(distanceX));
            }
        }
    }

    private void moveTopBorder(float distanceY, MotionEvent e2) {
        if (distanceY > 0.0f) {
            if (this.viewUtils.cropRect.top >= this.viewUtils.showBitmapRect.top && this.viewUtils.cropRect.top > 0.0f && this.isCanExpandCrop() && this.viewUtils.cropRect.top + this.viewUtils.touchOffsetY >= e2.getY()) {
                float distance = Math.min(Math.abs(distanceY), Math.abs(this.viewUtils.cropRect.top - this.viewUtils.showBitmapRect.top));
                distance = Math.min(distance, this.viewUtils.cropRect.top);
                this.viewUtils.cropRect.top -= distance;
            }
        } else if (this.viewUtils.cropRect.top + this.viewUtils.touchOffsetY <= e2.getY()) {
            if (this.viewUtils.cropRect.top + Math.abs(distanceY) + this.viewUtils.borderDistance > this.viewUtils.cropRect.bottom) {
                float tempDistance = this.viewUtils.cropRect.bottom - this.viewUtils.borderDistance - this.viewUtils.cropRect.top;
                this.viewUtils.cropRect.top = this.getCropTop(tempDistance);
            } else {
                this.viewUtils.cropRect.top = this.getCropTop(Math.abs(distanceY));
            }
        }
    }

    private void moveLeftBorder(float distanceX, MotionEvent e2) {
        if (distanceX > 0.0f) {
            if (this.viewUtils.cropRect.left >= this.viewUtils.showBitmapRect.left && this.viewUtils.cropRect.left > 0.0f && this.isCanExpandCrop() && this.viewUtils.cropRect.left + this.viewUtils.touchOffsetX >= e2.getX()) {
                float distance = Math.min(Math.abs(distanceX), Math.abs(this.viewUtils.cropRect.left - this.viewUtils.showBitmapRect.left));
                distance = Math.min(distance, this.viewUtils.cropRect.left);
                if (this.isCropForRatio()) {
                    float ratioDistance = distance * this.viewUtils.heightRatio / this.viewUtils.widthRatio * 10.0f;
                    ratioDistance = Math.min(ratioDistance, 2.0f * Math.abs(this.viewUtils.cropRect.top - this.viewUtils.getBitmapRect().top));
                    if ((ratioDistance = Math.min(ratioDistance, 2.0f * Math.abs(this.viewUtils.getBitmapRect().bottom - this.viewUtils.cropRect.bottom))) != 0.0f) {
                        this.viewUtils.cropRect.top -= ratioDistance / 2.0f;
                        this.viewUtils.cropRect.bottom += ratioDistance / 2.0f;
                        if (this.viewUtils.cropRect.top < 0.0f) {
                            float topMove = Math.abs(this.viewUtils.cropRect.top);
                            float leftMove = topMove * 2.0f * this.viewUtils.widthRatio / this.viewUtils.heightRatio;
                            float lengthX = this.viewUtils.cropRect.right - this.viewUtils.getBitmapRect().left;
                            float scaleY = ((float)this.getHeight() * 1.0f / 2.0f - this.viewUtils.getBitmapRect().top - topMove) / ((float)this.getHeight() * 1.0f / 2.0f - this.viewUtils.getBitmapRect().top);
                            float scaleX = (leftMove + this.viewUtils.cropRect.right - this.viewUtils.cropRect.left) / lengthX;
                            float x = this.viewUtils.cropRect.right;
                            float y = (this.viewUtils.cropRect.bottom - this.viewUtils.cropRect.top) / 2.0f;
                            this.viewUtils.showBitmapMatrix.postScale(scaleY, scaleY, x, (float)this.getHeight() * 1.0f / 2.0f);
                            ratioDistance = (ratioDistance / 2.0f + this.viewUtils.cropRect.top) * 2.0f;
                            this.viewUtils.cropRect.top = 0.0f;
                            this.viewUtils.cropRect.bottom = this.getHeight();
                        }
                        distance = ratioDistance * this.viewUtils.widthRatio / this.viewUtils.heightRatio;
                        this.viewUtils.cropRect.left -= distance;
                    }
                } else {
                    this.viewUtils.cropRect.left -= distance;
                }
            }
        } else if (this.viewUtils.cropRect.left + this.viewUtils.touchOffsetX <= e2.getX()) {
            float distance;
            if (this.viewUtils.cropRect.left + Math.abs(distanceX) + this.viewUtils.borderDistance > this.viewUtils.cropRect.right) {
                float tempDistance = this.viewUtils.cropRect.right - this.viewUtils.borderDistance - this.viewUtils.cropRect.left;
                this.viewUtils.cropRect.left = this.getCropLeft(tempDistance);
                distance = tempDistance;
            } else {
                this.viewUtils.cropRect.left = this.getCropLeft(Math.abs(distanceX));
                distance = Math.abs(distanceX);
            }
            if (this.isCropForRatio()) {
                distance = distance * this.viewUtils.heightRatio / this.viewUtils.widthRatio;
                this.viewUtils.cropRect.top += distance / 2.0f;
                this.viewUtils.cropRect.bottom -= distance / 2.0f;
            }
        }
    }

    private float getCropLeft(float tempDistance) {
        float tempLeft = this.viewUtils.cropRect.left + tempDistance;
        if (this.viewUtils.cropRect.right - tempLeft >= this.viewUtils.getMinCropWidth()) {
            return tempLeft;
        }
        this.viewUtils.cropRect.left = this.viewUtils.cropRect.right - this.viewUtils.getMinCropWidth();
        return this.viewUtils.cropRect.left;
    }

    private float getCropTop(float tempDistance) {
        float tempTop = this.viewUtils.cropRect.top + tempDistance;
        if (this.viewUtils.cropRect.bottom - tempTop >= this.viewUtils.getMinCropWidth()) {
            return tempTop;
        }
        return this.viewUtils.cropRect.bottom - this.viewUtils.getMinCropWidth();
    }

    private float getCropRight(float tempDistance) {
        float tempRight = this.viewUtils.cropRect.right - tempDistance;
        if (tempRight - this.viewUtils.cropRect.left >= this.viewUtils.getMinCropWidth()) {
            return tempRight;
        }
        return this.viewUtils.cropRect.left + this.viewUtils.getMinCropWidth();
    }

    private float getCropBottom(float tempDistance) {
        float tempBottom = this.viewUtils.cropRect.bottom - tempDistance;
        if (tempBottom - this.viewUtils.cropRect.top >= this.viewUtils.getMinCropWidth()) {
            return tempBottom;
        }
        return this.viewUtils.cropRect.top + this.viewUtils.getMinCropWidth();
    }

    private boolean isCanExpandCrop() {
        boolean flag = true;
        RectF bitmapRect = this.viewUtils.getBitmapRect();
        if (this.viewUtils.widthRatio > 0.0f && this.viewUtils.heightRatio > 0.0f) {
            if (this.viewUtils.cropRect.left <= bitmapRect.left && this.viewUtils.cropRect.right >= bitmapRect.right) {
                flag = false;
            }
            if (this.viewUtils.cropRect.top <= bitmapRect.top && this.viewUtils.cropRect.bottom >= bitmapRect.bottom) {
                flag = false;
            }
        }
        return flag;
    }

    private boolean isCropForRatio() {
        return this.viewUtils.widthRatio > 0.0f && this.viewUtils.heightRatio > 0.0f;
    }
}

